import QtQuick 2.1
import com.galileosky.cppclasses 1.0

Rectangle {
    id: delegate
    width: Math.round(216 * kDPI)
    height: Math.round(240 * kDPI)
    color: "#ffffff"

    property alias caption: captionItem.text
    property alias imageSource: imageItem.source
    property alias videoSource: videoIcon.source
    property alias description: descriptionItem.text
    property bool isVideo: false
    property alias videoLength: length.text

    BorderImage {
        id: image1
        x: Math.round(11 * kDPI)
        y: Math.round(8 * kDPI)
        width: Math.round(196 * kDPI)
        height: Math.round(153 * kDPI)
        anchors.horizontalCenter: parent.horizontalCenter
        border.bottom: Math.round(4 * kDPI)
        border.right:  Math.round(4 * kDPI)
        border.top:    Math.round(4 * kDPI)
        border.left:   Math.round(4 * kDPI)
        source: "images/dropshadow.png"

        Image {
            id: imageItem

            visible: !delegate.isVideo
            anchors.fill: parent
            asynchronous: true
            sourceSize.height: Math.round(145 * kDPI)
            sourceSize.width: Math.round(188 * kDPI)
            fillMode: Image.Center
        }

        Image {
            id: videoIcon

            visible: delegate.isVideo
            anchors.fill: parent
            anchors.margins: standardMargin
            asynchronous: true
            fillMode: Image.PreserveAspectFit
        }

        NativeText {
            id: length

            visible: delegate.isVideo
            x: Math.round(87 * kDPI)
            y: Math.round(130 * kDPI)
            color: "#555555"
            text: delegate.videoLength
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.margins: Math.round(5 * kDPI)
            anchors.rightMargin: standardMargin
            font.bold: true
            font.family: "Helvetica"
            font.pointSize: 14
        }
    }

    Rectangle {
        id: rectangle2
        y: Math.round(191 * kDPI)
        width: Math.round(200 * kDPI)
        height: Math.round(69 * kDPI)
        radius: Math.round(8 * kDPI)
        color: "#ffffff"
        anchors.bottom: parent.bottom
        anchors.right: parent.right
        anchors.left: parent.left
    }

    NativeText {
        id: captionItem
        x: Math.round(16 * kDPI)
        y: Math.round(170 * kDPI)
        color: "#000000"
        text: qsTr("2D PAINTING EXAMPLE long description")
        elide: Text.ElideRight
        anchors.right: parent.right
        anchors.rightMargin: Math.round(16 * kDPI)
        anchors.left: parent.left
        anchors.leftMargin: Math.round(16 * kDPI)
        wrapMode: Text.WordWrap
        maximumLineCount: 2
        font.family: "Verdana"
        font.pointSize: 10
    }

    NativeText {
        id: descriptionItem
        height: Math.round(43 * kDPI)
        color: "#7e7e7e"
        text: qsTr("The 2D Painting example shows how QPainter and QGLWidget work together.")
        anchors.top: captionItem.bottom
        anchors.topMargin: Math.round(10 * kDPI)
        opacity: 0
        anchors.left: parent.left
        anchors.leftMargin: Math.round(16 * kDPI)
        anchors.right: parent.right
        anchors.rightMargin: Math.round(16 * kDPI)
        wrapMode: Text.WordWrap
        font.family: "Verdana"
        font.pointSize: 8
        horizontalAlignment: Text.AlignJustify
        maximumLineCount: 8
    }

    Rectangle {
        id: rectangle3
        x: Math.round(10 * kDPI)
        height: Math.round(1 * kDPI)
        color: "#dddcdc"
        visible: false
        anchors.top: captionItem.bottom
        anchors.topMargin: Math.round(4 * kDPI)
        anchors.rightMargin: Math.round(10 * kDPI)
        anchors.right: parent.right
        anchors.leftMargin: Math.round(10 * kDPI)
        anchors.left: parent.left
    }


    Rectangle {
        id: border
        color: "#00000000"
        radius: Math.round(6 * kDPI)
        anchors.rightMargin:  Math.round(4 * kDPI)
        anchors.leftMargin:   Math.round(4 * kDPI)
        anchors.bottomMargin: Math.round(4 * kDPI)
        anchors.topMargin: Math.round(1 * kDPI)
        visible: false
        anchors.fill: parent
        border.color: "#dddcdc"
    }


    MouseArea {
        id: mousearea1
        anchors.fill: parent
        hoverEnabled: true
        cursorShape: Qt.PointingHandCursor
        onEntered: {
            delegate.state="hover"
        }

        onExited: {
            delegate.state=""
        }

        onClicked: {
            var oldPauseAnimation = pauseAnimation.duration
            pauseAnimation.duration = 10;
            delegate.state = ""
            pauseAnimation.duration = oldPauseAnimation;
            scriptGenerator.showVideoTutorial(model.videoId, caption);
        }

    }


    states: [
        State {
            name: "hover"

            PropertyChanges {
                target: rectangle2
                x: 0
                y: Math.round(4 * kDPI)
                width: Math.round(216 * kDPI)
                height: Math.round(236 * kDPI)
            }

            PropertyChanges {
                target: captionItem
                y: Math.round(14 * kDPI)
                maximumLineCount: 2
            }

            PropertyChanges {
                target: descriptionItem
                opacity: 1
            }

            PropertyChanges {
                target: rectangle3
                x: Math.round(10 * kDPI)
                y: Math.round(52 * kDPI)
                visible: true
                anchors.rightMargin: Math.round(10 * kDPI)
                anchors.leftMargin: Math.round(10 * kDPI)
            }

            PropertyChanges {
                target: border
                visible: true
            }
        }
    ]

    transitions: [
        Transition {
            from: ""
            to: "hover"
            SequentialAnimation {
                PauseAnimation { id: pauseAnimation; duration: 200  }
                ParallelAnimation {

                    PropertyAnimation {
                        properties: "y, height"
                        duration: 100
                    }
                    SequentialAnimation {
                        PropertyAction {
                            property: "maximumLineCount"
                        }

                        PauseAnimation { duration: 60 }
                        PropertyAnimation {
                            properties: "opacity"
                            duration: 150
                        }
                    }
                }
            }
        },
        Transition {
            from: "hover"
            to: ""
            SequentialAnimation {
                PauseAnimation { duration: 100  }

                ParallelAnimation {
                    PropertyAnimation {
                        properties: "opacity"
                        duration: 60
                    }
                    SequentialAnimation {
                        PauseAnimation { duration: 60 }
                        PropertyAction {
                            property: "maximumLineCount"
                        }
                        PropertyAnimation {
                            properties: "y, height"
                            duration: 100
                        }
                    }
                }
            }
        }
    ]
}
