/// Auxiliary purpose function

/// loading component from \a source and creating object from it
/// \return object created by Qt.createObject() or null
function loadAndCreate(source, parent)
{
    var component = Qt.createComponent(source);
    console.debug("Component creation:\n",
                  "\turl:", component.url, "\n",
                  "\tstatus:", component.status, "\n",
                  "\terrorString:", component.errorString);

    if (component.status !== Component.Ready)
        return null;

    var object = component.createObject(parent)
    if (object === null) {
        console.debug(arguments.callee.name, "createObject(): error");
    }

    return object;
}

// функция клонирования простых объектов JavaScript
function clone(obj)
{
    if(obj === null || typeof(obj) != 'object')
    {
        return obj;
    }
    var temp = {};
    for(var key in obj)
    {
        temp[key] = clone(obj[key]);
    }
    return temp;
}
