import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_WriteTag"

    // unique for every action
    actionId: 0x10
    actionName: QT_TRANSLATE_NOOP("WriteTag", "WriteTag")
    actionTitle: qsTr("Write tag:\n??? = ???")
    actionToolTip: qsTr("Write value to specified tag")

    parameterDialogSource: 'InitVarDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        // <- insert position
        ListElement {
            paramName: QT_TRANSLATE_NOOP("WriteTag", "Value")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        parametersModel.insert(0,
                    {
                        "paramName": qsTranslate("WriteTag", "DstVar"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : qsTranslate("WriteTag", "User tag 0"),
                                "desc"    : qsTranslate("WriteTag", "User tag 0"),
                                "value"   : 0x62
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 1"),
                                "desc"    : qsTranslate("WriteTag", "User tag 1"),
                                "value"   : 0x63
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 2"),
                                "desc"    : qsTranslate("WriteTag", "User tag 2"),
                                "value"   : 0x64
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 3"),
                                "desc"    : qsTranslate("WriteTag", "User tag 3"),
                                "value"   : 0x65
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 4"),
                                "desc"    : qsTranslate("WriteTag", "User tag 4"),
                                "value"   : 0x66
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 5"),
                                "desc"    : qsTranslate("WriteTag", "User tag 5"),
                                "value"   : 0x67
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 6"),
                                "desc"    : qsTranslate("WriteTag", "User tag 6"),
                                "value"   : 0x68
                            },
                            {
                                "varName" : qsTranslate("WriteTag", "User tag 7"),
                                "desc"    : qsTranslate("WriteTag", "User tag 7"),
                                "value"   : 0x69
                            }]
                    });
    }

    function setTitle() {
        var dstStr = parametersModel.get(0).varName
        var srcStr = parametersModel.get(1).varName

        if (dstStr.length === 0)
            dstStr = qsTr("???")

        if (srcStr.length === 0)
            srcStr = qsTr("???")

        actionTitle = qsTr("Write tag:\n%1 = %2").arg(dstStr).arg(srcStr)
    }
}
