import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableIridiumModem"

    // unique for every action
    actionId: 0x17
    actionName: QT_TRANSLATE_NOOP("EnableIridiumModem", "EnableIridiumModem")
    actionTitle: qsTr("Iridium modem:\nEnable = ???")
    actionToolTip: qsTr("Enable Iridium modem")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableIridiumModem", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable Iridium modem");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable Iridium modem");
        else
            actionTitle = qsTr("Iridium modem:\nEnable = %1").arg(enableStr);
    }
}
