import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: addCanFilterDialog
    objectName: "AddCanFilterDialog"

    property int leftParamWidth: Math.round(140 * kDPI)
    property int textWidth: Math.round(100 * kDPI)

    width: leftParamWidth
           + textWidth
           + parameterItemSpacing * 1
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        // Функция отвечающя за применение окончательного размера окна диалога
        // Если нужно поменять размер - данные нужно менять в ней.
        var l_height = titleHeight
                + parameterItemHeight*5
                + parameterItemSpacing*3

        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView

        ColumnLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: parameterItemSpacing * 2

            Row {
                id: conditionLayout

                height: parameterItemHeight
                width: addCanFilterDialog.width

                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTr("Identifier");
                }

                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 0
                }

            }
            Row {
                height: parameterItemHeight
                width: addCanFilterDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTr("Mask");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 1
                }
            }
            Row {
                height: parameterItemHeight
                width: addCanFilterDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTr("Identifier Bits\n Length");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 2
                }
            }
            Row {
                height: parameterItemHeight
                width: addCanFilterDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTr("Interface");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 3
                }
            }
        }
    }
}
