import { LOGGER_LEVEL, LOGGER_METHODS } from '../constants/logger';

class Logger {
  private static _isEnabled = process.env.LOGGING === 'true';

  private static _print = (message: string, level: LOGGER_LEVEL): void => {
    if (!this._isEnabled) {
      return;
    }

    const method = LOGGER_METHODS[level];

    method(message);
  };

  public static log = (message: string): void => {
    this._print(`[LOG] ${message}`, LOGGER_LEVEL.LOG);
  };

  public static info = (message: string): void => {
    this._print(`[INFO] ${message}`, LOGGER_LEVEL.INFO);
  };

  public static warn = (message: string): void => {
    this._print(`[WARN] ${message}`, LOGGER_LEVEL.WARN);
  };

  public static error = (message: string): void => {
    this._print(`[ERR] ${message}`, LOGGER_LEVEL.ERROR);
  };
}

export default Logger;
