# React Input 

Страница с полем ввода для отправки команд на терминал через Конфигуратор

## Установка для разработки

- Node.js@16.17.0
- npm@8.15.0

1. git clone
2. yarn install --frozen-lockfile
3. npm run prepare (если не было выполнено автоматически)

Для установки node.js следует использовать менеджер версий (fnm, volta, asdf).

## Запуск и сборка

Запустить проект в режиме разработки можно при помощи команды

```bash
npm run dev
```

В файле переменных окружения `.env` указываются параметры. В частности, флаг включения логирования

```sh
LOGGING=true
```

Сборка осуществляется командой

```bash
npm run build
```

Перед сборкой директорию `dist` следует удалить.

## Проверка кода на наличие ошибок

Для проверки кода в проекте настроен `eslint`. Для добавленных файлов проверка выполняется автоматически при создании нового коммита. Если необходимо проверить весь код проекта в ручном режиме, то можно выполнить:

- `npm run lint-all` для проверки кода на соответствие общим стандартам

## Форматирование кода

Для форматирования используется `prettier`. Настройки уже подключены в проекте, можно использовать плагин для редактора, либо команду `npm run pretty`. При добавлении коммита обновленные файлы будут отформатированы принудительно.

При написании кода следует руководствоваться имеющимися компонентами и структурой проекта.

## Структура

React-компоненты находятся в директории `src/components`. Класс для работы с QWebChannel и вспомогательные классы находятся в директории `src/util`.
