import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetUserArraySize"

    // unique for every action
    actionId: 0x24
    actionName: QT_TRANSLATE_NOOP("SetUserArraySize", "SetUserArraySize")
    actionTitle: qsTr("Set user array size = ???")
    actionToolTip: qsTr("Set user array size")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SetUserArraySize", "Size")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var str = parametersModel.get(0).varName

        if (str.length === 0)
            str = qsTr("???")
	    
        actionTitle = qsTr("Set user array size = %1").arg(str)
    }
}
