import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetFlagOfInvalidCoordinates"

    // unique for every action
    actionId: 0x28
    actionName: QT_TRANSLATE_NOOP("SetFlagOfInvalidCoordinates", "SetFlagOfInvalidCoordinates")
    actionTitle: qsTr("Set flag of invalid coordinates:\n???")
    actionToolTip: qsTr("Forcibly invalidate coordinates")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: qsTr("Forcibly invalidate coordinates")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
            var disable = parametersModel.get(0).varName;

            if (disable.length === 0)
                disable = qsTr("???")
            
            if (disable === "0")
                actionTitle = qsTr("Check the validity of coordinates");
            else if (disable === "1")
                actionTitle = qsTr("Forcibly invalidate coordinates");
            else
                actionTitle = qsTr("Wrong value");
    }
}
