import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SemaphoreGive"

    // unique for every action
    actionId: 0x27
    actionName: QT_TRANSLATE_NOOP("SemaphoreGive", "SemaphoreGive")
    actionTitle: qsTr("Give semaphore:\n???")
    actionToolTip: qsTr("Give semaphore")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SemaphoreGive", "Index (0..4)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }        
    }

    function setTitle() {
        var index = parametersModel.get(0).varName        
        if (index.length === 0)
            index = qsTr("???")
        actionTitle = qsTr("Give semaphore: \nIndex: %1").arg(index)
    }
}
