import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_SamplingPeriodFilter"

    // unique for every action
    actionId: 0x0B
    actionName: QT_TRANSLATE_NOOP("SamplingPeriodFilter", "SamplingPeriodFilter")
    actionTitle: baseTitle
    actionToolTip: qsTr("Time between processed values")
    actionOutputCount: 1

    property string baseTitle: qsTr("SamplingPeriodFilter")

    parameterDialogSource: 'SimpleFilterDialog.qml'

    actionType: "action"
    view_type: view_types.one_input_filter
    need_check_tar_table: false

    parametersModel: ListModel {

        onDataChanged: {
            setTitle();
            sendResultToNext();
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SamplingPeriodFilter", "Parameter")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Time between processed values [ms]")
            paramType: "int"
            varCategory: "const"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SamplingPeriodFilter", "Result")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
    }

    function setTitle() {
            var opStr = parametersModel.get(1).varName
            actionTitle = opStr.length === 0 ? baseTitle : qsTr("%1 %2 [ms]").arg(baseTitle).arg(opStr);
        }
}
