import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: makePhoto
    objectName: "diagramAction_MakePhoto"

    // unique for every action
    actionId: 0x11
    actionName: QT_TRANSLATE_NOOP("MakePhoto", "MakePhoto")
    actionTitle: qsTr("Make photo:\nPort: ???")
    actionToolTip: qsTr("Make photo by photocamera on specified port")

    parametersModel: ListModel {
        onDataChanged: setTitle()
    }

    Component.onCompleted: {
        parametersModel.append(
                    {
                        "paramName": qsTranslate("MakePhoto", "Port"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : "RS232_0",
                                "desc"    : qsTranslate("MakePhoto", "RS232_0"),
                                "value"   : 0
                            },
                            {
                                "varName" : "RS232_1",
                                "desc"    : qsTranslate("MakePhoto", "RS232_1"),
                                "value"   : 1
                            },
                            {
                                "varName" : "RS485",
                                "desc"    : qsTranslate("MakePhoto", "RS485"),
                                "value"   : 2
                            }]
                    });
    }

    function setTitle() {
        var portNumStr  = parametersModel.get(0).varName

        if (portNumStr.length === 0)
            portNumStr = qsTr("???")

        actionTitle = qsTr("Make photo:\nPort: %1").arg(portNumStr)
    }
}
