import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_CopyBytesToUserArray"

    // unique for every action
    actionId: 0x22
    actionName: QT_TRANSLATE_NOOP("CopyBytesToUserArray", "CopyBytesToUserArray")
    actionTitle: qsTr("Copy bytes to user array:\n???")
    actionToolTip: qsTr("Copy bytes to user array")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("CopyBytesToUserArray", "SrcVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("CopyBytesToUserArray", "Offset in array")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("CopyBytesToUserArray", "Bytes count")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var varStr = parametersModel.get(0).varName
        var offsetStr = parametersModel.get(1).varName
	var countStr = parametersModel.get(2).varName

        if (varStr.length === 0)
            varStr = qsTr("???")

        if (offsetStr.length === 0)
            offsetStr = qsTr("???")

        if (countStr.length === 0)
            countStr = qsTr("???")
	    
        actionTitle = qsTr("Copy %1 bytes from %3 to user array in position %2").arg(countStr).arg(offsetStr).arg(varStr);
    }
}
