import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: systemParameterDialog
    objectName: "systemParameterDialog"

    property int leftParamWidth: Math.round(150 * kDPI)

    width: leftParamWidth
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        // Функция отвечающя за применение окончательного размера окна диалога
        // Если нужно поменять размер - данные нужно менять в ней.
        var l_height = titleHeight
                + parameterItemHeight*3
                + parameterItemSpacing

        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView

        ColumnLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: parameterItemSpacing * 2

            Row {
                id: conditionLayout

                height: parameterItemHeight
                width: systemParameterDialog.width

                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 0
                }
            }
        }
    }
}
