import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1

FocusScope {
    id: actionsToolBar
    
    property alias actionModel: listView.model // позволяет задавать модель напрямую через alias
    property alias actionTitle: panelButton.text

    height: column.height
    
    Column {
        id: column

        width: parent.width

        Rectangle {
            anchors.left: parent.left
            anchors.right: parent.right
            height: panelCaptionHeight
            color: colorGroup
            border.width: 1
            border.color: colorScrollBorder

            ActionToolButton {
                id: panelButton

                anchors.fill: parent
            }
        }
        ListView {
            id: listView
            objectName: "listView"

            anchors.left: parent.left
            anchors.right: parent.right
            height: panelButton.checked ? (Math.round(24 * kDPI) * count) : 0
            visible: true // изначально панель развернута
            delegate: ActionsDelegate {}
            interactive: false
            onHeightChanged: { visible = (height !== 0) } //нужно для того, чтобы скрыть нулевой итем
                                                          //почему то при height == 0, он не скрывается

            Behavior on height {
                NumberAnimation {
                    easing.type: Easing.OutQuad
                }
            }
        }
    }
}
