import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1

ButtonStyle {

    property int checkedAngle: 90
    property int uncheckedAngle: 0
    property int animationDuration: 250

    background: Item {}
    label: Item {
        anchors.fill: parent
        anchors.margins: Math.round(6 * kDPI)        
        Rectangle {
            id: invisibleRectangle
            anchors.left: parent.left
            width:  Math.round(16 * kDPI)
            height: parent.height
            color: colorGroup
        }
        Image {
            id: buttonImageSubgroup
            objectName: "triangleImage"
            anchors.left: invisibleRectangle.right
            anchors.verticalCenter: parent.verticalCenter
            source: "images/fold-right-small.png"
            rotation: control.checked ? checkedAngle : uncheckedAngle
            sourceSize.width: Math.round(12 * kDPI)
            sourceSize.height: Math.round(12 * kDPI)
            opacity: 0.8    // decrease blackness
            
            Behavior on rotation {
                NumberAnimation {
                    easing.type: Easing.Linear
                    duration: animationDuration
                }
            }
        }
        Text {
            id: buttonName
            anchors.left: buttonImageSubgroup.right
            anchors.leftMargin: 6
            anchors.right: parent.right
            anchors.verticalCenter: parent.verticalCenter
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            elide: Text.ElideRight
            font.family: "Verdana"
            font.pointSize: 8
            font.letterSpacing: 0.5
            color: colorTextPanel
            text: control.text
        }
    }
}
