import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1

ButtonStyle {
    property int checkedAngle: 90
    property int uncheckedAngle: 0
    property int animationDuration: 250

    background: Item {}
    label: Item {
        anchors.fill: parent
        anchors.margins: Math.round(6 * kDPI)
        Image {
            id: buttonImage
            objectName: "diagnosticsImage"
            
            anchors.verticalCenter: parent.verticalCenter
            source: "images/fold-right.png"
            rotation: control.checked ? checkedAngle : uncheckedAngle
            sourceSize.width: imageHeight
            sourceSize.height: imageHeight
            opacity: 0.8    // decrease blackness
            
            Behavior on rotation {
                NumberAnimation {
                    easing.type: Easing.Linear
                    duration: animationDuration
                }
            }
        }
        Text {
            id: buttonName
            anchors.left: buttonImage.right
            anchors.leftMargin: 6
            anchors.right: parent.right
            anchors.verticalCenter: parent.verticalCenter
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            elide: Text.ElideRight
            font.family: "Verdana"
            font.pointSize: 10
            font.letterSpacing: 0.5
            color: colorTextPanel
            text: control.text
        }
    }
}
