import React from 'react';
import Button, { IButtonProps } from '../Button';

const SubmitButton: React.FC<IButtonProps> = ({ disabled, ...buttonAttrs }) => {
  const handleClick: React.MouseEventHandler<HTMLButtonElement> = (event) => {
    if (disabled) {
      event.preventDefault();
      event.stopPropagation();
    }
  };

  return (
    <Button
      {...buttonAttrs}
      type="submit"
      onClick={handleClick}
      disabled={disabled}
    >
      send
    </Button>
  );
};

export default SubmitButton;
