import QtQuick 2.1
import QtQuick.Controls 1.0

ScrollView {

    property alias model: gridView.model

    GridView {
        id: gridView

        anchors.fill: parent

        interactive: false
        cellHeight: Math.round(240 * kDPI)
        cellWidth: Math.round(216 * kDPI)

        layoutDirection: Qt.RightToLeft

        delegate: Delegate {
            id: delegate

            imageSource: model.imageSource
            videoSource: model.videoSource

            caption: model.name;
            description: model.description
            isVideo: model.isVideo === true
            videoLength: model.videoLength !== undefined ? model.videoLength : ""
        }
    }
}
