import QtQuick 2.2
import QtQuick.Controls 1.4
import QtQuick.Layouts 1.1

Item {
    id: window
    objectName: 'window'
    width: 1000
    height: 600

    readonly property string categoryConst:        "const"
    readonly property string categoryGlobal:       "global"
    readonly property string categoryLocalConst:   "localConst"
    readonly property string categoryLocal:        "local"
    readonly property string categoryList:         "list"
    readonly property string categoryCanIndex:     "canIndex"

    readonly property string typeInt:           "int"
    readonly property string typeString:        "string"
    readonly property string typeScript:        "script"

    property color colorOk:     "lightgreen"
    property color colorModified: "gold"
    property color colorError:  "orangered"
    property color colorWorking:"powderblue"
    property color colorOther:  "lightgray"
    property color colorDragPoint: "silver"
    property color colorDiagramBackground: "#C0C0C0"
    property color colorDiagramField:  "#f9f8f5"
    property color colorDiagramGrid:   "#c4c4c5"
    property color colorDiagramLine:   "#78888E"
    property color colorHandle:     "#909090"
    property color colorPanel:      "#C4C4C4"
    property color colorBorder:     "#B0B0B0"
    property color colorStatus:     "#F0F0F0"
    property color colorGroup:      "#F0F0F0"
    property color colorWhitespace: "#FFFFFF"
    property color colorToolbarButton: "#ECECEC"
    property color colorToolbarButtonDisabled: "#b3b3b3"
    property color colorToolbarButtonHovered: "#0099ff"
    property color colorToolbarButtonShadow: "#878787"
    property color colorEditing:    "#93C1E5"
    property color colorTextEditing:"#FFFFFF"
    property color colorHovered: "white"
    property color colorEvent:        "#FFFFFF"
    property color colorAction:       "#FFFFFF"
    property color colorActionFinish: "#FFFFFF"
    property color colorTextDisabled:     "gray"
    property color colorTextPanel:        "#303030"
    //property color colorTextEvent:        "#55BE08"
    property color colorTextEvent:        "#43B076"
    //property color colorTextAction:       "#0093CB"
    property color colorTextAction:       "#00AADC"
    //property color colorTextActionFinish: "#DD2B1C"
    property color colorTextActionFinish: "#9B4696"
    property color colorScrollBackground: "#ECECEC"
    property color colorScrollBorder:     "#D8D8D8"
    property color colorScrollHandle:     "#C4C4C4"
    property color colorSelected: "#00A0E3"
    property color colorLineHovered: "#0060E3"
    property color colorPageSelectorCurrentLeft:  "#F5F3EE"
    property color colorPageSelectorCurrentRight: "#E4E1DA"
    property color colorPageSelectorLeft:  "#F7F6F3"
    property color colorPageSelectorRight: "#E2DFD9"
    property color colorPageSelectorBorder: "#A0A0A0"
    property color colorPageSelectorText:  "#151616"
    property color colorChainDefault: "gray"
    property color colorDialogBackground: "white"
    property color colorDialogBorder:     "gray"
    property real kDPI: logicalDPI / 96.0
    property real zDiagramObjectOnHiddenPage: 0
    property real zDiagramContainerRect:    0
    property real zDiagramMouseArea:        1
    property real zDiagramField:            10
    property real zDiagramLine:             10
    property real zDiagramObject:           20
    property real zParameterDialog:         30
    property real zDiagramSelectRect:       80
    property real zVarPanel:                90
    property real zToolbar:                 100
    property real zDiagramDraggingObject:   1000

    property int diagramFieldWidth: Math.round(diagramFieldHeight * Math.SQRT2)
    property int diagramFieldHeight: Math.round(4000 * kDPI)
    property int toolbarHeight: Math.round(92 * kDPI)
    property int panelCaptionHeight: Math.round(36 * kDPI)
    property int pageViewHeight: Math.round(32 * kDPI)
    readonly property int imageHeight: Math.round(16 * kDPI)
    property int titleHeight: Math.round(20 * kDPI)
    property int standardMargin: Math.round(8 * kDPI)
    property int parameterItemHeight: Math.round(22 * kDPI)
    property int parameterItemSpacing: standardMargin / 4
    property int parameterItemMargins: standardMargin / 2
    property int regularThickness: 2
    property int hoveredThickness: 3
    property int selectedThickness: 4
    property int tutorialsMargins: Math.round(12 * kDPI)

    readonly property int dialogWindowFlags: Qt.Dialog | Qt.WindowTitleHint | (appStayOnTop ? Qt.WindowStaysOnTopHint : 0)
    readonly property int buttonsTimerInterval: 250

    property bool leftPanelInteractive: true

    function saveDiagram() {
        if (diagramContainer.diagramModified === true) {
            console.debug("Modified diagram saving is needed");
        }
    }

    Rectangle {
        id: windowRect
        objectName: "windowRect"

        anchors.fill: parent
        color: colorPanel
    }

    ColumnLayout {
        id: statusLayout
        objectName: "statusLayout"

        anchors.fill: parent
        spacing: 0

        SplitView {
            id: mainLayout
            objectName: "mainLayout"

            Layout.fillWidth: true
            Layout.fillHeight: true

            handleDelegate: Component {
                Item {
                    // <=1 - cause to wider hover mouse area on TouchScreens
                    width: 2
                }
            }

            FocusScope {
                id: leftItem
                objectName: "leftItem"

                Layout.minimumWidth: Math.round(128 * kDPI)
                Layout.maximumWidth: Math.round(300 * kDPI)
                Layout.fillHeight: true
                implicitWidth: Math.round(200 * kDPI)

                ColumnLayout{
                    id: leftPanelLayout
                    objectName: "leftPanelLayout"

                    anchors.fill: parent
                    spacing: 0

                    TextRect {
                        id: titleRect
                        objectName: "titleRect"

                        Layout.fillWidth: true
                        Layout.minimumHeight: toolbarHeight
                        Layout.maximumHeight: toolbarHeight

                        color: colorPanel

                        text: diagramContainer.diagramNameUserData
                        textPointSize: 12
                        textLetterSpacing: 1.0

                        onAccepted: diagramContainer.diagramNameUserData = text;
                    }

                    LeftPanel {
                        id: leftPanel
                        objectName: "leftPanel"
                        eventsAreEnabled: true
                        actionsAreEnabled: true
                        globalVarsAreEnabled: true
                        Layout.fillWidth: true
                        Layout.fillHeight: true
                    }
                }
            }
            DiagramContainer {
                id: diagramContainer
                objectName: "diagramContainer"

                Layout.fillWidth: true
                Layout.fillHeight: true
            }
        }
        StatusPanel {
            id: statusPanel
            objectName: "statusPanel"

            Layout.fillWidth: true
            implicitHeight: panelCaptionHeight
        }
    }

    // Tutorials "page"
    Item {
        id: tutorialsItem
        objectName: "tutorialsItem"

        anchors.fill: parent
        visible: scriptGenerator.tutorialsShown

        Rectangle {
            id: tutorialsShadowRect
            anchors.fill: parent
            color: "gray"
            opacity: 0.5
        }
        MouseArea {
            anchors.fill: parent
            onPressed: mouse.accepted = true    // don't process mouse presses further
            onClicked: scriptGenerator.setTutorialsShown(false)
        }

        Loader {
            id: loader_Tutorials
            anchors.fill: parent
            source: scriptGenerator.tutorialsShown ? "scripterhelp/Tutorials.qml" : ""
        }
    }
}
