import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetSIM"

    // unique for every action
    actionId: 0x29
    actionName: QT_TRANSLATE_NOOP("SetSIM", "SetSIM")
    actionTitle: qsTr("SIM-cards switching:\n???")
    actionToolTip: qsTr("SIM-cards switching")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        Component.onCompleted: {
            parametersModel.append(
            {
                "paramName": qsTranslate("SetSIM", "Use SIM-card"),
                "paramType": categoryList,
                "varCategory": categoryList,
                "varName": "CAN0",
                "varBaseCategory": "",
                "isEditable": false,
                "paramList" :
                    [{
                        "varName" : "SIM0",
                        "value"   : 0
                    },
                    {
                        "varName" : "SIM1",
                        "value"   : 1
                    }]
            });
        }
    }

    function setTitle() {
        var name = parametersModel.get(0).varName

        if (name.length === 0)
            actionTitle = qsTr("???")

        if (name === "SIM0")
            actionTitle = qsTr("Use SIM0");
        else if (name === "SIM1")
            actionTitle = qsTr("Use SIM1");
        else
            actionTitle = qsTr("Use SIM: wrong index");
    }
}
