import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SemaphoreTake"

    // unique for every action
    actionId: 0x26
    actionName: QT_TRANSLATE_NOOP("SemaphoreTake", "SemaphoreTake")
    actionTitle: qsTr("Take semaphore:\n???")
    actionToolTip: qsTr("Take semaphore")
    actionOutputCount: 2
    actionFormType: Action.ActionForm.Rhomb

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SemaphoreTake", "Index (0..4)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SemaphoreTake", "Timeout, ms (0..60000)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var index = parametersModel.get(0).varName
        var timeout = parametersModel.get(1).varName
        if (index.length === 0)
            index = qsTr("???")
        if (timeout.length === 0)
            timeout = qsTr("???")
        actionTitle = qsTr("Take semaphore: \nIndex: %1\nTimeout: %2 ms").arg(index).arg(timeout)
    }
}
