import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: playAudioFile
    objectName: "diagramAction_PlayAudioFile"

    // unique for every action
    actionId: 0x0E
    actionName: QT_TRANSLATE_NOOP("PlayAudioFile", "PlayAudioFile")
    actionTitle: qsTr("PlayAudioFile:\n???")
    actionToolTip: qsTr("Play audio file")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("PlayAudioFile", "File")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        actionTitle = qsTr("PlayAudioFile:\n\"%1\"").arg(parametersModel.get(0).varName);
    }
}
