import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_IntegrationFilter"

    // unique for every action
    actionId: 0x07
    actionName: QT_TRANSLATE_NOOP("IntegrationFilter", "IntegrationFilter")
    actionTitle: qsTr("Integration")
    actionToolTip: qsTr("Integration Filter")

    parameterDialogSource: 'none.qml'
    
    actionType: "action"
    view_type: view_types.two_inputs_filter
    need_check_tar_table: false

    inputs_lables: [qsTr("variable"), qsTr("null event")];

    parametersModel: ListModel {

        onDataChanged: {
            sendResultToNext();
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("IntegrationFilter", "Variable")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("IntegrationFilter", "NullEvent")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        // <- insert position
        ListElement {
            paramName: QT_TRANSLATE_NOOP("IntegrationFilter", "ResultVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
    }
}
