import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_InitVar"

    // unique for every action
    actionId: 0x02
    actionName: QT_TRANSLATE_NOOP("InitVar", "InitVar")
    actionTitle: qsTr("Init var:\n??? = ???")
    actionToolTip: qsTr("Global var initialization")

    parameterDialogSource: 'InitVarDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("InitVar", "DstVar")
            paramType: "int|float|string"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("InitVar", "SrcVar")
            paramType: "int|float|string"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var dstStr = parametersModel.get(0).varName
        var srcStr = parametersModel.get(1).varName

        if (dstStr.length === 0)
            dstStr = qsTr("???")

        if (srcStr.length === 0)
            srcStr = qsTr("???")

        actionTitle = qsTr("%1 = %2").arg(dstStr).arg(srcStr)
    }
}
