import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramEvent
    objectName: "diagramEvent_IncomingSMS"

    // unique for every event
    actionId: 0x01
    actionName: QT_TRANSLATE_NOOP("IncomingSMS", "IncomingSMS")
    actionTitle: qsTr("IncomingSMS:\n???")
    actionToolTip: qsTr("Incoming SMS has been registered")

    actionType: "systemEvent"
    actionColor: colorEvent
    actionTextColor: colorTextEvent

    permanentParametersCount: 2
    nonPermanentParameterName: QT_TRANSLATE_NOOP("IncomingSMS", "Phone")
    nonPermanentParamType: "string"
    nonPermanentVarCategory: "(global|const)"

    parametersModel: ListModel {

        onDataChanged:  setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("IncomingSMS", "SMS filter")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        parametersModel.append(
                    {
                        "paramName": qsTranslate("IncomingSMS", "Authorized numbers"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "Disabled",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : qsTranslate("IncomingSMS", "Disabled"),
                                "desc"    : qsTranslate("IncomingSMS", "Don\'t generate event for authorized numbers"),
                                "value"   : 0
                            },
                            {
                                "varName" : qsTranslate("IncomingSMS", "Enabled"),
                                "desc"    : qsTranslate("IncomingSMS", "Generate event for authorized numbers"),
                                "value"   : 1
                            }]
                    });
    }

    function setTitle() {
        var str = qsTr("IncomingSMS:\n\"%1\"")
                .arg(parametersModel.get(0).varName);
        var strNumbers = "";
        if (parametersModel.get(1).varName === qsTranslate("IncomingSMS", "Enabled"))
            strNumbers += qsTr("\nAuthorized numbers")
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            strNumbers += "\n" + parametersModel.get(i).varName;
        }

        if (strNumbers.length)
            actionTitle = str + qsTr("\nNumbers:") + strNumbers;
        else
            actionTitle = str + qsTr("\nNumbers: ANY_NUMBER");
    }
}
