import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableSleepMode"

    // unique for every action
    actionId: 0x0C
    actionName: QT_TRANSLATE_NOOP("EnableSleepMode", "EnableSleepMode")
    actionTitle: qsTr("SleepMode:\n???")
    actionToolTip: qsTr("Enable sleep mode")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableSleepMode", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable SleepMode");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable SleepMode");
        else
            actionTitle = qsTr("SleepMode = %1").arg(enableStr);
    }
}
