import QtQuick 2.2
import QtQuick.Dialogs 1.1
import "lineItemCreation.js" as Code

Item {
    id: dragPoint
    
    property Item dragItem: null    // parent action of the dragPoint
    readonly property int pointTypeFalse: 0
    readonly property int pointTypeTrue:  1
    property int pointType: -1          // 0 - "false", 1 - "true"
    property string pointPosition       /// \sa outputLineFalsePosition
    property bool textVisible: false    // true must be set for Condition action

    property var outputLine: null   // Connected line object
    property string outputLinePosition: pointPosition   // default for true dragPoint

    property int radius: Math.round(8 * kDPI)
    property alias decoratorVisible: dragPointDecorator.visible
    property bool showImage: false
    property alias containsMouse: dragMouseArea.containsMouse
    
    signal dragPosChanged(Item item, point dragPoint)

    width: radius * 2
    height: radius * 2
    
    onDragPosChanged: console.debug('onDragPosChanged:' + dragPoint)
    
    Text {  // is situated outside of parent
        id: dragPointText
        objectName: "dragPointText"

        anchors.left: (pointType === pointTypeTrue)
                      ? dragPoint.right
                      : (pointPosition === "left")
                        ? dragPoint.left
                        : undefined
        anchors.leftMargin: (pointType === pointTypeTrue)
                            ? Math.round(2 * kDPI)
                            : 0
        anchors.right: ((pointType === pointTypeFalse)
                        && (pointPosition === "right"))
                       ? dragPoint.right
                       : undefined
        anchors.bottom: (pointType === pointTypeTrue)
                        ? dragPoint.bottom
                        : dragPoint.top
        anchors.bottomMargin: (pointType === pointTypeTrue)
                              ? 0
                              : Math.round(2 * kDPI)
        color: colorTextPanel
        text: (pointType === pointTypeTrue) ? qsTr("True") : qsTr("False")
        visible: textVisible
                 && (dragPoint.containsMouse
                     || ((dragPoint.pointPosition === dragPoint.outputLinePosition)
                         && (null !== dragPoint.outputLine)))
    }
    Rectangle {
        id: dragPointDecorator
        objectName: "dragPointDecorator"
        
        anchors.fill: parent
        radius: dragPoint.radius
        color: colorDragPoint
        border.color: colorDiagramField
        border.width: 2
    }
    Image {
        id: dragPointImage
        objectName: "dragPointImage"
        
        anchors.fill: parent
        source: (null !== dragPoint.outputLine) ? "../images/icon_del.svg" : "../images/icon_add.svg"
        sourceSize.width: Math.round(128* kDPI)
        sourceSize.height: Math.round(128 * kDPI)
        visible: dragPoint.showImage && dragMouseArea.containsMouse
    }
    MouseArea {
        id: dragMouseArea
        objectName: "dragMouseArea"
        anchors.fill: parent
        hoverEnabled: true
        
        onPressed: {
            console.debug('diagramItem: ' + diagramItem.x + ' ' + diagramItem.y)
            console.debug('dragPoint:   ' + dragPoint.x + ' ' + dragPoint.y)
            if (null !== dragPoint.outputLine)
                dragPoint.outputLine.destroyItem()
            if (dragPoint.dragItem !== null)
                dragPoint.dragItem.destroyButtons();

            Code.startDrag(dragPoint, 'DiagramLine.qml', mouse);
        }
        onPositionChanged: {
            Code.continueDrag(mouse);
            if (dragMouseArea.pressed)
                dragPoint.dragPosChanged(dragPoint, Qt.point(mouseX, mouseY))
        }
        onReleased: {
            Code.endDrag(mouse);
        }
        onCanceled: {
            Code.cancelDrag();
        }
    }
}
