import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_DeltaFilter"

    // unique for every action
    actionId: 0x08
    actionName: QT_TRANSLATE_NOOP("DeltaFilter", "DeltaFilter")
    actionTitle: qsTr("DeltaFilter")

    parameterDialogSource: 'none.qml'

    actionType: "action"
    view_type: view_types.one_input_filter
    need_check_tar_table: false

    function generatePreviousValue()  {
        if (parametersModel.get(1).varName === "") {
            var prev_var_name = Code.getOrGenerateVarName(diagramAction, "prev");
            parametersModel.set(1, {"varName":prev_var_name, "varBaseCategory":categoryGlobal});
        }
    }

    parametersModel: ListModel {

        onDataChanged: sendResultToNext();


        ListElement {
            paramName: QT_TRANSLATE_NOOP("DeltaFilter", "Parameter")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Previous value")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("DeltaFilter", "Result")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
    }
}
