﻿import QtQuick 2.4
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1
import QtQuick.Window 2.2
import Qt.labs.settings 1.0
import com.galileosky.cppclasses 1.0

Window {
    id: varNameDialog
    objectName: "varNameDialog"

    property string varName: ""                     // already accepted varName
    property string varType: ""                     // type of already accepted varName
    property string varCategory: ""                 // category of already accepted varName
    property string varBaseCategory:  ""            // базовая категория переменной (а не фильтр в случае с varCategory)
    property string varAllowance: ""                // Это штука для определения нужно ли применять дополнительный тип разрешения
                                                    // В нашем случае пока это сделано для фильтров.

    property alias localVarName: varNameInput.text  // current user choise
    property string localVarBaseCategory: ""            // current category

    signal accepted(var varName, var varCategory)
    signal rejected()


    function destroyDialog() {
        varNameDialog.visible = false;
        destroy();
    }

    function setGroupVarName(newVarName, newVarCategory) {
        // update group model index (var model indexes binded to group one)
        var varGroup = varsModel.getVarGroup(newVarName, newVarCategory);
        console.debug(varGroup);
        if (varGroups.indexOf(varGroup) === -1)
            groupView.currentIndex = 0;
        else
            groupView.currentIndex = varGroups.indexOf(varGroup);
        console.debug(arguments.callee.name, groupView.currentIndex, localVarBaseCategory);
    }

    function setLocalVarName(newVarName, newVarCategory) {
        console.debug(arguments.callee.name, newVarName);

        if ((localVarName !== newVarName) || (localVarBaseCategory !==newVarCategory))
        {
            localVarName = newVarName;
            localVarBaseCategory = newVarCategory;
        }
        console.debug("base category ", varNameDialog.varBaseCategory);
    }

    flags: dialogWindowFlags

    title: "varNameDialog"
    modality: Qt.ApplicationModal

    minimumWidth: Math.round(300 * kDPI)
    minimumHeight: Math.round(200 * kDPI)
    width:Math.round(750 * kDPI)
    height: Math.round(400 * kDPI)

    onAccepted: destroyDialog();
    onRejected: destroyDialog();

    Component.onCompleted:
    {

       varNameDialog.x = varNameDialog.screen.virtualX + varNameDialog.screen.width / 2 - varNameDialog.width / 2;
       varNameDialog.y = varNameDialog.screen.virtualY + varNameDialog.screen.height / 2 - varNameDialog.height / 2;

       console.debug(objectName, "onCompleted");
    }
    Component.onDestruction: console.debug(objectName, "onDestruction");

    Settings {
        category: "varNameDialog"
        property alias x: varNameDialog.x
        property alias y: varNameDialog.y
        property alias width: varNameDialog.width
        property alias height: varNameDialog.height
    }

    Item {
        id: keyHandlerItem
        objectName: "keyHandlerItem"

        anchors.fill: parent
        anchors.margins: 1
        focus: true

        Keys.onEscapePressed: rejected();
        Keys.onEnterPressed: accepted(localVarName);
        Keys.onReturnPressed: accepted(localVarName);
    }

    ColumnLayout {
        id: windowLayout

        anchors.fill: parent
        anchors.margins: parameterItemMargins

        Rectangle {
            id: varNameRect
            objectName: "varNameRect"

            Layout.fillWidth: true
            implicitHeight: parameterItemHeight

            radius: Math.round(2 * kDPI)
            border.color:  (localVarName.length > 0)
                           ? (localVarName !== varName)
                                ? colorModified :
                                 ((localVarBaseCategory.length > 0) ? ((localVarBaseCategory !== varBaseCategory) ? colorModified : colorOk) : colorOk)
                           : colorError
            border.width: 2

            TextInput {
                id: varNameInput
                objectName: "varNameInput"

                anchors.fill: parent
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                clip: true
                color: colorPageSelectorText
                font.pointSize: 9
                activeFocusOnPress: false
            }
        }

        Rectangle {
            id: varsRect

            Layout.fillWidth: true
            Layout.fillHeight: true
            border.width: 1
            border.color: colorScrollBorder

            RowLayout {
                id: varsLayout

                anchors.fill: parent
                anchors.margins: Math.round(1 * kDPI)
                anchors.rightMargin: Math.round(4 * kDPI)

                ScrollView {
                    id: groupScrollView

                    implicitWidth: 200
                    Layout.fillHeight: true
                    flickableItem.interactive: leftPanelInteractive
                    flickableItem.flickableDirection: Flickable.VerticalFlick
                    style: MyScrollViewStyle {}

                    ListView {
                        id: groupView

                        width: parent.width
                        height: Math.round(36 * kDPI) * count
                        model: varGroups
                        delegate: VarNameDelegate {
                            height: Math.round(36 * kDPI)
                            font.pointSize: 9
                            text: qsTranslate("VarModel", model.modelData)
                        }

                        Component.onCompleted: {
                            currentIndex = -1;
                        }
                    }
                }
                ScrollView {
                    id: varScrollView

                    implicitWidth: 400
                    Layout.fillHeight: true
                    flickableItem.interactive: leftPanelInteractive
                    flickableItem.flickableDirection: Flickable.VerticalFlick
                    style: MyScrollViewStyle {}

                    ListView {
                        id: varView
                        objectName: "varView"

                        width: parent.width
                        height: Math.round(22 * kDPI) * count
                        interactive: false
                        model: (groupView.currentIndex !== -1)
                               ? scriptGenerator.getProxyVarModel(groupView.currentIndex)
                               : null
                        delegate: VarNameDelegate {
                            parent: varView
                            onClicked: {

                                setLocalVarName(clickedText, clickedCategory);
                            }
                            onDoubleClicked: {
                                accepted(clickedText, clickedCategory);
                            }
                        }

                        onModelChanged: {
                            if (varView.model !== null) {
                                varView.model.filterType = varType;
                                varView.model.filterCategory = varCategory;
                                varView.model.filterAllowance = varAllowance;
                            }

                            varView.currentIndex =
                                    (varView.model === null)
                                    ? -1
                                    : varView.model.getVarId(localVarName, localVarBaseCategory);
                            console.debug(objectName, "onModelChanged:",
                                          varType, varView.currentIndex);
                        }
                    }
                }
                Text {
                    id: varDescription
                    Layout.fillWidth: true
                    Layout.fillHeight: true
                    wrapMode: Text.Wrap
                    text: (varView.currentIndex === -1)
                          ? ""
                          : varView.model.getVarDescription(localVarName, localVarBaseCategory);
                }
            }
        }
        RowLayout {
            id: buttonsLayout

            Layout.fillWidth: true

            Item {
                objectName: "spacer"
                Layout.fillWidth: true
            }
            Button {
                id: okButton
                objectName: "okButton"

                isDefault: true
                text: qsTr("OK");

                onClicked: {
                    console.debug(objectName, "onClicked:", localVarName, localVarBaseCategory);
                    accepted(localVarName, localVarBaseCategory);
                }
            }
            Button {
                id: cancelButton
                objectName: "cancelButton"

                text: qsTr("Cancel");

                onClicked: {
                    console.debug(objectName, "onClicked:");
                    rejected();
                }
            }
        }
    }
}
