import QtQuick 2.14
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

Rectangle {
    id: textRect
    objectName: "titleRect"
    readonly property int maxInputLength: 30
    
    /// Текст, отображаемый по центру прямойгольника
    property alias text: textInput.text
    property alias textPointSize: textInput.font.pointSize
    property alias textLetterSpacing: textInput.font.letterSpacing

    /// сигнал об одиночном клике
    signal clicked(var mouse)
    /// сигнал об изменении текста
    signal accepted()

    MouseArea {
        anchors.fill: parent
        
        onClicked: textRect.clicked(mouse)

        onDoubleClicked: {
            if (textInput.activeFocus === false) {
                textInput.enabled = true;
                textInput.forceActiveFocus();
                textInput.selectAll();
            } else {
                textInput.enabled = false;
            }
        }
    }
    
    Rectangle {
        id: textInputDecorator
        objectName: "textInputDecorator"
        
        anchors.fill: textInput
        anchors.margins: textInput.anchors.margins
        radius: Math.round(10 * kDPI)
        color: colorEditing
        visible: textInput.activeFocus
    }

    TextInput {
        id: textInput
        objectName: "textInput"
        
        function disableItem()
        {
            focus = false;
            enabled = false;
        }

        anchors.fill: parent
        anchors.margins: Math.round(5 * kDPI)
        horizontalAlignment: TextInput.AlignHCenter
        verticalAlignment: TextInput.AlignVCenter

        font.family: "Verdana"
        font.bold: true
        color: activeFocus ? colorTextEditing : colorPageSelectorText
        maximumLength: maxInputLength
        enabled: false
        focus: true
        wrapMode: TextInput.Wrap

        validator: RegularExpressionValidator { regularExpression: /[^\\/:*&"<>|;]+/ }

        onDisplayTextChanged: textRect.accepted()
        
        Keys.onEscapePressed: disableItem()
        
        onEditingFinished: disableItem()
    }
}
