import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: mathParametersDialog
    objectName: "mathParametersDialog"

    property int resultParamWidth:    Math.round(100 * kDPI)
    property int equalSignParamWidth: Math.round(16 * kDPI)
    property int leftParamWidth:      Math.round(100 * kDPI)
    property int operationParamWidth: Math.round(100 * kDPI)
    property int rightParamWidth:     Math.round(100 * kDPI)

    width: resultParamWidth
           + equalSignParamWidth
           + leftParamWidth
           + operationParamWidth
           + rightParamWidth
           + parameterItemSpacing * 5
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        var l_height = titleHeight
                + parameterItemHeight
                + parameterItemSpacing
        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView
        RowLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            height: parameterItemHeight
            spacing: parameterItemSpacing

            VarNameItem {
                width: resultParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 3
            }
            Text {
                width: equalSignParamWidth
                height: paintedHeight
                text: " = "
            }
            VarNameItem {
                width: leftParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 0
            }
            VarNameItem {
                width: operationParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 2
            }
            VarNameItem {
                width: rightParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 1
            }
        }
    }
}
