import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: mathParametersDialog
    objectName: "mathParametersDialog"

    property int leftParamWidth:      Math.round(100 * kDPI)
    property int conditionParamWidth: Math.round(60 * kDPI)
    property int rightParamWidth:     Math.round(100 * kDPI)

    property bool timeoutVisible: 3 < parametersModel.count

    width: leftParamWidth
           + conditionParamWidth
           + rightParamWidth
           + parameterItemSpacing * 2
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        var l_height = titleHeight
                + parameterItemHeight
                + parameterItemSpacing
        if (timeoutVisible)
            l_height += parameterItemHeight + parameterItemSpacing + standardMargin * 2
        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView

        ColumnLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: parameterItemSpacing * 2

            RowLayout {
                id: conditionLayout

                height: parameterItemHeight
                Layout.fillWidth: true;
                spacing: parameterItemSpacing

                VarNameItem {
                    width: leftParamWidth
                    Layout.fillHeight: true
                    paramModel: parametersModel
                    paramIndex: 0
                }
                VarNameItem {
                    width: conditionParamWidth
                    Layout.fillHeight: true
                    paramModel: parametersModel
                    paramIndex: 2
                }
                VarNameItem {
                    width: rightParamWidth
                    Layout.fillHeight: true
                    paramModel: parametersModel
                    paramIndex: 1
                }
            }

            Item {
                id: timeoutItem
                height: parameterItemHeight
                Layout.fillWidth: true;

                visible: timeoutVisible

                RowLayout {
                    anchors.fill: parent;
                    spacing: parameterItemSpacing

                    Text {
                        Layout.minimumWidth: Math.round(30 * kDPI)
                        Layout.fillHeight: true
                        verticalAlignment: Text.AlignVCenter
                        text: timeoutValueItem.paramName
                    }
                    Item {
                        objectName: "spacer"
                        implicitWidth: Math.round(4 * kDPI)
                    }

                    VarNameItem {   // for others types
                        id: timeoutValueItem

                        Layout.fillWidth: true
                        Layout.fillHeight: true
                        paramModel: parametersModel
                        paramIndex: 3
                    }
                }

            }

        }
    }
}
