import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1

Item {
    id: bitsHandler
    property string idx: "bitsHandler"
    property ListModel _bitsModel: ListModel {}

    property ListModel endianModel: ListModel {
        ListElement {
            name: "is_little_endian"
            value: 0
        }
    }

    property int height_size: 18

    property int selector_start_width: 7

    property int begin_anchor_pos_x: 0
    property int end_anchor_pos_x: 7

    property int output_height: 14


    property string str_bitsValueHex: ""
    property string str_bitsValueDec: ""
    property string selected_data: "0"

    property bool is_reversed: true

    property bool setup_checkbox: false



    function checkIndexes(pos_x, pos_y, area_flag){
        var text_item = bit_holder.childAt(pos_x, 0);

        console.debug(text_item, text_item.color, text_item.idx);

        // Нужно пометить индекс модели данных
        var index = text_item.idx;
        var pos = "left_idx"
        if (1 === area_flag){
            pos = "right_idx"
        }
        // Вот мы определили индекс, все не так просто.
        // авяжемся на флаг have_space, если попали в пробел
        if (text_item.have_space) {
            // ТО мы должны поределить мы попали в пустой квадрат или нет
            console.debug("bix_x", pos_x, text_item.x + 7);
            if (pos_x > text_item.space_x) {
                // Попали в пустой квадрат, теперь определим мы справа или слева
                if (2 === area_flag) {
                    // Если мы идем слева, то нужно переместиться на индекс выше
                    index++;
                }
            }
        }

        // Пробежимся по всей модели. найдем индекс с pos
        for (var i=0; i < _bitsModel.count; ++i){
            _bitsModel.setProperty(i, pos, 0);
        }
        console.debug(index, pos);
        // И теперь присвоем новому индексу pos
        _bitsModel.setProperty(index, pos, 1);
        getIndexedData();
    }

    function getIndexedData(){
        selected_data = ""
        var begin_index;
        var end_index;
        var i;
        var model_element;
        for (i = 0; i < _bitsModel.count; ++i) {
            model_element = _bitsModel.get(i);
            if (1 === model_element.left_idx) {
                begin_index = i;
            }
            if (1 === model_element.right_idx) {
                end_index = i;
            }
        }

        for (i = begin_index; i < end_index+1; ++i) {
            model_element = _bitsModel.get(i);
            selected_data += "%1".arg(model_element.value);
        }

       upgradeSelectedDataView();
    }
    function upgradeSelectedDataView(){
        if (is_reversed) {
            selected_data = reverse(selected_data);
        }

        var dec_val = parseInt(selected_data, 2);
        str_bitsValueHex = Number(dec_val).toString(16);
        str_bitsValueDec = Number(dec_val).toString(10);
    }
    function reverse(s){
        const arr = s.split("");
        const size = Math.ceil(arr.length/8);
        const arrays = [];
        for (var i = 0; i < size; i++)
        {
            const arrPart = arr.slice(i*8,(i+1)*8);
            arrays.push(arrPart.join(""));
        }
        return arrays.reverse().join("");
    }

    Item {
        id: row_start
        width: parent.width
        height: bitsHandler.height_size * 2
        z: 1;

        property string idx: "row_start_item"

        anchors.leftMargin: 10

        Component.onCompleted: {
            console.debug("Item With gridCreated");
        }
        Row {
            id: bit_holder
            property string idx: "bit_holder"
            Repeater {
                model: _bitsModel
                    Rectangle{
                        id: internal_rectangle
                        width: ((model.index + 1)%8 ? 7: 14);
                        height: 14;

                        property int idx: model.index;

                        property string curretn_color: "transparent"
                        property int is_marked: 0
                        property bool have_space: ((model.index + 1)%8 ? false: true);
                        property int space_x: x + width/2

                        color: "transparent"

                        Component.onCompleted: {
                            var space_count = Math.floor(model.index/8);
                            if (1 === model.left_idx) {
                                // Тут еще зитрость, у нас длина переменная, поэтому еще отступы добавить надо
                                // соберем длину
                                begin_anchor_pos_x = (model.index + space_count)*selector_start_width;

                                console.debug("set_left_anchor", model.index, begin_anchor_pos_x);
                            }
                            if (1 === model.right_idx) {
                                // Тут еще зитрость, у нас длина переменная, поэтому еще отступы добавить надо
                                // соберем длину
                                end_anchor_pos_x = (model.index + space_count + 1)*selector_start_width;
                                console.debug("set_right_anchor", model.index, end_anchor_pos_x);
                            }
                            getIndexedData();
                        }

                        Text{
                            text: "%1%2".arg(model.value).arg((model.index + 1)%8 ? "": " ");
                            font.pixelSize: 14
                        }
                    }
            }
        }
        // Правый якорь для растягиваемого прямоугольника выделения
        Rectangle {
            id: right_anchor
            property string idx: "right_anchor"
            width: 5
            height: 5
            color: "transparent"

            x:end_anchor_pos_x
            y:0
        }
        // Левый якорь для растягиваемого прямоугольника выделения
        Rectangle {
            id: left_anchor
            property string idx: "left_anchor"
            width: 5
            height: 5
            color: "transparent"

            x:begin_anchor_pos_x
            y:0
        }
        // Прямоугольник выделения битов
        Rectangle {
            id: resized_rect
            property string idx: "resized_rect"
            width: 7;
            height: 18;
            color: "transparent"

            anchors.left: left_anchor.left
            anchors.right: right_anchor.left

            property int resized_scale: 2
            property int standart_width: 7

            border.color: "red"
            border.width: 1

            MouseArea {
                id: right_area
                property string idx: "right_area"

                property real old_mouse_pos: 0
                property int right_area_flag: 1

                anchors.right: parent.right
                anchors.left: parent.horizontalCenter
                anchors.top: parent.top
                anchors.bottom: parent.bottom

                hoverEnabled: true

                onPressed: {
                    console.debug("right_area pressed");
                    resized_rect.anchors.right = undefined;
                    old_mouse_pos = mouseX;
                }

                onReleased: {
                    console.debug("old pos:", right_anchor.x);
                    right_anchor.x = resized_rect.x + resized_rect.width;
                    //ограничим максимальный размер рамки-выделения справа
                    if (right_anchor.x > 505)
                        right_anchor.x = 505;
                    console.debug("new pos:", right_anchor.x);
                    resized_rect.anchors.right = right_anchor.left;
                    // Нужно сделать проверку индексов, однако не все так просто
                    // Нужно в первый индекс отправить координаты не указателя мыши а правого и левого краев области
                    var pos_x = resized_rect.x + resized_rect.width - 2;
                    var pos_y = row_start.y + 9;
                    console.debug("frame pos :", pos_x, pos_y);
                    checkIndexes(pos_x, pos_y, right_area_flag);
                }

                onPositionChanged: {
                   if (pressed) {
                       var deltaX = mouseX - old_mouse_pos;
                       var times_greater = Math.floor(Math.abs(deltaX) / resized_rect.standart_width);
                       console.debug(deltaX, times_greater, old_mouse_pos, mouseX);
                       if (0 === times_greater) {
                           return;
                       }
                       if (deltaX > 0){
                           resized_rect.width += resized_rect.standart_width*times_greater;
                            old_mouse_pos = mouseX;
                           console.debug("add scale");
                       } else {
                           if ((resized_rect.width - resized_rect.standart_width*times_greater) >= resized_rect.standart_width){
                               resized_rect.width -= resized_rect.standart_width*times_greater;
                               old_mouse_pos = mouseX;
                            }
                           console.debug("reduce scale");
                       }
                   }
               }
            }
            MouseArea {
                id: left_area
                property string idx: "left_area"

                property real old_mouse_pos: 0
                property int test_value: 0
                property int left_area_flag: 2

                anchors.right: parent.horizontalCenter
                anchors.left: parent.left
                anchors.top: parent.top
                anchors.bottom: parent.bottom
                hoverEnabled: true

                onPressed: {
                    console.debug("left_area pressed");
                    resized_rect.anchors.left = undefined
                    left_area.old_mouse_pos = mouseX;
                }

                onReleased: {
                    console.debug("old pos:", left_anchor.x);
                    left_anchor.x = resized_rect.x;
                    //создаем ограничение, чтобы невозможно было сдвинуть рамку левее первого бита, первого байта
                    if (left_anchor.x < 0)
                        left_anchor.x = 0;
                    //ограничил максимальный предел левой стороны рамки, чтобы невозможно было выбрать рамкой крайний пробел
                    if (left_anchor.x > 490)
                        left_anchor.x = 490;
                    console.debug("new pos:", left_anchor.x);
                    resized_rect.anchors.left = left_anchor.left;
                    // Нужно сделать проверку индексов, однако не все так просто
                    // Нужно в первый индекс отправить координаты не указателя мыши а правого и левого краев области
                    var pos_x = resized_rect.x + 2;
                    var pos_y = row_start.y + 9;
                    console.debug("frame pos :", pos_x, pos_y);
                    checkIndexes(pos_x, pos_y, left_area_flag);
                }

                onPositionChanged: {
                   if (pressed) {
                       var deltaX = mouseX - left_area.old_mouse_pos;
                       var times_greater = Math.floor(Math.abs(deltaX) / resized_rect.standart_width);
                       console.debug(deltaX, times_greater, left_area.old_mouse_pos, mouseX, test_value);
                       if (0 === times_greater) {
                           return;
                       }
                       if (deltaX < 0){
                           resized_rect.width += resized_rect.standart_width*times_greater;
                           // такое поведение потому что мы зону обработки событий мыши меняем, как раз на стандартную ширину.
                           left_area.old_mouse_pos = mouseX + resized_rect.standart_width;
                           test_value = mouseX;
                           console.debug("add scale", left_area.old_mouse_pos, mouseX, test_value);
                       } else {
                           if ((resized_rect.width - resized_rect.standart_width*times_greater) >= resized_rect.standart_width){
                               resized_rect.width -= resized_rect.standart_width*times_greater;
                               // такое поведение потому что мы зону обработки событий мыши меняем, как раз на стандартную ширину.
                               left_area.old_mouse_pos = mouseX - resized_rect.standart_width;
                               console.debug("reduce scale: ", left_area.old_mouse_pos, mouseX);
                            }
                       }
                   }
               }
            }
        }
        Row{
            anchors.top: bit_holder.bottom
            height: parent.height;
            Rectangle{
                width: 100
                height: parent.height/1.5;
                color: "transparent"
                CheckBox {
                    anchors.top: parent.top
                    anchors.topMargin: 5;
                    width: parent.width
                    id: endian_trigger
                    checked: setup_checkbox

                    text: qsTr("big_endian")

                    onCheckedChanged: {
                        is_reversed = !endian_trigger.checked;
                        getIndexedData();
                        // Установим значение в модель параметров
                        endianModel.setProperty(0, "value", endian_trigger.checked ? 1 : 0);
                        console.debug("change trigger");
                    }
                }
            }
            Rectangle{
                width: 100
                height: parent.height/1.5;
                color: "transparent"
                Text {
                    id: hexname
                    anchors.top: parent.top
                    anchors.topMargin: 5;
                    renderType: Text.NativeRendering
                    text: "HEX: "
                }
                Text {
                    anchors.top: parent.top
                    anchors.topMargin: 5;
                    anchors.left: hexname.right
                    renderType: Text.NativeRendering
                    text: "%1  ".arg(str_bitsValueHex)
                }
            }
            Rectangle {
                width: 100
                height: parent.height/1.5;
                color: "transparent"
                Text {
                    id: decname
                    anchors.top: parent.top
                    anchors.topMargin: 5;
                    renderType: Text.NativeRendering
                    text: "DEC: "
                }
                Text {
                    anchors.top: parent.top
                    anchors.topMargin: 5;
                    anchors.left: decname.right
                    renderType: Text.NativeRendering
                    text: "%1  ".arg(str_bitsValueDec)
                }
            }
        }

    }

}
