import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1

FocusScope {

   id: actionsSubgroupToolBar
   height: columnSubgroup.height

   property alias groupName: subgroupActionsPanelButton.text
   property alias groupModel: listViewSubgroup.model
   property var subgroupItemSize: Math.round(24 * kDPI)

   Column {
       id: columnSubgroup
       width: columnActionsGroupToolBar.width

       Rectangle {
           id: subgroupActions
           anchors.left: parent.left
           anchors.right: parent.right
           height: panelButton.checked ? subgroupBlockSize : 0
           color: colorGroup
           border.width: 1
           border.color: colorScrollBorder

           ActionToolSubgroupButton {
               id: subgroupActionsPanelButton
               anchors.fill: parent
               visible: panelButton.checked
               onCheckedChanged: setListViewSubgroupHeight()
               onVisibleChanged: changeVisibleButton()               
           }
       }

       ListView {
           id: listViewSubgroup
           objectName: "listViewSubgroup"
           anchors.left: parent.left
           anchors.right: parent.right
           height: (subgroupActionsPanelButton.checked && panelButton.checked) ? (subgroupItemSize * count) : 0
           visible: false //изначально панель свернута
           delegate: ActionsDelegate {}
           interactive: false
           onHeightChanged: changeVisibleListView() //нужно для того, чтобы скрыть нулевой итем
                                                    //почему то при height == 0, он не скрывается

           Behavior on height {
               NumberAnimation {
                   easing.type: Easing.OutQuad
               }
           }
       }
   }
   function changeVisibleListView()
   {
        if(listViewSubgroup.height === 0)
            listViewSubgroup.visible = false;
        else
            listViewSubgroup.visible = true;
   }

   //привязка к кнопке, при изменении видимости (значит меняется кнопка группы), будем сварачивать список подгруппы и группы
   function changeVisibleButton() {
       if(!subgroupActionsPanelButton.visible)
       {
           if(listViewSubgroup.height !== 0)
           {
               subgroupActionsPanelButton.checked = false;
           }
           listViewGroup.height = 0;
       }else
       {
           listViewGroup.height = subgroupBlockSize * listViewGroup.count;
       }
   }

   function setListViewSubgroupHeight() {
       if(panelButton.checked && subgroupActionsPanelButton.checked)
       {
          listViewGroup.height = listViewGroup.height + (subgroupItemSize * listViewSubgroup.count);
       }else
       {
           listViewGroup.height = listViewGroup.height - (subgroupItemSize * listViewSubgroup.count);
       }
   }
}


