import { IQueueItem } from '../types/queue';
import Logger from './logger';

class Queue {
  private _queue: IQueueItem[] = [];
  private _current?: IQueueItem = undefined;
  private _retries = 0;

  get current() {
    return this._current;
  }

  get isEmpty() {
    return this._queue.length === 0;
  }

  public add = (item: IQueueItem): void => {
    this._queue.push(item);

    if (!this._current) {
      this.next();
    }
  };

  public next = (): void => {
    const item = this._queue.shift();

    this._retries = 0;
    this._current = undefined;

    if (!item) {
      return;
    }

    Logger.log('moving to next command in queue');

    this._current = item;
    item.command();
  };

  public retry = (): void => {
    if (!this._current) {
      return;
    }

    if (this._retries < this._current.retries) {
      this._retries++;
      this._current.command();

      Logger.log(`command id ${this._current.id} retry ${this._retries}`);
    } else {
      Logger.error(`command id ${this._current.id} failed`);

      this._current.reject();
      this.next();
    }
  };

  public drop = (): void => {
    this._queue = [];
    this._retries = 0;
  };
}

export default Queue;
