import React, { ButtonHTMLAttributes } from 'react';
import { ButtonStyled } from './styled';

interface IButtonProps extends ButtonHTMLAttributes<HTMLButtonElement> {
  disabled?: boolean;
  children?: React.ReactNode;
}

const Button: React.FC<IButtonProps> = ({
  children,
  disabled,
  ...buttonAttrs
}) => {
  return (
    <ButtonStyled disabled={disabled} type="button" {...buttonAttrs}>
      {children}
    </ButtonStyled>
  );
};

export type { IButtonProps };

export default Button;
