import QtQuick 2.0

Item {
    id: container

    property variant scrollArea
    property int orientation: Qt.Vertical
    property color scrollColor

    opacity: 0

    function position()
    {
        var ny = 0;
        if (container.orientation == Qt.Vertical)
            ny = scrollArea.visibleArea.yPosition * container.height;
        else
            ny = scrollArea.visibleArea.xPosition * container.width;
        if (ny > 0) return ny;
        else return 0;
    }

    function size()
    {
        var nh, ny;

        if (container.orientation == Qt.Vertical)
            nh = scrollArea.visibleArea.heightRatio * container.height;
        else
            nh = scrollArea.visibleArea.widthRatio * container.width;

        if (container.orientation == Qt.Vertical)
            ny = scrollArea.visibleArea.yPosition * container.height;
        else
            ny = scrollArea.visibleArea.xPosition * container.width;

        if (ny > 3) {
            var t;
            if (container.orientation == Qt.Vertical)
                t = Math.ceil(container.height - 3 - ny);
            else
                t = Math.ceil(container.width - 3 - ny);
            if (nh > t) return t;
            else return nh;
        } else return nh + ny;
    }

    Rectangle {
        anchors.fill: parent;
        radius: Math.round(3 * kDPI)
        color: Qt.darker(scrollColor, 1.1);
        opacity: 0.5
    }

//    BorderImage {
//        source: "images/scrollbar.png"
//        border { left: 1; right: 1; top: 1; bottom: 1 }
//        x: container.orientation == Qt.Vertical ? 1 : position()
//        width: container.orientation == Qt.Vertical ? container.width - 2 : size()
//        y: container.orientation == Qt.Vertical ? position() : 1
//        height: container.orientation == Qt.Vertical ? size() : container.height - 2
//    }
    Rectangle {
        radius: Math.round(3 * kDPI)
        x: container.orientation == Qt.Vertical ? 0 : position()
        y: container.orientation == Qt.Vertical ? position() : 0
        width: container.orientation == Qt.Vertical ? container.width : size()
        height: container.orientation == Qt.Vertical ? size() : container.height
        color: Qt.darker(scrollColor, 1.4)
        opacity: 0.5
    }

//    states: State {
//        name: "visible"
//        when: container.orientation == Qt.Vertical ? scrollArea.movingVertically : scrollArea.movingHorizontally
//        PropertyChanges { target: container; opacity: 1.0 }
//    }
    states: State {
        name: "visible"
        when: container.orientation == Qt.Vertical
              ? scrollArea.visibleArea.heightRatio < 1.0
              : scrollArea.visibleArea.widthRatio < 1.0
        PropertyChanges { target: container; opacity: 1.0 }
    }

    transitions: Transition {
        from: "visible"; to: ""; reversible: true
        NumberAnimation { properties: "opacity"; duration: 400 }
    }
}
