### 5.6.3 (20.05.25)

**New features:**

- New firmware 27.13 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.14 for devices Galileosky BaseBlock is added.
- New firmwares 38.34 (release-candidate) for devices Galileosky 7x is added.
- Search by ID and by bytes in messages in the CAN logger is implemented.
- Saving of entered commands on the Commands tab is implemented.

**Corrections:**

- Issue in the configuration of CAN tags on the CAN scanner tab is fixed.

#### Changelog of firmwares 27.13 and 27.14:

**New features:**

- GNSSJAMMING command is added.

**Corrections:**

- Device reboot when deleting a non-empty folder with FSDELETE command has been fixed.

#### Changelog of firmware 38.24:

**New features:**

- GNSSJAMMING command is added.

**Corrections:**

- Modems operating is improved.
- APN functionality on devices with Ublox LTE modems has been fixed.


### 5.6.2 (16.05.25)

**New features:**

- New firmwares 3.11 for devices Galileosky 10 is added.
- New firmwares 48.11 (release-candidate) for devices Galileosky 7x is added.

#### Changelog of firmwares 48.11 and 3.11:

**Corrections:**

- Wi-Fi exchange with poor signal quality has been improved.
- Issue in the formation of the Galileosky protocol packet is fixed.


### 5.6.1 (06.05.25)

**New features:**

- New firmwares 3.10 and 5.0 (beta-version) for devices Galileosky 10 is added.
- New firmwares 48.10 (release-candidate) and 50.0 (beta-version) for devices Galileosky 7x is added.
- In a "File editor" user interface the file content updating during the recording feature is added.
- Support for the new CAN database is added (compatible with firmware 5.0 for Galileosky 10 devices).

#### Changelog of firmwares 48.10 and 3.10:

**New features:**

- MAC address verification during BLE sensor scanning is made case-insensitive.
- Data conversion formulas for CAN is made case-insensitive.
- Extended tags 0xB4-0xB6 have been added to the Galileosky protocol, containing MAC addresses of clients that are connected and uploading data.
- Transition to the new Yandex LBS API has been completed.

**Corrections:**

- Operation with SIM7070G modem has been fixed.
- Work in Hub mode has been fixed.
- APN functionality on devices with Ublox LTE modems has been fixed.
- Stability and performance have been improved.
- Device connection via BLE is improved.

#### Changelog of firmware 5.0:

**New features:**

- A vehicle database has been added for parsing data on the CAN bus.
- The length of string parameters in commands received by EasyLogic has been increased to 255.
- The speed of analyzing and converting KML files into geozones has been improved. The ability to work with pre-generated files has been added.
- The data transmission algorithm over GPRS networks in weak signal conditions has been improved.
- Device reconnection when changing access settings to SD/eMMC has been added.
- The ability to send a response to a command received via Bluetooth or SMS has been added in EasyLogic scripts.
- The buffer size for file names in the functions FileSize, FileRead, FileWrite, and FileDelete has been increased to 255 in EasyLogic.
- The BLE type (4) has been added to the CONNECTION_TYPE variable in EasyLogic.
- Transition to the new Yandex LBS API has been completed.
- Extended tags 0xB4-0xB6 have been added to the Galileosky protocol, containing MAC addresses of clients that are connected and uploading data.
- Added a warning about the need to correctly remove USB from the terminal when MSD 1.
- Messages from the internal coordinate source are no longer displayed if an external source is used.
- The TIMESYNCGNSS command has been added to allow disabling time synchronization with the GNSS module's time.
- Tags 0x11 - UID (32-bit) and 0x36 - PDOP have been added.
- The ARCHIVESTATCOLLECTOR command has been added to view statistics of points collected by the hub from client terminals.

**Corrections:**

- The size of the PressurePro tag has been corrected.
- Wi-Fi stability has been improved.
- Issues in Bluetooth data transmission have been fixed.
- The diagnostic information collection function has been improved.
- An issue in setting network priority for terminals with a SIM7070G modem has been fixed.
- The operation of the SD/eMMC archive has been fixed.
- Stability and performance have been improved.
- Data loss when receiving on RS485 in the "EasyLogic RS485 handlers only" mode has been fixed.
- The "Timeout of sending to the hub" parameter for Wi-Fi after resetting the settings has been fixed.
- The geozone sector intersection check has been fixed, ensuring accurate detection of points inside polygonal geozones.
- Data sending in Hub mode has been fixed.
- Issues with A7602E modem operation have been resolved.
- Support for signed min and max parameters has been added to the Rand function in EasyLogic.
- The conversion of the first word to uppercase when receiving SMS from authorized numbers has been fixed.
- An error saving data to a file in Hub mode when connection with clients is lost during data transfer has been fixed.
- Recovery of operational data from the last archive record after device reboot has been fixed.
- Memory leaks or unexpected reboots during data unloading via protocols have been fixed.
- APN functionality on devices with Ublox LTE modems has been fixed.
- Device connection via BLE is improved.

#### Changelog of firmware 50.0:

**New features:**

- The length of string parameters in commands received by EasyLogic has been increased to 255.
- The speed of analyzing and converting KML files into geozones has been improved. The ability to work with pre-generated files has been added.
- The data transmission algorithm over GPRS networks in weak signal conditions has been improved.
- Device reconnection when changing access settings to SD/eMMC has been added.
- The ability to send a response to a command received via Bluetooth or SMS has been added in EasyLogic scripts.
- The buffer size for file names in the functions FileSize, FileRead, FileWrite, and FileDelete has been increased to 255 in EasyLogic.
- The BLE type (4) has been added to the CONNECTION_TYPE variable in EasyLogic.
- The transition to the new Yandex API for LBS location determination functionality has been completed.
- Extended tags 0xB4-0xB6 have been added to the Galileosky protocol, containing MAC addresses of clients that are connected and uploading data.
- Added a warning about the need to correctly remove USB from the device when MSD 1.
- Messages from the internal coordinate source are no longer displayed if an external source is used.
- The TIMESYNCGNSS command has been added to allow disabling time synchronization with the GNSS module's time.
- Tags 0x11 - UID (32-bit) and 0x36 - PDOP have been added.
- The ARCHIVESTATCOLLECTOR command has been added to view statistics of points collected by the hub from client terminals.

**Corrections:**

- The size of the PressurePro tag has been corrected.
- Wi-Fi stability has been improved.
- Issues in Bluetooth data transmission have been fixed.
- The diagnostic information collection function has been improved.
- An issue in setting network priority for terminals with a SIM7070G modem has been fixed.
- The operation of the SD/eMMC archive has been fixed.
- Stability and performance have been improved.
- Data loss when receiving on RS485 in the "EasyLogic RS485 handlers only" mode has been fixed.
- The "Timeout of sending to the hub" parameter for Wi-Fi after resetting the settings has been fixed.
- The geozone sector intersection check has been fixed, ensuring accurate detection of points inside polygonal geozones.
- Data sending in Hub mode is fixed.
- Support for signed min and max parameters has been added to the Rand function in EasyLogic.
- The conversion of the first word to uppercase when receiving SMS from authorized numbers has been fixed.
- An error saving data to a file in Hub mode when connection with clients is lost during data transfer has been fixed.
- Recovery of operational data from the last archive record after device reboot has been fixed.
- Memory leaks or unexpected reboots during data unloading via protocols have been fixed.
- APN functionality on devices with Ublox LTE modems has been fixed.
- Device connection via BLE is improved.


### 5.5.3 (25.02.25)

**New features:**

- New firmware 3.9 for devices Galileosky 10 is added.
- New firmware 48.9 (release-candidate) for devices Galileosky 7x is added.
- A file data reading function to the "File Editor" user interface is added.

**Corrections:**

- Issue in resetting default settings through the Settings tab is fixed. 

#### Changelog of firmwares 3.9 and 48.9:

**New features:**

- The size of the PressurePro tag is fixed.
- Stability and performance is improved.
- Stability of Wi-Fi is improved.
- The SendAnswer function is fixed.
- Issues with data transfer via Bluetooth are fixed.
- The diagnostic information collection function is improved.
- The issue that caused the terminal configuration to be reset is fixed.
- Issue in RS ports self-diagnosis that caused the device to reboot automatically is fixed.
- Live data transmission via Bluetooth is fixed.
- In EasyLogic scripts, the ability to send a response to commands received via Bluetooth or SMS is added.
- In EasyLogic, the buffer size for file names in the FileSize, FileRead, FileWrite, and FileDelete functions is increased to 255.
- In EasyLogic, the BLE type (4) is added to the CONNECTION_TYPE variable.
- The calculation of a script's RAM usage is fixed.
- Work with SD/eMMC archive is fixed.
- Issue in setting networks priority for terminals with SIM7070G modem is fixed.
- USB reinitialization is performed if the MSD (Mass Storage Device) settings are changed.
- Data loss when receiving on RS485 in the "EasyLogic RS485 handlers only" mode is fixed.
- The value of the "Timeout of sending to the hub" parameter for Wi-Fi after resetting the settings is fixed.
- Data receiving in Hub mode is fixed.


### 5.5.2 (26.12.24)

**New features:**

- Device search by MAC address and name in the Bluetooth scanner is implemented.

**Corrections:**

- Settings loading during remote configuration is fixed.


### 5.5.1 (02.12.24)

**New features:**

- New firmware 3.5 and 4.0 (beta-version) for devices Galileosky 10 and Galileosky XS is added.
- New firmware 48.5 (release-candidate) and 49.0 (beta-version) for devices Galileosky 7x is added.
- A new settings loading mechanism has been implemented (compatible with firmware 4.0 for Galileosky 10 and Galileosky XS devices, and 49.0 for Galileosky 7X devices).

#### Changelog of firmwares 4.0 and 49.0:

**New features:**

- Power consumption of the device is reduced.
- The ability to set polling rate for Modbus slave devices.
- The ability to not clear Modbus register value when an error occurs.
- The ability to apply mathematical formulas for Modbus tags.
- Support for the new script download server protocol is added.
- The SAVESTATUS command to control recording of a point in the archive when the device status changes is added.
- The MREG command to control Modbus registers is added.
- Support for temperature sensors DS18B20, DS1825, DS28EA00 is added.
- Configuration loading speed is increased.
- The GETVALUEBYTAG command to retrieve operational data in Base64 format by tag number is added.
- In EasyLogic, the TagProtoRead function is added to retrieve operational data in binary format by tag number.
- In EasyLogic, XTEACrypt and XTEADecrypt functions are added for data encryption and decryption using the XTEA-3 algorithm.

**Corrections:**

- Issue in RS ports self-diagnosis that caused the device to reboot automatically is fixed.

#### Changelog of firmwares 3.5 and 48.5:

**Corrections:**

- Default settings for the self-diagnostic system have been updated.
- Operation with modems has been improved.


### 5.4.19 (15.11.24)

**Corrections:**

- Program crash when loading configuration from file is fixed.

### 5.4.18 (14.11.24)

**New features:**

- New firmware 3.1 for devices Galileosky 10 and Galileosky XS is added.
- New firmware 48.1 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- The issue with CAN scanner during for Galileosky 7.0 devices is fixed.
- The issue with file uploading in the Algorithm store is fixed.

#### Changelog of firmwares 3.1 and 48.1:

**Corrections:**

- The amount of traffic consumed by the diagnostic information collection function has been reduced.
- Data transmission in the networks of some mobile operators has been fixed.
- Prioritization of movement/parking determination options has been fixed.
- Work with CAN formulas has been fixed.


### 5.4.17 (01.10.24)

**New features:**

- New firmware 3.0 for devices Galileosky 10 and Galileosky XS is added.
- New firmware 48.0 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- Error of the update downloading is fixed.
- Delay in receiving data in the CAN scanner is fixed.

#### Changelog of firmware 3.0 for devices Galileosky 10:

**New features:**

- The ability to update EL algorithms when loading scripts with the same names from the server has been added.
- The ability to get more Modbus diagnostics has been added.
- New filters for height and speed are added.
- The filtering of coordinates has been adjusted.
- The GPS.CORRECT3 command for setting custom coordinate filtering options is added.

**Corrections:**

- The mileage value after it overflowed is fixed.
- Downloading of the archive from SD/eMMC to the file is fixed.
- Wi-Fi operation after disabling and enabling from Easy Logic algorithms is fixed.
- Stability of Bluetooth operation with BLE sensors is improved.

#### Changelog of firmware 3.0 for devices Galileosky XS:

**New features:**

- The ability to update EL algorithms when loading scripts with the same names from the server has been added.
- The ability to get more Modbus diagnostics has been added.
- New filters for height and speed are added.
- The filtering of coordinates has been adjusted.
- The GPS.CORRECT3 command for setting custom coordinate filtering options is added.

**Corrections:**

- The mileage value after it overflowed is fixed.
- Stability of Bluetooth operation with BLE sensors is improved.

#### Changelog of firmware 48.0:

**New features:**

- The ability to update EL algorithms when loading scripts with the same names from the server has been added.
- The ability to get more Modbus diagnostics has been added.
- New filters for height and speed are added.
- The filtering of coordinates has been adjusted.
- The GPS.CORRECT3 command for setting custom coordinate filtering options is added.

**Corrections:**

- The mileage value after it overflowed is fixed.
- Downloading of the archive from SD/eMMC to the file is fixed.
- Wi-Fi operation after disabling and enabling from Easy Logic algorithms is fixed.
- Stability of Bluetooth operation with BLE sensors is improved.
- Operation with some microSD cards is fixed.


### 5.4.16 (16.08.24)

**New features:**

- New firmware 2.12 for devices Galileosky 10 and Galileosky XS is added.
- New firmware 47.18 (release-candidate) for devices Galileosky 7x is added.

#### Changelog of firmware 2.12 for devices Galileosky 10:

**Corrections:**

- Self-diagnostic errors that caused the device to reboot automatically have been fixed.
- The disabling of the standard light indication via Easy Logic has been fixed.

#### Changelog of firmware 2.12 for devices Galileosky XS:

**Corrections:**

- Self-diagnostic errors that caused the device to reboot automatically is fixed.
- The operation of energy saving functions (SLEEP\WAKEUP) is fixed.
- The ability to turn off the device using the POWEROFF command is removed.

**Corrections:**

- Self-diagnostic errors that caused the device to reboot automatically have been fixed.
- The operation of energy-saving functions (SLEEP/WAKEUP) has been fixed.
- The ability to turn off the device using the POWEROFF command has been removed.
- The disabling of the standard light indication via Easy Logic has been fixed.

#### Changelog of firmware 47.15:

**Corrections:**

- Self-diagnostic errors that caused the device to reboot automatically have been fixed.
- The operation of energy-saving functions (SLEEP/WAKEUP) has been fixed.
- The ability to turn off the device using the POWEROFF command has been removed.
- The disabling of the standard light indication via Easy Logic has been fixed.


### 5.4.15 (16.07.24)

**New features:**

- New advanced .rec2 format for CAN data log files is added

**Corrections:**

- CAN Logger tool data playback speed is fixed
- Bluetooth scanner tool scanning process optimized
- Modbus page "Real-time mode" tool fixed, error codes are available now.
- Loading of Bluetooth tag settings is fixed.


### 5.4.14 (14.06.24)

**New features:**

- New firmware 2.9 for devices Galileosky 10 is added.
- New firmware 47.15 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- Delay in receiving data in the CAN scanner is fixed.

#### Changelog of firmware 2.9:

**New features:**

- Support for eSIM is added.

**Corrections:**

- The diagnostic output of Easy Logic algorithms is fixed.
- The time setting is fixed when received from NTP servers.
- Stability when using power saving functions (SLEEP\WAKEUP) is improved.
- Issues in the TagWriteValue, TagWriteArray and TagWriteValue64 Easy Logic functions that caused to the device rebooting are fixed.
- The loading speed of Easy Logic algorithms is increased.

#### Changelog of firmware 47.15:

**New features:**

- Support for Galileosky V7X.0.87х is added.
- Support for eSIM is added.

**Corrections:**

- The diagnostic output of Easy Logic algorithms is fixed.
- The time setting is fixed when received from NTP servers.
- Stability when using power saving functions (SLEEP\WAKEUP) is improved.
- Issues in the TagWriteValue, TagWriteArray and TagWriteValue64 Easy Logic functions that caused to the device rebooting are fixed.


### 5.4.13 (13.05.24)

**New features:**

- New firmware 2.8 for devices Galileosky 10 is added.
- New firmware 47.14 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- Uploading device configuration from a file on the Settings tab is fixed. 

#### Changelog of firmwares 2.8, 47.14:

**New features:**

- The CANSELFRX command to enable or disable the reception of its own CAN messages is added.

**Corrections:**

- CAN processing is improved.
- Firmware upgrade speed is increased.
- Reading the archive in case of overwriting is fixed.
- Time synchronization is fixed.
- Passing coordinates from EasyLogic is fixed.
- Errors when working with Bluetooth from EasyLogic are fixed.
- Operation with MultiSim is improved.


### 5.4.12 (04.04.24)

**New features:**

- New firmware 2.7 for devices Galileosky 10 is added.
- New firmware 47.13 (release-candidate) for devices Galileosky 7x is added.
- New firmware 27.11 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.12 for devices Galileosky BaseBlock is added.

**Corrections:**

- Issue with displaying of Signaling settings for Galileosky 7.0 devices is fixed.
- Absence of "advertising" packets "raw" data in case if the receiver is Galileosky XS is fixed.
- Issue with exporting of the archive from the microSD card on the Data tab when connected via bluetooth is fixed.

#### Changelog of firmware 2.7:

**New features:**

- File sync system: limit of files depth is removed, uploading is optimized.
- Command FIXTERM for binding 1-Wire thermometers to fields in data sending protocol is added.

**Corrections:**

- Coordinate filtering is fixed.
- Detection of GNSS antenna connection is fixed.
- Frequency counting at the inputs is fixed.
- Updating coordinates based on LBS data is fixed.
- Updating of coordinates after exposure to jamming is fixed.
- Autodetection of CAN bus speed is fixed.
- Issues in the ROMDelete, ROMRead and ROMWrite functions are fixed.
- Automatic disk opening in the absence of SD\EMMC support is fixed.
- Operation of the TagWriteBegin and TagWriteEnd EasyLogic functions for tag numbers greater than 255 is fixed.
- Issue that caused the WiFi Hub to reboot is fixed.

#### Changelog of firmware 47.13:

**New features:**

- File sync system: limit of files depth is removed, uploading is optimized.
- Command FIXTERM for binding 1-Wire thermometers to fields in data sending protocol is added.

**Corrections:**

- Coordinate filtering is fixed.
- Detection of GNSS antenna connection is fixed.
- Frequency counting at the inputs is fixed.
- Updating coordinates based on LBS data is fixed.
- Updating of coordinates after exposure to jamming is fixed.
- Autodetection of CAN bus speed is fixed.
- Issues in the ROMDelete, ROMRead and ROMWrite functions are fixed.
- Automatic disk opening in the absence of SD\EMMC support is fixed.
- The issue causing configuration reset is fixed.
- Operation of the TagWriteBegin and TagWriteEnd EasyLogic functions for tag numbers greater than 255 is fixed.
- Issue that caused the WiFi Hub to reboot is fixed.

#### Changelog of firmwares 27.11, 27.12:

**Corrections:**

- The issue with Eco Driving calibration is fixed.
- Updating of coordinates after exposure to jamming is fixed.


### 5.4.11 (15.03.24)

**Corrections:**

- User interface DUT Escort (RS485, Bluetooth) is optimized.
- The issue with displaying of CAN settings downloaded from the configuration file is fixed.
- The issue in Bluetooth tag settings for Galileosky 10 devices is fixed.


### 5.4.10 (01.03.24)

**New features:**

- New firmware 2.5 for devices Galileosky 10 is added.
- New firmware 47.11 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- The display of raw data on the CAN scanner tab for PCs with small displays is corrected.
- Delay in receiving data in the CAN scanner is fixed.
- The issue with displaying settings on the Modbus tab.

#### Changelog of firmwares 2.5, 47.11:

**Corrections:**

- Operation with the GNSS module is fixed.
- Writing to tags from Easy Logic scripts is fixed.


### 5.4.09 (09.02.24)

**New features:**

- New firmware 2.4 for devices Galileosky 10 is added.
- New firmware 47.10 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- Program crash during working on the EasyLogic tab is fixed.
- The issue with adding and setting filters on the J1939DA Protocol tab is fixed.

#### Changelog of firmware 2.4:

**Corrections:**

- Operation with 2G modems is improved.
- Coordinate duplication is fixed.
- Parsing of J1939DA messages is fixed.
- Automatic disk opening without SD card is fixed.

#### Changelog of firmware 47.10:

**Corrections:**

- Operation with 2G modems is improved.
- Processing of SD Card ejection is fixed.
- Coordinate duplication is fixed.
- Automatic disk opening without SD card is fixed.


### 5.4.08 (23.01.24)

**New features:**

- New firmware 2.2 for devices Galileosky 10 is added.
- New firmware 47.8 (release-candidate) for devices Galileosky 7x is added.
- Support for ISOBUS parameters in the CAN Scanner tab in the J1939DA Protocol section is added.
- Automated diagnostic data collection for Galileosky 7x and 10 devices has been modified.

#### Changelog of firmware 2.2:

**New features:**

- The ENSCRIPTDEFRAG command to defragment the script storage when starting the device is added.
- In this firmware, the function of collecting diagnostic information is added.
- Support for the ISOBUS protocol is added.
- Command "WIEGANDCFG" to configure Wiegand parameters is added.
- Automatic request of the maximum MTU size during BLE connection is added.

**Corrections:**

- Stability and performance is improved.
- Device reboot when loading a file with zero size via WebDav is fixed.
- Error in accessing SD/eMMC when connecting the device to a computer is fixed.
- Cleaning SPN tags in case of lack of data in the CAN bus is fixed.
- Missing coordinates in case of disabled archive is fixed.
- Checking of downloaded EasyLogic script is fixed.
- GSM location is fixed.
- Sending points to a server larger than 1000 bytes is fixed.
- Parsing of SMS sender address with number type "accepted on the network" is fixed.
- Data transmission on devices with LTE support has been improved.
- Incorrect data in the 0x49 tag has been fixed.
- The issue with CAN modes when performing J1939DA scanning is fixed.
- The issue with loading identical scripts with names in different case is fixed.
- The issue of the BLE notifications stream is fixed.
- The issue with clearing a string variable when ending an EL script chain is fixed.
- The issue in initializing a string variable when there is no parameter in the command is fixed.
- Device stability when the RAM level is low is improved.
- Receiving CAN messages with the selected Easy Logic handler is enabled by default.
- Stability of CAN operation is improved.

#### Changelog of firmware 47.8:

**Corrections:**

- Missing coordinates in case of disabled archive is fixed.
- Checking of downloaded EasyLogic script is fixed.
- GSM location is fixed.
- Sending points to a server larger than 1000 bytes is fixed.
- Parsing of SMS sender address with number type "accepted on the network" is fixed.


### 5.4.07 (26.12.23)

**New features:**

- New firmware 47.6 (release-candidate) for devices Galileosky 7x is added.

**Corrections:**

- The issue with displaying the firmware list from the update service is fixed.

#### Changelog of firmware 47.6:

**Corrections:**

- Stability and performance is improved.
- Problem accessing SD/eMMC when connecting the device to a computer is fixed.


### 5.4.06 (25.12.23)

**New features:**

- New firmware 1.3 for devices Galileosky 10 is added.
- New firmware 47.5 (release-candidate) for devices Galileosky 7x is added.
- Firmware downloading from the remote firmware update service is implemented.
- The list of commands for automatic substitution on the Commands tab is updated.

**Corrections:**

- The issue with displaying the consumed RAM memory when deleting an algorithm on the "Algorithms" tab is fixed.

#### Changelog of firmware 1.3:

**Corrections:**

- The issue with caused valid coordinates to be determined for a long time is fixed.
- WebDav operating is improved.

#### Changelog of firmware 47.5:

**Corrections:**

- Stability and performance is improved.
- Device reboot when loading a file with zero size via WebDav is fixed.


### 5.4.05 (04.12.23)

**New features:**

- New firmware 47.3 (beta-version) for devices Galileosky 7x is added.

**Corrections:**

- Uploading device configuration from a file on the Settings tab is fixed.
- The issue with loading of parameters from the terminal in FuelTarFilter block on the "Filters" tab is fixed.

#### Changelog of firmware 47.3:

**Corrections:**

- Stability of CAN operation is improved.
- Receiving CAN messages with the selected Easy Logic handler is enabled by default.
- WebDav operating is improved.


### 5.4.04 (28.11.23)

**New features:**

- New service firmware (Recovery) 33.18 for devices Galileosky 7x is added.
- New firmware 38.25 for devices Galileosky 7x is added.
- New firmware 47.0 (beta-version) for devices Galileosky 7x is added.

**Corrections:**

- The issue with Bluetooth scanner during remote configuration is fixed.
- The issue with CAN scanner during remote configuration is fixed.
- The issue with loading of parameters from the terminal in the TarFilter block on the "Filters" tab is fixed.

#### Changelog of firmware 38.25:

**New features:**

- The third parameter which controls endianess is added to the IBCFG command.
- The limitation for battery charging within the range of 9-39V of external power supply voltage is added.

**Corrections:**

- Stability of device startup while supply voltage is low is improved.
- Measuring of GNSS antenna supply voltage at device startup is fixed.
- The issue with loading identical scripts with names in different case is fixed.

#### Changelog of firmware 47.0:

- The ENSCRIPTDEFRAG command to defragment the script storage when starting the device is added.
- In this firmware, the function of collecting diagnostic information is added.
- Support for devices Galileosky V7X.1.54 is added.
- Command WIEGANDCFG to configure wiegand parameters is added.
- Automatic request of the maximum MTU size during BLE connection is added.

**Corrections:**

- Data transmission on devices with LTE support has been improved.
- The issue with caused valid coordinates to be determined for a long time is fixed.
- Incorrect data in the 0x49 tag has been fixed.
- The issue with loading identical scripts with names in different case is fixed.
- The issue of the BLE notifications stream is fixed.
- The issue with clearing a string variable when ending an EL script chain is fixed.
- The issue in initializing a string variable when there is no parameter in the command is fixed.
- Device stability when the RAM level is low is improved.


### 5.4.03 (31.10.23)

**New features:**

- New user interface - File editor.

**Corrections:**

- CAN tag settings for Galileosky OBD-II devices when connecting remotely is fixed.
- IMEI display for Galileosky 5.0 devices on the Device tab is fixed.


### 5.4.02 (12.10.23)

**New features:**

- New firmware 38.23 for devices Galileosky 7x is added.

**Corrections:**

- Program freeze when device is disconnected during remote configuration is fixed.
- The display of the ROM value in the graphical block on the Algorithms tab is fixed.
- Color palette for RAM graphs on the Algorithms tab is changed.
- Error in setting SPN tags on the J1939DA Protocol tab is fixed.

#### Changelog of firmware 38.22:

**Corrections:**

- The volume of voice communication on devices with LTE support has been increased.
- Сlearing of CAN tags with selected EasyLogic handler is fixed.
- The issue with Eco Driving calibration is fixed.


### 5.4.01 (09.10.23)

**New features:**

- New firmware 1.1 for devices Galileosky 10 is added.
- New firmware 46.1 (beta-version) for devices Galileosky 7x is added.
- Support for string parameters in EasyLogic scripts is added.
- Algorithms tab for tracking information on Easy Logic algorithms is added.

#### Changelog of firmware 1.1:

**New features:**

- The command "SCRIPTSTORAGEINFO" to get the ROM memory size for scripts is added.
- The "GetUserArray" function is added to EasyLogic to get data from the user's array.
- Possibility to configure the network priority for devices with 3G is added.
- The functions TagWriteBegin and TagWriteEnd have been added to enable postponed writing to tags from EasyLogic.
- Feature of sending data via Iriduim right after turning on from EasyLogic is added.
- Sending acceleration data via EGTS protocol is added.
- Support for string parameters in command handlers in EasyLogic is added.
- Base64 encoding/decoding functions are added to EasyLogic.

**Corrections:**

- The issue of not displaying the status while the archive is uploading to the hub is fixed.
- Operation with SMS on some mobile network operators is fixed.
- Clearing CAN tags in case of selected EasyLogic handler for CAN is fixed.
- Resetting SPN configuration when ERASECFG command invoked is fixed.
- The volume of voice communication on devices with LTE support has been increased.
- Cleaning SPN tags in case of lack of data in the CAN bus is fixed.
- The issue with terminal reboot when frequently connecting to the TCP server is fixed.
- The issue with invalid coordinates is fixed.

#### Changelog of firmware 46.1:

**New features:**

- The command "SCRIPTSTORAGEINFO" to get the ROM memory size for scripts is added.
- The "GetUserArray" function is added to EasyLogic to get data from the user's array.
- Possibility to configure the network priority for devices with 3G is added.
- The functions TagWriteBegin and TagWriteEnd have been added to enable postponed writing to tags from EasyLogic.
- Feature of sending data via Iriduim right after turning on from EasyLogic is added.
- Sending acceleration data via EGTS protocol is added.
- Support for string parameters in command handlers in EasyLogic is added.
- Base64 encoding/decoding functions are added to EasyLogic.

**Corrections:**

- The issue of not displaying the status while the archive is uploading to the hub is fixed.
- Operation with SMS on some mobile network operators is fixed.
- Clearing CAN tags in case of selected EasyLogic handler for CAN is fixed.
- In CAN scanner the issue with receiving data from two CAN ports at the same time is fixed.
- The volume of voice communication on devices with LTE support has been increased.
- The issue with terminal reboot when frequently connecting to the TCP server is fixed.
- The issue with invalid coordinates is fixed.


### 5.3.03 (21.09.23)

**New features:**

- New firmware 27.10 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.11 for devices Galileosky BaseBlock is added.
- New firmware 38.22 for devices Galileosky 7x is added.

**Corrections:**

- Firmware version 33.17 with version 33.16 (beta version) for Galileosky 7X terminals is replaced.
- The operation of the EL script compiler is fixed.
- Error in setting filtering parameters on the Track tab is fixed.

#### Changelog of firmware 27.10:

**Corrections:**

- Periodic reboot of the device due to the non-response of the GNSS unit in self-troubleshooting if the unit was functioning normally is fixed.

#### Changelog of firmware 27.11:

**New features:**

- The IRIDIUMTXCFG command has been added, which allows you to disable the transmission of archive points through the Iridium modem when it is enabled from the EasyLogic algorithms.

**Corrections:**

- Periodic reboot of the device due to the non-response of the GNSS unit in self-troubleshooting if the unit was functioning normally is fixed.

#### Changelog of firmware 38.22:

**New features:**

- Possibility to configure the network priority for devices with 3G is added.

**Corrections:**

- Operation with SMS on some mobile network operators is fixed.
 

### 5.3.02 (12.09.23)

**New features:**

- New firmware 33.17 (beta-version) for devices Galileosky 7x is added.
- In the device registration dialog of the remote configuration service, a field for entering the device name and password is added.
- User interface DUT Escort (RS485, Bluetooth) is updated.

**Corrections:**

- Switching to the Device tab when connecting remotely is fixed.
- Error in receiving advertising packets in Bluetooth scanner for Galileosky 10 is fixed.
- Downloading the archive when connected via bluetooth is fixed.


#### Changelog of firmware 33.17:

**New features:**

- The GSMAUTH command, which allows you to configure the type of authentication in the GSM network is added.
- Bootloader 3.0 is added.

**Corrections:**

- Registration in some LTE networks is fixed.
- Registration in a GSM network is improved.


### 5.3.01 (07.08.23)

**New features:**

- Support for Galileosky 10 device is added.
- New firmware 1.0 for devices Galileosky 10 is added.
- New firmware 27.9 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.10 for devices Galileosky BaseBlock is added.
- New firmware 38.21 for devices Galileosky 7x is added.
- New firmware 46.0 (beta-version) for devices Galileosky 7x is added.
- Possibility to disable the message bus in the System section is added.
- The window for selecting the device to connect is redesigned.
- Displaying graphs on the CAN scanner tab is now available.
- Registering a tracker to the remote configuration service when connected through USB is added.
- SemaphoreTake and SemaphoreGive functions were added to EasyLogic.
- "Acquire semaphore" and "Release semaphore" blocks were added to the Easy Logic tab.
- Function "GetUserArray" to get data from the user's array is added in EasyLogic scripts.

#### Changelog of firmwares 27.9, 27.10:

**New features:**

- Sending a minor version of the firmware to the remote configuration server is added.

**Corrections:**

- WebDav operating is improved.

#### Changelog of firmware 38.21:

**New features:**

- WebDav features are disabled by default.

**Corrections:**

- WebDav operating is improved.

#### Changelog of firmware 46.0:

**New features:**

- The GSMAUTH command, which allows you to configure the type of authentication in the GSM network is added.
- Possibility to disable the message bus to save RAM resources is added.
- Function ChargerEnable is added in EasyLogic scripts.
- Upload of the client archive from the hub is improved.
- WebDav, Message Bus and Bluetooth configuration features are disabled by default.
- Transmission of the 0x49 tag to the Galileosky protocol, the place where it is uploaded (server\hub), the channel through which it is uploaded (GSM\WiFi) is added.
- The NODOUBLEPACK command that allows you to disable uploading the archive to the hub if it was sent to the main server is added.
- Dedicated virtual COM port for receiving diagnostic messages is added.
- SD/eMMC is available as a Flash Drive when the device is plugged into a computer.

**Corrections:**

- Registration in a GSM network is improved.
- In Easy Logic, the initial state of the variable "PUSH_TO_TALK_BUTTON_STATUS" is fixed.
- Time leaps on some Galileosky V7X devices is fixed.
- The mechanism for determining the disconnection of an external GPS antenna is improved.
- WebDav operating is fixed.


### 5.2.06 (17.07.23)

**Corrections:**

- Error in switching to local device configuration when connecting remotely is fixed.
- Error in connecting to the device for Bluetooth configuration is fixed.


### 5.2.05 (13.07.23)

**Corrections:**

- Display of the marketing name when connecting to the device remotely is fixed.
- Display of GSM-related settings for Galileosky V7X.1.8, V7X.1.81, V7X.1.82, V7X.1.83, V7X.1.51, V7X.1.52 and V7X.1.53 trackers is fixed.


### 5.2.04 (28.06.23)

**Corrections:**

- Uploading device configuration from a file on the Settings tab is fixed. 
- Error displaying settings for Galileosky V7X.1.8, V7X.1.81, V7X.1.82, V7X.1.83, V7X.1.51, V7X.1.52 and V7X.1.53 terminals are fixed.


### 5.2.03 (21.06.23)

**New features:**

- New firmware 27.8 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.9 for devices Galileosky BaseBlock is added.
- New firmware 38.20 for devices Galileosky 7x is added.
- Function ChargerEnable is added in EasyLogic scripts.

**Corrections:**

- Error of uploading the archive from the internal memory of the tracker is fixed.
- Device configuration error on Windows 7 OS is fixed. 

#### Changelog of firmware 27.8:

**Corrections:**

- In Easy Logic, the initial state of the variable "PUSH_TO_TALK_BUTTON_STATUS" is fixed.
- Time leaps on some Galileosky 7.0 devices is fixed.

#### Changelog of firmware 27.9:

**New features:**

- The IRIDIUMCSQ command has been added, which allows you to set the minimum signal level for data transmission through the Iridium modem.

**Corrections:**

- In Easy Logic, the initial state of the variable "PUSH_TO_TALK_BUTTON_STATUS" is fixed.
- Time leaps on some Galileosky 7.0 devices is fixed.

#### Changelog of firmware 38.20:

**New features:**

- The GSMAUTH command, which allows you to configure the type of authentication in the GSM network is added.
- Function ChargerEnable is added in EasyLogic scripts.
- The USERSPEC command has been added, which allows you to disable the functional modules of the firmware to free up RAM.

**Corrections:**

- Registration in some LTE networks is fixed.
- Registration in a GSM network is improved.
- Default quota for received data in Hub mode for devices with eMMC is fixed.
- In Easy Logic, the initial state of the variable "PUSH_TO_TALK_BUTTON_STATUS" is fixed.
- Time leaps on some Galileosky V7X devices is fixed.
- Upload of the client archive from the hub is improved.


### 5.2.02 (26.05.23)

**New features:**

- Information about Galileosky 7x trackers' RAM is now displayed on the Device tab.

**Corrections:**

- Program crash when disconnecting the tracker from the PC/from the USB port is fixed.
- Error causing multiple copies of the program to work is fixed.
- Program launch error on Windows 7 is fixed.


### 5.2.01 (19.05.23)

**New features:**

- New firmware 27.7 for devices Galileosky 7.0, OBD-II is added.
- New firmware 27.8 for devices Galileosky BaseBlock is added.
- New firmware 44.5 (release-candidate) for devices Galileosky 7x is added.
- New firmware 45.0 (beta-version) for devices Galileosky 7x is added.
- The option to connect and configure trackers via Bluetooth is added.
- Run event and Incoming event blocks added to the Easy Logic tab.
- New user interface - Modbus TCP server.
- New user interface - Escort FLS (RS485, Bluetooth). 

**Corrections:**

- Scaling of controls on screens with different DPI is fixed.
- CAN tag settings for Galileosky OBD-II devices is fixed.
- Program crash during Ins/Outs remote setting is fixed.

#### Changelog of firmwares 27.7, 27.8:

**Corrections:**

- If incorrect connection identifier is passed to SendAnswer function the answer will be sent to Configurator.

#### Changelog of firmware 44.5:

**Corrections:**

- Registration in some LTE networks is fixed.
- If incorrect connection identifier is passed to SendAnswer function the answer will be sent to Configurator.
- Loading of string parameters from the device's configuration is fixed.

#### Changelog of firmware 45.0:

**New features:**

- Bluetooth Low Energy is added API in Easy Logic.
- Configuring via Bluetooth is implemented.
- Support for up to 3 simultaneous Bluetooth Low Energy connections is added.
- Command to get BLE MAC address is added.
- "Run event" and "Incoming event" blocks added to Easy Logic.


### 5.1.07 (11.04.23)

**Corrections:**

- The error in displaying firmware list for Galileosky 2, 4 and 5 is fixed.


### 5.1.06 (05.04.23)

**New features:**

- New firmware 27.6 for devices Galileosky 7.0 is added.
- New firmware 27.7 for devices Galileosky BaseBlock is added.
- New firmware 38.19 for devices Galileosky 7x is added.
- New firmware 44.4 (release-candidate) for devices Galileosky 7x is added.
- Technical and informational notifications implemented.
- Detailed help system for settings on each tab developed.

**Corrections:**

- CAN logger settings are moved to the CAN Scanner - Receive/Transmit tab.
- Error in RS485 serial port configuration for Galileosky BaseBlock devices is fixed. 

#### Changelog of firmware 27.6:

**New features:**

- Parameter for setting the direction of reading IButton key ID bytes is added to IBCFG command.

**Corrections:**

- The error of running the algorithm starting with the Incoming SMS block with ANY_TEXT filter is fixed.
- The "switch between SIM-cards, when impossible to send data" mode is enabled by default.
- Incorrect value of navigation time in the EGTS protocol is fixed.

#### Changelog of firmware 27.7:

**New features:**

- Parameter for setting the direction of reading IButton key ID bytes is added to IBCFG command.

**Corrections:**

- The error of running the algorithm starting with the Incoming SMS block with ANY_TEXT filter is fixed.
- Incorrect value of navigation time in the EGTS protocol is fixed.

#### Changelog of firmware 38.19:

**Corrections:**

- Listing of files on SD card via command FSLIST is fixed.
- Reboot of the device after executing commands via Bluetooth is fixed.
- Incorrect value of navigation time in the EGTS protocol is fixed.

#### Changelog of firmware 44.4:

**New features:**

- Timeout setting before resetting the FLS tags is added.
- Creating a socket for incoming connections is added in EasyLogic.

**Corrections:**

- Listing of files on SD card via command FSLIST is fixed.
- Reboot of the device after executing commands via Bluetooth is fixed.
- Incorrect value of navigation time in the EGTS protocol is fixed.
- Getting value of constants PHONE_NUMBER_NUMERIC, CONNECTION_TYPE, CONNECTION_ID, COMMAND_NUMBER is fixed.


### 5.1.05 (21.03.23)

**New features:**

- New firmware 33.16 (beta-version) for devices Galileosky 7x is added.
- New firmware 38.18 for devices Galileosky 7x is added.
- New firmware 44.3 (release-candidate) for devices Galileosky 7x is added.
- Support for core, float, rational, fixed and string libraries in EasyLogic scripts is added.
- Support for global floating point variables in Easy Logic is added.

**Corrections:**

- Using RS232 port 1 when configuring Galileosky 7.0 devices is fixed.
- Protocol tag settings for Galileosky 7.0 devices are fixed.
- A list of supported RS232 equipment for Galileosky 7X instruments was fixed.
- Crash when connecting Galileosky V7X.4.1 devices is fixed.
- Device ID settings for Galileosky 7.0 devices are fixed.

#### Changelog of firmware 33.16:

**Corrections:**

- Upgrading to a firmware if it already exists in the device is fixed.

#### Changelog of firmware 38.18:

**Corrections:**

- Autoinformer sound is improved.
- Upgrading to a firmware if it already exists in the device is fixed.

#### Changelog of firmware 44.3:

**New features:**

- Support for core, float, rational, fixed and string libraries in EasyLogic scripts is added.
- Support for global floating point variables in Easy Logic is added.
- Firmware downloading is optimized.
- Parameter for setting the direction of reading IButton key ID bytes is added to IBCFG command.

**Corrections:**

- The "switch between SIM-cards, when impossible to send data" mode is enabled by default.
- Writing data to tags from a bluetooth device with different lengths of advertising packets is fixed.
- Autoinformer sound is improved.



### 5.1.04 (06.03.23)

**New features:**

- New firmware 33.15 (beta-version) for devices Galileosky 7x is added.
- New firmware 38.17 for devices Galileosky 7x is added.
- New firmware 44.2 (release-candidate) for devices Galileosky 7x is added.
- Drag&Drop upload is now available on the Files tab.
- Modules and features management was added as the Settings - System tab.
- Raw data packet length parameter to Bluetooth tags is added.
- The block "SamplingPeriodFilter" on the "Filters" tab is added.


**Corrections:**

- The error of running the algorithm starting with the Incoming SMS block with ANY_TEXT filter is fixed.
- Program crash during Easy Logic script compilation is fixed.
- The settings loading feature for devices connected via USB was changed.

#### Changelog of firmware 33.15:

**New features:**

- Automatic Allystar GNSS unit firmware upgrade is added.
- Bootloader 2.5 is added.
- Support for devices Galileosky V7X.4.x is added.
- Firmware downloading is optimized.
- Support for devices Galileosky V7X.1.83 is added.
- Support for devices Galileosky V7X.1.25 is added.
- Support for devices Galileosky V7X.0.86 is added.
- Support for devices Galileosky V7X.1.53 is added.

**Corrections:**

- Registration in Cat-M1 networks on devices with SIM7070G modem is fixed.
- Configuration loss made by newer firmwares is fixed.

#### Changelog of firmware 38.17:

**New features:**

- Script loading is improved.
- Support for devices Galileosky V7X.1.83 is added.
- Support for devices Galileosky V7X.1.25 is added.
- Support for devices Galileosky V7X.0.86 is added.
- Support for devices Galileosky V7X.1.53 is added.

**Corrections:**

- Reboot of the device when the SD card initialization failed is fixed.
- The error of running the algorithm starting with the Incoming SMS block with ANY_TEXT filter is fixed.
- The LED indication of the GNSS unit status is fixed.

#### Changelog of firmware 44.2:

**New features:**

- New entry containing milliseconds is added into galileosky protocol.
- The ENABLEARCHIVE command has been added, which allows you to disable the regular recording of archive points, while it remains possible to record a point from the Easy Logic algorithms.
- A new entry has been added to the galileosky protocol containing the reason for recording the archive point.
- Processing of 1-Wire keys for DS1991, DS1992 and DS1993 devices are added.
- iButton64 tags transmission has been added to the galileosky protocol.
- The USERSPEC command has been added, which allows you to disable the functional modules of the firmware to free up RAM.
- Support for the "SamplingPeriodFilter" block in filters is added.
- The number of supported polygonal geofences is increased to 1000000.
- Support for devices Galileosky V7X.1.83 is added.
- Support for devices Galileosky V7X.1.25 is added.
- Support for devices Galileosky V7X.0.86 is added.
- Support for devices Galileosky V7X.1.53 is added.
- Support for devices Galileosky V7X.4.x is added.

**Corrections:**

- The LED indication of the GNSS unit status is fixed.
- Writing data to tags from a bluetooth device with different lengths of advertising packets is fixed.


### 5.1.03 (03.02.23)

**New features:**

- Support for devices Galileosky V7X.4.x is added.
- Support for devices Galileosky BaseBlock V1.0.30 is added.
- New firmware 27.6 for devices Galileosky BaseBlock is added.
- New firmware 38.16 for devices Galileosky 7X is added.
- New firmware 44.1 (release-candidate) for devices Galileosky 7X is added.
- The option to change the remote configuration server is added on the "Security" tab. 

**Corrections:**

- Program crash during canceling settings loading is fixed.
- Error of the update downloading is fixed.
- Error of the configuration downloading for devices  Galileosky OBD-II is fixed.
- Error when uploading data to the server on the "Data" tab is fixed.

#### Changelog of firmware 27.06:

**New features:**

- Support for devices Galileosky BaseBlock V1.0.30 is added.

#### Changelog of firmware 38.16:

**New features:**

- Support for devices Galileosky V7X.4.x is added.

#### Changelog of firmware 44.1:

**Corrections:**

- Time syncronization is improved.
- In moving/during stop status detection is improved.
- Operation with CAN in Easy Logic is improved.
- Upload archive into file for the selected period is fixed.
- Reboot of the device when the SD card initialization failed is fixed.
- The error of running the algorithm starting with the Incoming SMS block with ANY_TEXT filter is fixed.
- The work of the bluetooth module is fixed.
- Sending response via remote config is fixed.


### 5.1.02 (31.01.23)

**Corrections:**

- Determination of port CAN1 existence by specification code is fixed.


### 5.1.01 (30.01.23)

**New features:**

- New firmware 38.15 for devices Galileosky 7x is added.
- New firmware 44.0 (release-candidate) for devices Galileosky 7x is added.
- New firmwares 25.17, 27.5 for devices Galileosky BaseBlock, 7.0 are added.
- Support for UDP protocol for connecting to monitoring servers is added.
- Support for TLS\SSL to connect to monitoring servers is added.
- Support for UDP and SSL in SockectOpen function is added.
- Functions SetLed and  RegularLedEnable are added in EasyLogic scripts.
- Functions IridiumGetMtmsn and IridiumGetMomsn are added in EasyLogic scripts.
- Tooltips to the command parameters on the "Settings" tab is added.

#### Changelog of firmware 38.15:

**Corrections:**

- Operation of the autoinformer is fixed.
- Registration in Cat-M1 networks on devices with SIM7070G modem is fixed.

#### Changelog of firmware 44.0:

**New features:**

- The WIFICHECKLEGACY command has been added to configure connection verification with the hub for Galileosky 7X WiFi devices.
- The REMOTECONFIGADDR command has been added to configure settings remote configuration.
- Invocation of RS485 handlers in EasyLogic for "Modbus" and "Modbus and FLS" peripheral is added.
- Functions SetLed and RegularLedEnable are added in EasyLogic scripts.
- Support for UDP protocol for connecting to monitoring servers is added.
- Support for TLS\SSL to connect to monitoring servers is added.
- Support for UDP and SSL in SockectOpen function is added.
- Extended information about Easy Logic scripts is added (SCRIPTINFO command).
- Stability of the script loading is improved.
- Authorized phone number maximum length is Increased up to 20 symbols.

#### Changelog of firmware 25.17 for devices Galileosky BaseBlock:

**New features:**

- Stability of the script loading is improved.

#### Changelog of firmware 27.5 for devices Galileosky BaseBlock:

**New features:**

- Functions IridiumGetMtmsn and IridiumGetMomsn are added in EasyLogic scripts.
- Processing of 1-Wire keys for DS1991, DS1992 and DS1993 devices are added.
- The format of the response to the command via the Iridium modem is changed.
- Stability of the script loading is improved.

**Corrections:**

- RAM usage is optimized.

#### Changelog of firmware 25.17 for devices Galileosky 7.0:

**New features:**

- Stability of the script loading is improved.

**Corrections:**

- Operating with RS-232, RS-485 configured for two stop bits is fixed.

#### Changelog of firmware 27.5 for devices Galileosky 7.0:

**New features:**

- Processing of 1-Wire keys for DS1991, DS1992 and DS1993 devices are added.
- Stability of the script loading is improved.

**Corrections:**

- Operating with RS-232, RS-485 configured for two stop bits is fixed.
- RAM usage is optimized.


### 5.0.06 (30.12.22)

**New features:**

- New firmware 38.14 for devices Galileosky 7x are added.
- New firmware 43.3 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Output of diagnostic messages in Russian from EasyLogic scripts on the Diagnostics tab is fixed.

#### Changelog of firmwares 38.14, 43.4:

**Corrections:**

- Automatic recovery upgrade for devices with bootloader version 2.3 and lower is fixed.
- Reboot of the device when connecting peripherals via RS-485 is fixed.


### 5.0.05 (26.12.22)

**New features:**

- New firmware 25.16 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 27.4 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- The connected device information is now displayed on the top bar of the main window.

#### Changelog of firmware 25.16 for devices Galileosky BaseBlock:

**Corrections:**

- Reboot of the device when receiving data from Wiegand 26 with an SD card inserted is fixed.
- Upload of static archive is fixed.
- Sending of zero coordinates via the Iridium unit at the start of the device is fixed.

#### Changelog of firmware 27.4 for devices Galileosky BaseBlock:

**New features:**

- Support for devices with Allystar GNSS unit is added.
- Support for two-way communication via Iridium unit is added.
- Functions IridiumEnable, IridiumELMode, IridiumReceive, IridiumTransmit, IridiumGetCntMsgToTransmit are added in EasyLogic scripts.
- Launch of EasyLogic scripts for receiving Iridium Ring Alert is added.
- Sending archive points via Iridium unit if the transmission timeout is 0 is disabled.
- Processing of parameters in the block "Run command" of EasyLogic is added.

**Corrections:**

- Reboot of the device when receiving data from Wiegand 26 with an SD card inserted is fixed.

#### Changelog of firmware 25.16 for devices Galileosky 7.0:

**Corrections:**

- Reboot of the device when receiving data from Wiegand 26 with an SD card inserted is fixed.
- Upload of static archive is fixed.

#### Changelog of firmware 27.4 for devices Galileosky 7.0:

**Corrections:**

- Reboot of the device when receiving data from Wiegand 26 with an SD card inserted is fixed.


### 5.0.04 (23.12.22)

**New features:**

- Transition from the remote configuration service opened in the browser to the application via the Configure link is added.
- User credentials saving feature is added.
- A context menu is added to All devices and Files tabs .

**Corrections:**

- Loading of CAN settings from the configuration file is fixed.
- Modbus params setting on the Settings tab is fixed.
- Error of displaying commands sent from the Commands tab during remote configuration is fixed.
- Error of the update downloading is fixed.


### 5.0.03 (16.12.22)

**New features:**

- Buttons to control the loading of parameters on the Settings tab (Cancel, Upload of unknown) are added.

**Corrections:**

- The built-in database on the CAN Scanner tab is updated.
- A compilation error in EasyLogic scripts that contain Russian names of global variables is fixed .


### 5.0.02 (13.12.22)

**Corrections:**

- Remarks on interaction with the remote control service is fixed.


### 5.0.01 (12.12.22)

**New features:**

- New version of remote control service is implemented:
    - Puting trackers into groups with multi-level nesting (group tree).
    - Sending commands to a group of devices and viewing the results of their execution.
    - Caching the trackers’ main settings.
    - Online process of loading the firmware and the algorithms to devices visible directly in the device list.
    - Possibility to delegate access rights from the device owner to other users using tokens.
    - File storage for storing files of algorithms, filters, configurations and documents that all employees of the company can access.
	
- Setup for checking the connection to the hub for Galileosky 7X WiFi devices is added.
- Device name line was added to "Identification data" on the "Device" tab for remote configuration.


### 4.25.16 (07.12.22)

**New features:**

- New firmware 38.13 for devices Galileosky 7x are added.
- New firmwares 33.14, 43.3 (beta-versions) for devices Galileosky 7x are added.
- Possibility to update the special service firmware (Recovery) for Galileosky 7X devices is added.
- TagWriteValue64 function is added to EasyLogic scripts.

**Corrections:**

- Downloading CAN tag settings on the "CAN Scanner" tab is fixed.
- Program crash during Easy Logic script compilation is fixed.
- Using special characters in algorithms' names on "Filters" and "EasyLogic" tabs is restricted.

#### Changelog of firmware 33.14:

**New features:**

- Bootloader 2.4 is added.
- Recovery firmware is added with possibility of manual (UPGRADERC) and automatic updating.
- Recovery firmware supports removing scripts of old and new firmwares.

#### Changelog of firmware 38.13:

**Corrections:**

- Formatting SD card in case of journaling is enabled is fixed.
- Scanning of BLE devices is fixed.
- Bugs in WebDAV operation on devices with SIM7500E and SIM7070G modems are fixed.

#### Changelog of firmware 43.3:

**Corrections:**

- Formatting SD card in case of journaling is enabled is fixed.
- iButton tags writing via TagWriteValue64 function in EasyLogic is fixed.
- Scanning of BLE devices is fixed.
- Bugs in WebDAV operation on devices with SIM7500E and SIM7070G modems are fixed.
- In EasyLogic functions ROMDelete, ROMRead and ROMWrite the range of keys has been changed (from 1 to 32).


### 4.25.15 (14.11.22)

**Corrections:**

- Error when uploading data to the server on the "Data" tab is fixed.
- Missing parameters to the J1979 protocol on the "CAN scanner" tab is added.
- Application installation in non-standard path is fixed.
- The built-in database on the "CAN Scanner" tab is updated.
- Incorrect working with the built-in database on the "CAN scanner" tab is fixed.


### 4.25.14 (31.10.22)

**New features:**

- New firmwares 32.19, 38.12 for devices Galileosky 7x are added.
- New firmwares 33.13, 39.10, 40.7, 41.6, 42.3, 43.2 (beta-versions) for devices Galileosky 7x are added.

#### Changelog of firmwares 32.19, 33.13, 38.12, 39.10, 40.7, 41.6, 42.3, 43.2:

**Corrections:**

- Modem operation on Galileosky V7X.1.81 devices is fixed.


### 4.25.13 (25.10.22)

**New features:**

- New firmwares 32.18, 38.11 for devices Galileosky 7x are added.
- New firmwares 39.9, 40.6, 41.5, 42.2, 43.1 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Incorrect opening files in the CAN-loger is fixed.
- Bluetooth tags setting on the "Settings" tab is fixed.

#### Changelog of firmwares 32.18, 38.11, 39.9, 40.6, 41.5, 42.2, 43.1:

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.


### 4.25.12 (19.10.22)

**New features:**

- Variables containing driving style are added in EasyLogic.
- Possibility to resize the script editor window is added in EasyLogic.
- Support for binary operations in formulas on the CAN Scanner tab is added.
- Option to write masks to CAN tags on the CAN Scanner tab is added.
- New firmware 25.15 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 27.3 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- New firmwares 32.17, 38.10 for devices Galileosky 7x are added.
- New firmwares 33.12, 39.8, 40.5, 41.4, 42.1, 43.0 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Incorrect saving of the TarFilter in the "Filters" tab is fixed.
- CAN-loger operating is improved.

#### Changelog of firmwares 25.15, 27.3 for devices Galileosky BaseBlock:

**New features:**

- ENCALG command to change GSM and GPRS encryption mode for Telit modem is added.

**Corrections:**

- Parsing of the alphanumeric address of the SMS sender is fixed.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Cyclic restart of device with Iridium modem due to low battery is fixed.
- Reading corrupted KML files is fixed.

#### Changelog of firmwares 25.15, 27.3 for devices Galileosky 7.0:

**Corrections:**

- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Reading corrupted KML files is fixed.

#### Changelog of firmware 32.17:

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Downloading scripts on Galileosky 7x C devices is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Reading corrupted KML files is fixed.

#### Changelog of firmware 33.12:

**New features:**

- Bootloader 2.3 is added.
- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.

**Corrections:**

- The maximum waiting time for registration in the GSM network has been increased to 2 hours.

#### Changelog of firmware 38.10:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Support for mask in CAN tags is added.

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Reading corrupted KML files is fixed.

#### Changelog of firmware 39.8:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Support for mask in CAN tags is added.

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Reading corrupted KML files is fixed.
- Allystar unit invalid coordinates is fixed.

#### Changelog of firmware 40.5:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Support for mask in CAN tags is added.

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Modem rebooting in case of its hanging is fixed.
- Reading corrupted KML files is fixed.
- Allystar unit invalid coordinates is fixed.

#### Changelog of firmware 41.4:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Data stored in ROM is isolated for each EasyLogic script.
- Support for mask in CAN tags is added.

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Modem rebooting in case of its hanging is fixed.
- Reading corrupted KML files is fixed.
- Allystar unit invalid coordinates is fixed.

#### Changelog of firmware 42.1:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Variables containing driving style are added in EasyLogic.
- Data stored in ROM is isolated for each EasyLogic script.
- Support for mask in CAN tags is added.

**Corrections:**

- Actions in EasyLogic "Get bytes from user array" and "Copy bytes to user array" are fixed.
- The maximum waiting time for registration in the GSM network has been increased to 2 hours.
- The speed of downloading archive via Configurator is increased.
- Launching multiple "Should make photo" handlers in EasyLogic is fixed.
- Parsing of the alphanumeric address of the SMS sender is fixed.
- Receiving data using protocol Wiegand26 from devices connected to inputs 2 and 3 is fixed.
- Modem rebooting in case of its hanging is fixed.
- Reading corrupted KML files is fixed.
- Allystar unit invalid coordinates is fixed.

#### Changelog of firmware 43.0:

**New features:**

- Support for devices Galileosky V7X.1.52 and Galileosky V7X.1.82 is added.
- Variables containing driving style are added in EasyLogic.
- Amount of simultaneous connections to the WiFi hub is increased up to 3.
- Data stored in ROM is isolated for each EasyLogic script.
- Support for mask in CAN tags is added.
- Autoinformer out is always on when playing an audio file.


### 4.25.11 (06.09.22)

**New features:**

- Possibility to configure bands on devices with SIM7070G modem is added.
- Possibility to change bluetooth device name is added.
- Tags MODBUS on the "Filters" tab is available.
- New firmware 25.14 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 27.2 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- New firmwares 32.16, 38.9 for devices Galileosky 7x are added.
- New firmwares 33.11, 39.7, 40.4, 41.3, 42.0 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Escort TH BLE sensor parameters parsing is fixed.

#### Changelog of firmwares 25.14, 27.2 for devices Galileosky BaseBlock:

**New features:**

- Processing of SMS received from the alphanumeric address of the sender is added.

**Corrections:**

- The launch of chains starting by "RS485 Handler" event and contained in different scripts is fixed.

#### Changelog of firmwares 25.14, 27.2 for devices Galileosky 7.0:

**New features:**

- Processing of SMS received from the alphanumeric address of the sender is added.

**Corrections:**

- Connection hang-up when connecting to the server when operating with some mobile network operators on terminals with SIM800C modems is fixed.
- The launch of chains starting by "RS485 Handler" event and contained in different scripts is fixed.

#### Changelog of firmwares 32.16, 38.9:

**New features:**

- Possibility to configure bands on devices with SIM7070G modem is added.

**Corrections:**

- Escort TH BLE sensor parameters parsing is fixed.
- The launch of chains starting by "RS485 Handler" event and contained in different scripts is fixed.
- Scanning of BLE devices is improved.
- The LED indication of the Wi-Fi module status was fixed.

#### Changelog of firmware 33.11:

**Corrections:**

- Possibility to configure bands on devices with SIM7070G modem is added.

#### Changelog of firmwares 39.7, 40.4, 41.3:

**New features:**

- Possibility to configure bands on devices with SIM7070G modem is added.
- New types of objects (Bus, Train) in coordinate filtering are added.

**Corrections:**

- Escort TH BLE sensor parameters parsing is fixed.
- The launch of chains starting by "RS485 Handler" event and contained in different scripts is fixed.
- Scanning of BLE devices is improved.
- The LED indication of the Wi-Fi module status was fixed.

#### Changelog of firmware 42.0:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81 is added.
- Support for operators: bitwise AND (&), bitwise OR (|), bitwise XOR (^), remainder (%), bitwise left shift (<), bitwise right shift(>) is added to CAN filters formula.
- Diagnostic messages about the reason of powering off of units GSM, GNSS, WIFI and SD card.
- iButton and MODBUS tags are available for writing in EasyLogic.
- MODBUS tags are available in filters.
- Possibility to change bluetooth device name is added.


### 4.25.10 (23.08.22)

**New features:**

- The Ctrl+Enter(Numpad) key combination to send the current command in the "Commands" tab has been added.
- New firmwares 32.15, 38.8 for devices Galileosky 7x are added.
- New firmwares 33.10, 39.6, 40.3, 41.2 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Displaying of satellite information on the "Device" tab for devices Galileosky BaseBlock, 7.0, OBD-II is fixed.
- Incorrect working of the TarFilter on the "Filters" tab is fixed.

#### Changelog of firmware 32.15:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81.
- Processing of SMS received from the alphanumeric address of the sender is added.

**Corrections:**

- Erasing old files of archive on SD card is fixed.
- Uploading data via WebDAV when connected via WiFi is fixed.
- Incorrect result of WIFIMAC command is fixed.
- Directory deleting is fixed.
- Connection hang-up when connecting to the server when operating with some mobile network operators on terminals with SIM800C modems is fixed.
- Galileosky 7X LTE devices registration on the network of some mobile operators is fixed.

#### Changelog of firmware 33.10:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81.

#### Changelog of firmware 38.8:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81.
- Processing of SMS received from the alphanumeric address of the sender is added.

**Corrections:**

- Erasing old files of archive on SD card is fixed.
- Uploading data via WebDAV when connected via WiFi is fixed.
- Incorrect result of WIFIMAC command is fixed.
- Directory deleting is fixed.
- Formatting SD card with ExFAT file system is fixed.
- Using LBS as data source is fixed.
- Connection hang-up when connecting to the server when operating with some mobile network operators on terminals with SIM800C modems is fixed.
- Galileosky 7X LTE devices registration on the network of some mobile operators is fixed.

#### Changelog of firmware 39.6:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81.
- Processing of SMS received from the alphanumeric address of the sender is added.
- Improved coordinate filtering system is added.

**Corrections:**

- Erasing old files of archive on SD card is fixed.
- Uploading data via WebDAV when connected via WiFi is fixed.
- Incorrect result of WIFIMAC command is fixed.
- Directory deleting is fixed.
- Formatting SD card with ExFAT file system is fixed.
- Using LBS as data source is fixed.
- Connection hang-up when connecting to the server when operating with some mobile network operators on terminals with SIM800C modems is fixed.
- Galileosky 7X LTE devices registration on the network of some mobile operators is fixed.

#### Changelog of firmwares 40.3, 41.2:

**New features:**

- Support for devices Galileosky V7X.1.22 and Galileosky V7X.1.81.
- Processing of SMS received from the alphanumeric address of the sender is added.
- Improved coordinate filtering system is added.

**Corrections:**

- Erasing old files of archive on SD card is fixed.
- Uploading data via WebDAV when connected via WiFi is fixed.
- Incorrect result of WIFIMAC command is fixed.
- Directory deleting is fixed.
- Formatting SD card with ExFAT file system is fixed.
- Using LBS as data source is fixed.
- Connection hang-up when connecting to the server when operating with some mobile network operators on terminals with SIM800C modems is fixed.
- Simultaneous operation with several 1-wire devices is fixed.
- Galileosky 7X LTE devices registration on the network of some mobile operators is fixed.


### 4.25.09 (18.07.22)

**New features:**

- New firmwares 32.14, 38.7 for devices Galileosky 7x are added.
- New firmware 27.0 (beta-version) for devices Galileosky BaseBlock, 7.0, OBD-II is added.
- New firmwares 33.9, 39.5, 40.2, 41.1 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Sending a saved configuration during remote configuring is fixed.

#### Changelog of firmware 27.1:

**Corrections:**

- Self-troubleshooting criteria for auto reboot are corrected.

#### Changelog of firmware 32.14, 33.9, 38.7, 39.5:

**New features:**

- Support for device Galileosky V7X.0.82 is added.

#### Changelog of firmware 40.2, 41.1:

**New features:**

- Support for device Galileosky V7X.0.82 is added.

**Corrections:**

- Self-troubleshooting criteria for auto reboot are corrected.


### 4.25.08 (01.07.22)

**New features:**

- Possibility to configure the transmission of parameters via the J1979 protocol in CAN scanner tab is added.
- New firmwares 32.13, 38.6 for devices Galileosky 7x are added.
- New firmwares 33.8, 39.4, 40.1, 41.0 (beta-versions) for devices Galileosky 7x are added.

**Corrections:**

- Variables description on the "Filters" and "Easy Logic" tabs in case if locale of operating system is not English and not Russian is fixed.
- The built-in database in the CAN Scanner is updated.

#### Changelog of firmware 32.13:

**New features:**

- Support for devices Galileosky V7X.1.8, Galileosky V7X.0.83 is added.
- Automatic update to 33 firmware with bootloader update when using the UPGRADE X command is added, where X=0 or greater than 33.

**Corrections:**

- The value of the "Driving style" tag when using the accelerometer as a data source is fixed.

#### Changelog of firmware 33.08:

**New features:**

- Automatic bootloader update and update to firmware X is added, when using the UPGRADE X command on firmware 32 (starting from 32.13), where X=0 or greater than 33.
- Support for devices Galileosky V7X.0.83 is added.

#### Changelog of firmware 38.6, 39.4, 40.1:

**New features:**

- Support for devices Galileosky V7X.1.8, Galileosky V7X.0.83 is added.

**Corrections:**

- The value of the "Driving style" tag when using the accelerometer as a data source is fixed.
- MODBUS operation in ASCII mode is fixed.
- Stability of reading MODBUS registers is improved.

#### Changelog of firmware 41.0:

**New features:**

- Functions ROMDelete, ROMRead, ROMWrite, ROMErase are added in EasyLogic scripts.
- Possibility to configure J1979 parameters is added.
- The internal archive uploading speed to the hub is increased.
- Processing of parameters in the block "Run command" of EasyLogic is added.
- Support for devices Galileosky V7X.1.8, Galileosky V7X.0.83 is added.


### 4.25.07 (14.06.22)

**New features:**

- "Self-troubleshooting" tab to control for trigger criteria is added.
- Information about self-troubleshooting on the "Device" tab is added.
- Variables containing progress of a client's archive uploading to the hub are added in EasyLogic.
- Functions RAMErase, RAMRead, RAMWrite are added in EasyLogic scripts.
- New firmware 25.13 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 27.0 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- New firmwares 32.12, 38.5 for devices Galileosky 7x are added.
- New firmwares 33.7, 39.3, 40.0 (beta-versions) for devices Galileosky 7x are added.
- Possibility to choose a satellite navigation system on the "Track" tab for devices Galileosky BaseBlock, 7.0 is added.

**Corrections:**

- Error displaying a context menu in the device information window is fixed.
- Program crash during Geofence row deleting for devices Galileosky 2.3 is fixed.

#### Changelog of firmware 25.13:

**Corrections:**

- Uploading internal archive stuck is fixed.

#### Changelog of firmware 27.0:

**New features:**

- Possibility to choose a satellite navigation system is added.
- Information about satellites is added (command SATINFOEXT).
- Self-troubleshooting feature is added.
- Increase mileage accuracy at high values.

#### Changelog of firmwares 32.12, 38.5, 39.3:

**New features:**

- Scanning of BLE devices is improved.

**Corrections:**

- Operation with APN on Galileosky 7X LTE devices is fixed.
- Uploading internal archive stuck is fixed.
- Incorrect RSSI tag value is fixed.
- Checking connection to the hub is fixed.
- Retrieving coordinates via LBS for modem SIMCom 7500E is fixed.

#### Changelog of firmware 33.7:

**New features:**

- Support for devices Galileosky 7X.1.8 is added.
- Bootloader version is added to the response of SOFTVERSION command.

**Corrections:**

- Operation with APN on Galileosky 7X LTE devices is fixed.

#### Changelog of firmware 40.0:

**New features:**

- Device self-troubleshooting is added.
- Support for sockets in EasyLogic over WiFi connection is added.
- Variables containing progress of a client's archive uploading to the hub are added in EasyLogic.
- Scanning of BLE devices is improved.
- Functions RAMErase, RAMRead, RAMWrite are added in EasyLogic scripts.
- Automatic baud rate detection for weight indicator Tenzo-M is added.
- Increase mileage accuracy at high values.

**Corrections:**

- Received value multiplication by 100 for int32 MODBUS registers is removed.


### 4.25.06 (08.04.22)

**New features:**

- Support for devices Galileosky V7X.1.8 is added.
- Possibility to set an arbitrary CAN-bus speed on the CAN Scanner tab is added.
- New firmware 25.12 for devices Galileosky BaseBlock, 7.0 is added.
- New firmwares 32.11, 38.4 for devices Galileosky 7x are added.
- New firmware 39.2 (beta-version) for devices Galileosky 7x is added.

**Corrections:**

- Scaling of navigation data on the "Device" tab is fixed.

#### Changelog of firmware 25.12:

**Corrections:**

- Flash memory chip detecting is fixed.
- Call hangup with PTT is fixed.

#### Changelog of firmwares 32.11, 38.4:

**Corrections:**

- Device rebooting while using PortInit function in an EasyLogic script is fixed.
- Inability to discover WiFi network is fixed.
- Wrong filename generating in hub while saving data from client is fixed.
- Hanging WiFi module is fixed.
- Call hangup with PTT is fixed.
- Connecting to servers except hub service is prohibited while device is connected to hub.
- Automatic switching to GPRS in the absence of Internet access via WiFi is fixed.

#### Changelog of firmware 39.2:

**Corrections:**

- Device rebooting while using PortInit function in an EasyLogic script is fixed.
- Inability to discover WiFi network is fixed.
- Wrong filename generating in hub while saving data from client is fixed.
- Hanging WiFi module is fixed.
- Incorrect saving of tags when using the transfer of arbitrary data from the BLE advertising package is fixed.
- Call hangup with PTT is fixed.
- Connecting to servers except hub service is prohibited while device is connected to hub.
- Automatic switching to GPRS in the absence of Internet access via WiFi is fixed.


### 4.25.05 (18.03.22)

**New features:**

- Support for devices Galileosky V7X.3.0 is added.
- New firmware 25.11 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 32.10 for devices Galileosky 7x is added.
- New firmwares 33.6, 32.10, 37.4, 38.3, 39.1 (beta-version) for devices Galileosky 7x are added.

**Corrections:**

- Error when copying the "CAN bus" action blocks in Easy Logic is fixed.
- Compilation error due to a whitespace trailing functions SetVar/GetVar/GetVarAddr in EasyLogic scripts is fixed.

#### Changelog of firmware 25.11:

**Corrections:**

- Operation with lists of mobile operators codes is improved.

#### Changelog of firmware 33.6:

**New features:**

- Support for devices Galileosky V7X.3.0 is added.
- Bootloader 2.2 is added.

**Corrections:**

- Battery voltage check during bootloader upgrade is fixed.

#### Changelog of firmwares 32.10, 37.4, 38.3, 39.1:

**New features:**

- Support for devices Galileosky V7X.3.0 is added.

**Corrections:**

- Operation with lists of mobile operators codes is improved.
- CAN bus speed automatic detection is fixed.


### 4.25.04 (28.02.22)

**New features:**

- GetVarAddr function to get address of global variable from EasyLogic script is added.
- A source data scanner on the "Bluetooth" tab for devices Galileosky 7 X is added.
- New firmwares 23.25, 25.10 for devices Galileosky BaseBlock, 7.0 are added.
- New firmware 32.9 for devices Galileosky 7x is added.
- New firmwares 37.3, 38.2, 39.0 (beta-version) for devices Galileosky 7x are added.

**Corrections:**

- Analysis of EasyLogic scripts during compilation is improved.
- Error in algorithm uploading during remote configuration session is fixed.
- In EasyLogic, when clicking on a free field, it is also possible to deselect blocks in other tabs.
- Incorrect display of information on the "Settings" tab for devices Galileosky 7X LTE is fixed.
- Scaling of buttons on the "Filters" and "Easy Logic" tabs is fixed.
- Missing variables error when saving Easylogic script is fixed.
- Error with copying EasyLogic algorithms is fixed.
- The built-in database in the CAN Scanner is updated.
- Tags setting in Bluetooth packet on the "Settings" tab for devices Galileosky 7X LTE is fixed.
- Work with bluetooth sensors Technoton is fixed.

#### Changelog of firmwares 23.25, 25.10 for devices Galileosky BaseBlock:

**New features:**

- Return of the result of the PortInit function from the EasyLogic script is added.

**Corrections:**

- Operating with Iridium unit is improved.
- Error loading EasyLogic algorithms is fixed.
- Incorrect status of no connection with DataCold 500 installation is fixed.

#### Changelog of firmwares 23.25, 25.10 for devices Galileosky 7.0:

**New features:**

- Return of the result of the PortInit function from the EasyLogic script is added.

**Corrections:**

- Error loading EasyLogic algorithms is fixed.
- Incorrect status of no connection with DataCold 500 installation is fixed.

#### Changelog of firmwares 32.9, 37.3, 38.2:

**New features:**

- Return of the result of the PortInit function from the EasyLogic script is added.

**Corrections:**

- No sound on a voice call after modem restart is fixed.
- Creating of packet of protocol Galileosky with compression is fixed.
- Error loading EasyLogic algorithms is fixed.
- Operating with Technoton bluetooth sensors is fixed.
- The incorrect status of the lack of communication with the DataCold 500 installation is fixed.
- Connection to AP using WEP authentication type is fixed.
- Calculation of the total average SNR in satellite information is fixed.

#### Changelog of firmware 39.0:

**New features:**

- Possibility to transfer arbitrary data from the BLE advertising packet is added.


### 4.25.03 (13.01.22)

**New features:**

- New firmwares 31.11, 32.8 for devices Galileosky 7x are added.
- New firmwares 33.5, 37.2, 38.1 (beta-version) for devices Galileosky 7x are added.

**Corrections:**

- Incorrect sending of points with negative coordinates via the "Data" tab is fixed.
- Delay with display of data on the "Device" tab is fixed.

#### Changelog of firmwares 31.11, 33.5:

**Corrections:**

- Points statistic in internal archive is fixed.

#### Changelog of firmwares 32.8, 37.2, 38.1:

**Corrections:**

- Time synchronization via GSM on Galileosky 7X LTE devices is fixed.
- Points statistic in internal archive is fixed.


### 4.25.02 (28.12.21)

**New features:**

- Script upload server setting is added.
- Firmware update server setting is added.
- The possibility to select vehicle parameters from the built-in database when working with CAN is added.
- The possibility to save and load scripts in binary format is added.
- New firmware 230.2 for devices Galileosky 1.9.0, 1.9.5 with bootloader version 0 is added.
- New firmwares 23.24, 25.9 for devices Galileosky BaseBlock, 7.0 are added.
- New firmwares 31.10, 32.7 for devices Galileosky 7x are added.
- New firmwares 37.1, 38.0 (beta-version) for devices Galileosky 7x are added.

**Corrections:**

- Incorrect display of the year on the "Device" tab is fixed.
- Display of the right panel on the Routes tab when the application is small is fixed.
- Incorrect loading of parameters from the TarFilter and FuelTarFilter is fixed.
- Incorrect display of IMEI in case of unsuccessful registration of the device is fixed.
- In the "Send answer" Easy Logic block, the substitution of arguments is fixed.

#### Changelog of firmware 230.2:

**Corrections:**

- Notification via SMS and call in case of alarm is fixed.
- Length limit of response to remote configuration commands is increased.

#### Changelog of firmwares 23.23, 25.8:

**Corrections:**

- Automatic switching to internal coordinate source is fixed.

#### Changelog of firmwares 23.23, 25.8:

**Corrections:**

- Automatic switching to internal coordinate source is fixed.

#### Changelog of firmwares 31.10, 32.7:

**Corrections:**

- Automatic switching to internal coordinate source is fixed.
- Operating with SD cards is improved.
- Going to sleep mode in case of low external power voltage is fixed.

#### Changelog of firmware 37.1:

**Corrections:**

- Automatic switching to internal coordinate source is fixed.
- Updating of WIFI_HUB_CONNECTED status is fixed.
- Operating with SD cards is improved.
- Going to sleep mode in case of low external power voltage is fixed.

#### Changelog of firmware 38.0:

**New features:**

- Script upload server setting is added.
- Firmware update server setting is added.
- The possibility to select vehicle parameters from the built-in database when working with CAN is added.


### 4.25.01 (25.10.21)

**New features:**

- The limitation of 10 registers per modbus device is removed.
- The possibility to send CCID and index of the current SIM card are added.
- The possibility to ignore speed binding when detecting ignition input voltage is added.
- New firmware 232.2 for devices Galileosky 1.9.5, 4.0, 5.0, 5.1 with bootloader version 0 is added.
- New firmware 23.23 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 25.8 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 31.9 for devices Galileosky 7x is added.
- New firmware 32.6 (release-candidate) for devices Galileosky 7x is added.
- New firmwares 33.4, 36.2, 37.0 (beta-version) for devices Galileosky 7x are added.

**Corrections:**

- Search for a remote device by IMEI is improved.
- Error with creating a route name not in Latin is fixed.
- Display of satellite information field for old devices is fixed.
- Incorrect CAN request for Base Block devices is fixed.
- Non-printable characters are trimmed in the password input field when registering a device.

#### Changelog of firmware 232.2:

**Corrections:**

- Notification via SMS and call in case of alarm is fixed.
- Length limit of response to remote configuration commands is increased.

#### Changelog of firmwares 23.23, 25.8:

**Corrections:**

- Parsing NMEA messages is fixed.
- Recording time of archive points is fixed.
- Handlers in Easy Logic for events "Make photo" and "RS485 handler" are fixed.

#### Changelog of firmware 31.9:

**Corrections:**

- Reboot during initialization of serial port with large buffer is fixed.
- Initialization of serial port RS-485 is fixed.
- Parsing NMEA messages is fixed.
- Transfer of points along the "client-hub-hub" chain for trackers with WiFi is fixed.
- Recording time of archive points is fixed.
- Handlers in Easy Logic for events "Make photo" and "RS485 handler" are fixed.
- SMS processing on devices with Ublox modems is fixed.

#### Changelog of firmware 33.4:

**Corrections:**

- SMS processing on devices with Ublox modems is fixed.

#### Changelog of firmwares 32.6, 36.2:

**Corrections:**

- Reboot during initialization of serial port with large buffer is fixed.
- Initialization of serial port RS-485 is fixed.
- Parsing NMEA messages is fixed.
- Transfer of points along the "client-hub-hub" chain for trackers with WiFi is fixed.
- Recording time of archive points is fixed.
- Polling timer LBS is fixed.
- Handlers in Easy Logic for events "Make photo" and "RS485 handler" are fixed.
- SMS processing on devices with Ublox modems is fixed.

#### Changelog of firmware 37.0:

**New features:**

- Sending CCID and the index of active SIM-card in Galileosky protocol is added.
- The limitation of 10 registers per Modbus device is removed.
- The possibility to ignore speed while detecting input voltage is added.


### 4.25.00 (13.09.21)

**New features:**

- Information about CCID on the "Device" tab is added.
- Converter of audio files on the "Routes" tab is added.
- Support for Garmin navigators is added.
- New firmware 23.22 for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 25.7 (beta-version) for devices Galileosky BaseBlock, 7.0 is added.
- New firmware 31.8 for devices Galileosky 7x is added.
- New firmware 32.5 (release-candidate) for devices Galileosky 7x is added.
- New firmware 33.3 (beta-version) for devices Galileosky 7x is added. This firmware is designed only for upgrading a bootloader.
- New firmware 36.1 for devices Galileosky 7x is added.

**Corrections:**

- Automated collection of diagnostic data is improved.
- The work of tooltips for commands is fixed.
- Operating with tags on the "Modbus" tab is improved.
- Operating with Modbus tags on the "Protocol" tab for Galileosky 7xC devices is fixed.
- Displaying of data in the device information window is improved.

#### Changelog of firmwares 23.22, 25.7:

**Corrections:**

- Memory consumption during file system operating is decreased.

#### Changelog of firmwares 31.8, 32.5:

**New features:**

- Commands for moving (FSMOVE) and deleting (FSDELETE) files and directories are added.

**Corrections:**

- Memory consumption during file system operating is decreased.
- Variables WIFI_CLIENT_CONNECTED and WIFI_RSSI in EasyLogic are fixed.
- Operation of the terminal by the ACTIVECAN command is fixed.
- Problems with network registration and data transmission on Galileosky 7X LTE devices are fixed.

#### Changelog of firmware 33.3:

**New features:**

- Bootloader 2.1 is added.

**Annotations:**

This firmware is designed only for upgrading a bootloader to version 2.1 and for upgrading firmware from version 32 or lower to version 34 or greater.

Before updating the bootloader, make sure that the device is connected to an external power source with a voltage of at least 8V.

- Send the UPGRADEBL command. A 4-digit code will be sent in response.
- Send the UPGRADEBL command with the code received in the previous step.
- The device will reboot and the bootloader will be updated.
- Upgrade to firmware 34.0 or greater.

#### Changelog of firmware 36.1:

**New features:**

- Commands for moving (FSMOVE) and deleting (FSDELETE) files and directories are added.
- Support for Garmin navigator is added.

**Corrections:**

- Memory consumption during file system operating is decreased.
- Variables WIFI_CLIENT_CONNECTED and WIFI_RSSI in EasyLogic are fixed.
- Operation of the terminal by the ACTIVECAN command is fixed.
- Problems with network registration and data transmission on Galileosky 7X LTE devices are fixed.

**Annotations:**

ATTENTION:

Upgrading to this firmware is available from firmware 33.0 or greater.
This firmware requires bootloader 2.0 or greater.


### 4.24.04 (09.08.21)

**New features:**

- Information about satellites on the "Device" tab is added.
- The possibility to send information about satellites is added.
- The possibility to send IMSI is added.
- Support for new devices Galileosky 7X LTE/4G is added.
- New firmwares 28.7, 30.7, 31.7 for devices Galileosky 7x are added.
- New firmware 32.4 (beta-version) for devices Galileosky 7x is added.
- New firmware 33.2 (beta-version) for devices Galileosky 7x is added. This firmware is designed only for upgrading a bootloader.
- New firmwares 34.3, 35.1, 36.0 for devices Galileosky 7x are added.

**Corrections:**

- Errors that occurred when undoing/redoing last actions in EasyLogic are fixed.
- Errors with using variables in EasyLogic are fixed.
- Error with impossible setting of device id for EGTS protocol more than 65535 is fixed.

#### Changelog of firmwares 28.7, 30.7:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.

#### Changelog of firmware 31.7:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.
- eMMC support is added.

#### Changelog of firmware 32.4:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.
- eMMC support is added.

#### Changelog of firmware 33.2:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.
- eMMC support is added.

**Annotations:**

This firmware is designed only for upgrading bootloader to version 2.0 and for upgrading firmware from version 32 or lower to version 34 or greater.

Before updating the bootloader, make sure that the device is connected to an external power source with a voltage of at least 8V.

- Send UPGRADEBL command. A 4-digit code will be sent in response.
- Send the UPGRADEBL command with the code received in the previous step.
- The device will reboot and the bootloader will be updated.
- Upgrade to firmware 34.0 or greater.

#### Changelog of firmwares 34.3, 35.1:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.
- eMMC support is added.

**Annotations:**

ATTENTION:

Upgrading to this firmware is available from firmware 33.0 or greater.
This firmware requires bootloader 2.0 or greater.

#### Changelog of firmware 36.0:

**New features:**

- Support for new devices Galileosky 7X LTE/4G is added.
- eMMC support is added.
- Information about satellites is added (command SATINFOEXT).
- The possibility to send information about satellites is added.
- The possibility to send IMSI information is added.

**Annotations:**

ATTENTION:

Upgrading to this firmware is available from firmware 33.0 or greater.
This firmware requires bootloader 2.0 or greater.

### 4.24.03 (16.07.21)

**New features:**

- Setting for rebooting the terminal by time is added.
- GNSS jamming status is added.
- Automated collection of diagnostic data is added.
- New firmware 25.6 (beta-version) for devices Galileosky 7.0, BaseBlock is added.
- New firmware 35.0 (beta-version) for device Galileosky 7x is added.

**Corrections:**

- Display of MAC-address in device status for terminals without WiFi is fixed.

#### Changelog of firmware 25.6:

**New features:**

- Setting for rebooting the terminal by time is added.

#### Changelog of firmware 35.0:

**New features:**

- CAN Bot is added.
- Setting for rebooting the terminal by time is added.
- GSM jamming detection is added.
- Support for A-GNSS is added.

### 4.24.02 (01.07.21)

**New features:**

- Undo/redo last 20 actions in Easy Logic is added.
- Possibility to send more accurate data from DS1820 temperature sensors is added.
- New firmware 23.21 for devices Galileosky 7.0, BaseBlock is added.
- New firmware 25.5 (beta-version) for devices Galileosky 7.0, BaseBlock is added.
- New firmware 28.6 for device Galileosky 7x is added.
- New firmware 30.6 (release-candidatee) for device Galileosky 7x is added.
- New firmwares 31.6, 32.3, 34.2 (beta-versions) for device Galileosky 7x are added.

**Corrections:**

- Appearance of firmware description in case if locale of operating system is not English and not Russian is fixed.

#### Changelog of firmwares 23.21, 25.5, 28.6, 30.6, 31.6:

**Corrections:**

- Sending user array via ETGS protocol is fixed.

#### Changelog of firmwares 32.3, 34.2:

**New features:**

- Possibility to send more accurate data from DS1820 temperature sensors is added.

**Corrections:**

- Sending user array via ETGS protocol is fixed.

### 4.24.01 (23.06.21)

**New features:**

- New firmware 23.20 for devices Galileosky 7.0, BaseBlock is added.
- New firmware 25.4 (beta-version) for devices Galileosky 7.0, BaseBlock is added.
- New firmware 28.5 for device Galileosky 7x is added.
- New firmware 30.5 (release-candidatee) for device Galileosky 7x is added.
- New firmwares 31.5, 32.2, 34.1 (beta-versions) for device Galileosky 7x are added.
- New firmware 33.1 (beta-versions) for for device Galileosky 7x is added. ***This firmware is designed only for upgrading a bootloader.***

**Corrections:**

- Loading security settings from configuration file is fixed.
- Tooltip for UMOUNT command is fixed.

#### Changelog of firmware 23.20:

**Corrections:**

- Operating with dynamic archive is fixed.

#### Changelog of firmware 25.4:

**New features:**

- Possibility to configure timeout of waiting for registration on GSM network is added.

**Corrections:**

- Operating with dynamic archive is fixed.

#### Changelog of firmwares 28.5, 30.5, 31.5:

**Corrections:**

- Operating with archive is fixed.
- Operating with CAN formulas is fixed.

#### Changelog of firmware 32.2:

**Corrections:**

- Operating with archive is fixed.
- Operating with CAN formulas is fixed.
- Switching to sleep mode is fixed.

#### Changelog of firmware 33.1:

**Corrections:**

- Switching to sleep mode is fixed.

**Annotations:**

- This firmware is designed only for upgrading a bootloader to version 2.0 and for upgrading a firmware from version 32 or lower to version 34 or greater.

#### Changelog of firmware 34.1:

**Corrections:**

- Operating with archive is fixed.
- Operating with CAN formulas is fixed.
- Switching to sleep mode is fixed.

**Annotations:**

- Upgrading to this firmware is available from firmware 33.0 or greater.
- This firmware requires bootloader 2.0 or greater.

### 4.24.00 (22.06.21)

**New features:**

- The ability to get a 64-bit key in EasyLogic is added.
- A new variable in EasyLogic containing the status of the connection to the hub is added.
- Amount of Modbus tags is increased up to 64.
- New firmware 23.19 for devices Galileosky 7.0, BaseBlock is added.
- New firmware 25.3 (beta-version) for devices Galileosky 7.0, BaseBlock is added.
- New firmware 26.7 form device Galileosky 7x is added.
- New firmwares 28.4 (release-candidatee), 30.4, 31.4, 32.1, 34.0 (beta-version) for device Galileosky 7x are added.
- New firmware 33.0 for for device Galileosky 7x is added. ***This firmware is designed only for upgrading a bootloader.***

**Corrections:**

- Display of MAC-address in device status for terminals with WiFi is fixed.
- In the settings on the "Security" tab, the name of the "Access PIN" field has been changed to "Access Code".
- Errors with creation of EasyLogic variables are fixed.
- Download archive into file is fixed.
- Configuration of information tags for current cell tower is fixed.
- Display of general settings on the "Alarm" tab is fixed.

#### Changelog of firmwares 23.19, 25.3:

**New features:**

- A new variable in EasyLogic containing the status of the connection to the hub is added.

**Corrections:**

- SD archive stability is improved.

#### Changelog of firmware 26.7:

**Corrections:**

- SD archive stability is improved.
- Operating with the Exigner mobile application is fixed.
- Operating with two iButton readers is fixed.
- Parsing of parameters of the Escort tilt angle sensor is fixed.
- Resetting CAN tags in case of disabled CAN is fixed.

#### Changelog of firmwares 28.4, 30.4, 31.4:

**Corrections:**

- SD archive stability is improved.
- Operating with hand-held PTT switch is fixed.
- Operating with the Exigner mobile application is fixed.
- Operating with two iButton readers is fixed.
- Parsing of parameters of the Escort tilt angle sensor is fixed.
- Resetting CAN tags in case of disabled CAN is fixed.

#### Changelog of firmware 32.1:

**Corrections:**

- Operating with the Exigner mobile application is fixed.
- Operating with two iButton readers is fixed.
- Receiving coordinates by GSM network signals is fixed.
- Parsing of parameters of the Escort tilt angle sensor is fixed.
- Resetting CAN tags in case of disabled CAN is fixed.
- Tag numbers of information about the connected current base station are changed.

#### Changelog of firmware 33.0:

**New features:**

- Bootloader upgrading is implemented (command UPGRADEBL).
- Improved stability and performance.

**Annotations:**

- This firmware is designed only for upgrading a bootloader to version 2.0 and for upgrading a firmware from version 32 or lower to version 34 or greater.

#### Changelog of firmware 34.0:

**New features:**

- Variable showing the connection status to hub is added to EasyLogic.
- Amount of Modbus tags is increased up to 64.

**Annotations:**

- Upgrading to this firmware is available from firmware 33.0 or greater.
- This firmware requires bootloader 2.0 or greater.


### 4.23.06 (31.05.21)

**Corrections:**

- Display of EasyLogic status during remote configuration session is fixed.

### 4.23.05 (28.05.21)

**New features:**

- Possibility to use LBS as a coordinate source is added.
- Possibility to send information about the connected current base station is added.

### 4.23.04 (26.05.21)

**New features:**

- New firmwares 26.06(st), 32.00(bt) for device Galileosky 7X are added.

#### Change log of firmware 32.00:

**New features:**

- Possibility to authorize on EGTS by terminal identifier is added.
- Possibility to configure timeout of waiting for registration on GSM network is added.
- Possibility to get a 64-bit key in EasyLogic is added.
- Possibility to use LBS as a coordinate source is added.
- Possibility to send information about the connected current base station is added.
- SD archive stability is improved.

#### Change log of firmware 26.06:

**New features:**

- Performance is improved.

**Corrections:**

- Operating with hand-held PTT switch is fixed.

### 4.23.06 (31.05.21)

**Corrections:**

- Display of EasyLogic status during remote configuration session is fixed.

### 4.23.05 (28.05.21)

**New features:**

- Possibility to use LBS as a coordinate source is added.
- Possibility to send information about the connected current base station is added.

### 4.23.04 (26.05.21)

**New features:**

- New firmwares 26.06(st), 32.00(bt) for device Galileosky 7X are added.

#### Change log of firmware 32.00:

**New features:**

- Possibility to authorize on EGTS by terminal identifier is added.
- Possibility to configure timeout of waiting for registration on GSM network is added.
- Possibility to get a 64-bit key in EasyLogic is added.
- Possibility to use LBS as a coordinate source is added.
- Possibility to send information about the connected current base station is added.
- SD archive stability is improved.

#### Change log of firmware 26.06:

**New features:**

- Performance is improved.

**Corrections:**

- Operating with hand-held PTT switch is fixed.

### 4.23.03 (07.05.21)

**New features:**

- Suggestion to save the modified or unsaved EasyLogic algorithm when you try to open another script is added.
- Suggestion to save the modified or unsaved EasyLogic algorithm before uploading the script to a device is added.
- Displaying of data in the device information window is improved.
- Shortcuts for saving and opening files are added.
- "Actions" in EasyLogic are divided into subgroups for more convenient work.
- Added a warning when entering an incorrect PIN code.
- Recording of the current date to the configurator logs is added.
- Searching for devices by part of the IMEI is added.
- New firmware 31.03(bt) for devices Galileosky 7.0, BaseBlock is added.

**Corrections:**

- Sending archive data to the remote server is improved.
- Creating a script template in EasyLogic if the script name is not entered is fixed.
- Errors of using variables in EasyLogic are fixed.
- Displaying of EasyLogic status on devices, that do not support it, is fixed.
- The window for entering the PIN code is improved.
- Displaying of the CAN-scanner tab on high DPI displays is fixed.

#### Change log of firmware 31.03:

- EasyLogic SIM-switching is fixed.

### 4.23.02 (30.04.21)

**New features:**

- New firmwares 23.17(st), 25.01(bt) for devices Galileosky 7.0, BaseBlock are added.
- New firmwares 26.05(st), 28.03(rc), 30.03(bt), 31.02(bt) for device Galileosky 7X are added.

#### Change log of firmware 23.17, 25.01:

**Corrections:**

- Problem with connection to Exigner is fixed.

#### Change log of firmware 26.05, 28.03, 30.03, 31.02:

**Corrections:**

- Operating of CAN filters is fixed.
- Problem with connection to Exigner is fixed.

### 4.23.01 (22.04.21)

**New features:**

- New firmwares 30.02(bt), 31.01(bt) for device Galileosky 7X are added.

#### Change log of firmware 30.02, 31.01:

**Corrections:**

- Receiving of CAN messages is fixed.

### 4.23.00 (21.04.21)

**New features:**

- SIM-cards switching is available in EasyLogic.
- "FLS and Modbus" RS485 mode is added.
- Added "Sound" tab to control auto answer for devices with GSM module.
- New firmware 232.2 for device Galileosky 5.0 is added.
- New firmwares 23.16(st), 25.00(bt) for devices Galileosky 7.0, BaseBlock are added.
- New firmwares 24.19(st), 26.04(st), 28.02(rc), 30.01(bt), 31.00(bt) for device Galileosky 7X are added.

**Corrections:**

- Download archive from SD-card is improved.
- "Filters" tab is improved.

#### Change log of firmware 232.2:

**Corrections:**

- Notification via SMS and call in case of alarm is fixed.
- Length limit of response to remote configuration commands is increased.

#### Change log of firmware 23.16:

**Corrections:**

- Operating of autoinformer with negative coordinates is fixed.
- GSM operating is improved.
- Connection hub to hub while uploading data via GPRS network is prohibited is fixed.
- Sending data from SD archive to secondary server is fixed.
- Sending TPMS data is fixed.

#### Change log of firmware 25.00:

**New features:**

- Diagnostic subsystem is improved.
- The ability to disable file system journaling on SD is added.
- Read-only mode for SD card is added.

**Corrections:**

- Operating of autoinformer with negative coordinates is fixed.
- GSM operating is improved.
- Connection hub to hub while uploading data via GPRS network is prohibited is fixed.
- Sending data from SD archive to secondary server is fixed.
- Sending TPMS data is fixed.

#### Change log of firmwares 24.19:

**Corrections:**

- Operating of autoinformer with negative coordinates is fixed.
- GSM operating is improved.
- Sending data from SD archive to secondary server is fixed.
- Sending TPMS data is fixed.

#### Change log of firmwares 26.04:

**Corrections:**

- Operating of autoinformer with negative coordinates is fixed.
- GSM operating is improved.
- Sending data from SD archive to secondary server is fixed.
- Operating with SD cards is improved.
- Sending TPMS data is fixed.

#### Change log of firmwares 28.02, 30.01:

**Corrections:**

- Operating of autoinformer with negative coordinates is fixed.
- GSM operating is improved.
- Sending data from SD archive to secondary server is fixed.
- Connection hub to hub while uploading data via GPRS network is prohibited is fixed.
- Operating with SD cards is improved.
- Sending TPMS data is fixed.

#### Change log of firmware 31.00:

**New features:**

- SIM-cards switching is available in EasyLogic.
- Diagnostic subsystem is improved.

**Corrections:**

- GSM operating is improved.
- Serial interfaces operating is improved.
- Operating of autoinformer with negative coordinates is fixed.
- Sending data from SD archive to secondary server is fixed.
- Connection hub to hub while uploading data via GPRS network is prohibited is fixed.
- Operating with SD cards is improved.
- Sending TPMS data is fixed.

### 4.22.01 (26.03.21)

**Corrections:**

- Duplicating (copy-paste) of the action "CAN message parsing" is fixed.
- Fixed incorrect labels in the Easy Logic section.
- Operating with tags in the "Bluetooth" tab is improved.

### 4.22.00 (19.03.21)

**New features:**

- Forced coordinates invalidation is available in EasyLogic.
- Bluetooth messages receiving is available in EasyLogic.
- Increased the number of Bluetooth tags to 64.
- New firmwares 24.18, 26.03 (release candidatee), 28.01 (beta version), 30.00 (beta version) for device Galileosky 7X are added.
- New firmware 23.15 for devices Galileosky 7.0, BaseBlock is added.

**Corrections:**

- Diagram field scaling during script editor scrolling is fixed.
- Display of the "Configurator update" button is fixed.
- Display of the ability to select an external GNSS source is fixed.
- Download archive into file is fixed.
- Sending archive data to remote server is fixed.
- Saving the Galileosky 7.0 Lite configuration is corrected.

#### Change log of firmware 30.00:

**New features:**

- Forced coordinates invalidation is available in EasyLogic.
- Bluetooth messages receiving is available in EasyLogic.

**Corrections:**

- Upload archive into file is fixed.
- Operating of linear geofences is fixed.

#### Change log of firmwares 28.01, 26.03, 24.18, 23.15:

**Corrections:**

- GNSS buffer overflow issue is fixed.
- Sending PDOP data via EGTS protocol is fixed.
- Upload archive into file is fixed.
- Operating of linear geofences is fixed.

### 4.21.00 (26.02.21)

**New features:**

- Possibility to assign a CAN port to basic CAN tags is added.
- Auto-completion of entered commands in the "Commands" tab is added.
- Color indication for different types of firmware is added.
- New firmware 28.00 (beta version) for device Galileosky 7x is added.

**Corrections:**

- Displaying of sim card status for OBD-II is fixed.
- Displaying of signaling settings for GalileoSky 7x C ext is fixed.

#### Change log of firmware 28.00:

**New features:**

- WiFi support is added.
- Possibility to assign a CAN port to basic CAN tags is added.
- Possibility to choose a satellite navigation system is added.

**Corrections:**

- Archive operating is corrected.
- CAN processing is improved.
- Signaling operating is improved.

### 4.20.18 (18.02.21)

**New features:**

- 8-byte iButton keys support is added.
- New firmware 24.17 for device Galileosky 7x is added.
- New firmware 26.02 (beta version) for device Galileosky 7x is added.

**Corrections:**

- Incorrect display of the script (filter) name in Cyrillic is fixed.
- Description of EasyLogic variables for latitude and longitude is fixed.
- Window arranging in "On top window" mode is fixed.

#### Change log of firmware 24.17:

**New features:**

- Support for devices Galileosky V7X.0.8 is added.

**Corrections:**

- GSM operating is improved.
- Serial ports operating is improved.

#### Change log of firmware 26.02:

**New features:**

- Support for devices Galileosky V7X.0.8 is added.

**Corrections:**

- GSM operating is improved.
- Serial ports operating is improved.

### 4.20.17 (10.02.21)

**New features:**

- New firmware 24.16 for device Galileosky 7x is added.
- New firmware 26.01 (beta version) for device Galileosky 7x is added.

#### Change log of firmware 24.16:

- GSM signal quality detection is fixed.

#### Change log of firmware 26.01:

- GSM signal quality detection is fixed.

### 4.20.16 (10.02.21)

**Corrections:**

- Loading a route containing bus stops with negative coordinates is fixed.

### 4.20.15 (09.02.21)

**New features:**

- New firmware 23.14 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.15 for device Galileosky 7x is added.
- New firmware 26.00 for device Galileosky 7x is added (beta version).

**Corrections:**

- Behaviour of the elements in Protocol tab is fixed.
- Displaying of the autoinformer settings without voice call settings in Sound tab is fixed.
- Displaying of the settings for BaseBlock is fixed.

#### Change log of firmware 23.14:

**Corrections:**

- Algorithm of searching unsent points in static archive by chronological order is improved.
- Accelerometer processing is fixed.
- Uploading Collector's archive data via GPRS is fixed.
- Operating with archive is corrected.

#### Change log of firmware 24.15:

**Corrections:**

- Registration in the network for LTE trackers is fixed.

#### Change log of firmware 26.00:

**New features:**

- iButton keys support on the internal flash memory is added.
- 8-byte iButton keys support is added.

### 4.20.14 (02.02.21)

**New features:**

- New version of CardApp is added.
- New firmware 23.13 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.14 for device Galileosky 7x is added.

#### Change log of firmware 23.13:

**Corrections:**

- Uploading data from SD card for a specified period by command is fixed.

#### Change log of firmware 24.14:

**Corrections:**

- Device rebooting is fixed.
- Voice call for devices with Ublox modems is fixed.
- Operating with deep charged batteries is fixed.
- Uploading data from SD card for a specified period by command is fixed.
- CAN-bus scanning is fixed.

### 4.20.13 (27.01.21)

**New features:**

- Data source selection to determine the driving style parameters is added.
- The ability to upload archive from SD card is added.
- Tag groupment in protocol tab is added.
- 'On the fly' math in CAN Scanner tab is added.
- New firmware 23.12 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.13 for device Galileosky 7x is added.

**Corrections:**

- Data entry in "Digital fuel sensors filter length" is fixed.
- CANLOG prefixes configuration is corrected (digital prefixes is forbidden).
- Dialogue box opening for setting saving is fixed.
- Corrected work with Bluetooth sensors Technoton.

#### Change log of firmware 23.12:

**New features:**

- Uploading archive from SD-card is added.

**Corrections:**

- PressurePro tag usage is fixed.
- Exact determination of hub connection is fixed.
- Concurrent read and write operations of Collector are fixed.
- Stopping of the EasyLogic algorithm after the "Enable navigation unit" block is fixed.
- Downloading scripts via WiFi is fixed.
- Speed of uploading dynamic archive to the hub is improved.

#### Change log of firmware 24.13:

**New features:**

- Automatic CAN baudrate definition is added.
- Coordinate-based driver behavior detection algorithm is added.
- Uploading archive from SD-card is added.
- On-the-fly math for CAN tags is added.
- Setting to enable time synchronization via GSM is added.

**Corrections:**

- PressurePro tag usage is fixed.
- "Enable navigation unit" process stucking is fixed.
- Sending data via TCP socket in EasyLogic is fixed.
- Configuring DNS servers for terminals with 3G support is fixed.
- Corrected work with Bluetooth sensors Technoton.
- Operating with WebDAV for 3G and LTE trackers is fixed.

**Annotations:**

- Attention! In case of downgrade you will lose device configuration!

### 4.20.12 (04.12.20)

**New features:**

- Increased the number of BLUETOOTH tags to 30.
- Added support for Technoton bluetooth sensors.
- Support of FLS Eurosens Dominator BT from Mechatronics is added.
- New firmware 23.11 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.12 for device Galileosky 7x is added.

#### Change log of firmware 23.11:

**Corrections:**

- Operating with non 512-byte sized sectors SD cards is fixed.

#### Change log of firmware 24.12:

**New features:**

- Tags MODBUS and BLUETOOTH value is available in EasyLogic.
- Increased the number of BLUETOOTH tags to 30.
- Added support for Technoton bluetooth sensors.
- Support of FLS Eurosens Dominator BT from Mechatronics is added.

**Corrections:**

- Configuration saving is fixed.

### 4.20.11 (22.11.20)

**New features:**

- New firmware 24.11 for device Galileosky 7x is added.

#### Change log of firmware 24.11:

**Corrections:**

- Condition for switching to sleep mode is corrected.
- The bug causing configuration reset is fixed.

### 4.20.10 (18.11.20)

**New features:**

- New firmware 23.10 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.10 for device Galileosky 7x is added.

#### Change log of firmware 23.10:

**Corrections:**

- Sending archive from internal memory is fixed.

#### Change log of firmware 24.10:

**Corrections:**

- Sending archive from internal memory is fixed.
- Operation of RS485 interface is fixed.

### 4.20.9 (29.10.20)

**New features:**

- New firmware 23.9 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.9 for device Galileosky 7x is added.

#### Change log of firmware 23.9:

**Corrections:**

- Automatic switching to the internal coordinate source is fixed.

#### Change log of firmware 24.9:

**Corrections:**

- Automatic switching to the internal coordinate source is fixed.

### 4.20.8 (28.10.20)

**Corrections:**

- "Set geodata" EasyLogic block saving is fixed.
- Column displaying in protocol tab for 22.10 firmware is fixed.
- Program crash during saving settings is fixed.

### 4.20.7 (26.10.20)

**New features:**

- CAN# column on the CAN Scanner tab is not displayed when using devices with one CAN bus.
- Combination of IMEI and current date is suggested as the file name when saving the diagnostic log.
- Display of the number of unsent points in the "Device" tab is added.
- New firmware 23.8 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.8 for device Galileosky 7x is added.

**Corrections:**

- Minimizing of the mini calculator in the "CAN Scanner" tab is added.
- Program crash during last iButton row deleting is fixed.
- iButton configuration is corrected (zero key adding is forbidden).

#### Change log of firmware 23.8:

**New features:**

- Calculation of the total number of records in the archive and the number of sent records is added.
- Auto-cleaning of the collector folder is added.
- Rebooting the device if Wi-Fi module has critical errors is added.
- Algorithm of switching between Wi-Fi and GPRS is improved.
- The ability to mount/unmount SD card is added.
- Userspace data restoration from the last archive record is added.
- Logging to internal memory is added.
- Execution commands for request configuration is available in EasyLogic.
- Support SD card without Master Boot Record section is added.
- Switching to the internal GPS data source if the external one doesn`t respond is added.

**Corrections:**

- Command CLEANPHOTOQUEUE is fixed
- Stability of the dynamic archive on the internal flash memory is improved.
- Setting up external power supply input at device startup is fixed.
- The detecting issue in case of lack of WiFi network for long time is fixed.

#### Change log of firmware 24.8:

**New features:**

- Automatic switching to the internal coordinate source in the absence of data from an external one is added.
- The ability to configure bands for the terminal with LTE is added.
- The firmware update process runs until the download is complete or stopped forcely.
- The ability to mount/unmount SD card is added.
- Calculation of the total number of records in the archive and the number of sent records is added.
- Userspace data restoration from the last archive record is added.
- Logging to internal memory is added.
- The ability to configure the network priority for devices with LTE is added.
- Execution commands for request configuration is available in EasyLogic.
- SSL connections support is added for devices with 3G and LTE.

**Corrections:**

- Alarm work is fixed.
- Stability of work with LTE networks is improved.
- Command CLEANPHOTOQUEUE is fixed.
- Sending response via remote config is fixed.
- Stability of the archive on the internal flash memory is improved.
- Setting up external power supply input at device startup is fixed.

### 4.20.6 (14.09.20)

**Corrections:**

- Incorrect displaying of checkboxes on the protocol tab is fixed.
- Self-updating is fixed.

### 4.20.5 (01.09.20)

**Corrections:**

- Configuration of extended tags is fixed.

### 4.20.4 (24.08.20)

**New features:**

- Modbus support for device Galileosky 7x is added.
- Coordinate and GNSS module settings from EasyLogic scripts is added.
- Bluetooth support for device Galileosky 7x is added.
- "Status" group title in the "Device" tab is added.
- New firmware 23.7 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.7 for device Galileosky 7x is added.

**Corrections:**

#### Change log of firmware 23.7:

**New features:**

- Ability to process geofence properties in EasyLogic is added
- Local variable PHONE_NUMBER_NUMERIC (Last 9 digits of phone number in numeric format, from which the call is made or SMS is sent) is available in EasyLogic.
- TCP socket support is added to scripts EasyLogic
- Extended device status 5th bit is asserted in case if USB connector is plugged
- Extended device status 6th bit is asserted in case if SD card is inserted
- Following periphery is now supported via Easy Logic algorithms: CUB5 indicator, weight indicators AWT640 and WinScale, PressurePro system, 125 kHz RFID readers and Matrix V, Garmin navigator and REP500 electrical meter.
- Set location in EasyLogic is available.

**Corrections:**

- CAN returns to work mode in case if USB cable is unplugged or device rebooted.
- Stability of connection to GSM network is increased.
- Error of handling iButton zero key is fixed.

#### Change log of firmware 24.7:

**New features:**

- Ability to process geofence properties in EasyLogic is added.
- Reading extra parameters from DataCold 600 is added.
- Local variable PHONE_NUMBER_NUMERIC (Last 9 digits of phone number in numeric format, from which the call is made or SMS is sent) is available in EasyLogic.
- 5th bit of device extended status stands for USB cable connection.
- 6th bit of device extended status stands for SD Card presence.
- Following periphery is now supported via Easy Logic algorithms: CUB5 indicator, weight indicators AWT640 and WinScale, PressurePro system, 125 kHz RFID readers and Matrix V, Garmin navigator and REP500 electrical meter.
- Working with devices using the Modbus RTU protocol is added.
- Extended tags are added to the Galileosky protocol.
- Bluetooth sensors support is added.
- Set location in EasyLogic is available.

**Corrections:**

- GSM modem initialization timeout is increased
- Support for the '00000000' iButton key is fixed
- Stability of connection to GSM network is increased.

### 4.20.3 (05.07.20)

**New features:**

- New firmware 23.5 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.5 for device Galileosky 7x is added.

#### Change log of firmware 23.5:

**Corrections:**

- Coordinate variables and GNSS module control is fixed in Easy Logic.

#### Change log of firmware 24.5:

**Corrections:**

- Coordinate variables and GNSS module control is fixed in Easy Logic.

### 4.20.2 (30.06.20)

**New features:**

- Ability to process geofence properties in EasyLogic is added.
- Local variable PHONE_NUMBER_NUMERIC (Last 9 digits of phone number in numeric format, from which the call is made or SMS is sent) is available in EasyLogic
- New firmware 24.4 for device Galileosky 7x is added.

**Corrections:**

- Incorrect big-endian reformatting in the EasyLogic "CAN Message Parsing" block is fixed.

#### Change log of firmware 24.4:

**New features:**

- Non-standart device configuration is supported.

**Corrections:**

- Issue with configuring of external coordinates source is fixed.
- New coordinates source is applied immediately now.

### 4.20.1 (19.06.20)

**New features:**

- Support for external sources of coordinates is added.
- New firmware 23.4 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.3 for device Galileosky 7x is added.

#### Change log of firmware 23.4:

**New features:**

- Support for external sources of coordinates is added
- Ability to choose the level of diagnostic messages is added
- Support for transfer archive between two hubs is added
- Global variable WIFI_RSSI (received signal strength indication) is available in EasyLogic
- Global variable WIFI_CLIENT_CONNECTED (the status shows if client is connected) is available in EasyLogic
- Reading extra parameters from DataCold 600 is added.

**Corrections:**

- Server reconnection period is fixed.
- Switching between GPRS and Wi-Fi is improved.
- Points recording during a stop is fixed.
- SD Card work stability is improved.

#### Change log of firmware 24.3:

**New features:**

- Settings serialization is added for transmitting across a network purposes
- TCP socket support is added to scripts EasyLogic
- Support for external sources of coordinates is added
- Ability to choose the level of diagnostic messages is added

### 4.20.0 (15.05.20)

**New features:**

- Socket support is added into EasyLogic scripts (routines SocketOpen, SocketSend, SocketRecv, SocketClose)
- New firmware 24.2 for device Galileosky 7x is added.

**Corrections:**

- Program crash during Easy Logic script compilation is fixed.

#### Change log of firmware 24.2:

**New features:**

- Command for zipping files is added (ZIP <filename>,<zipname>,<compressionLevel>)
- Routine for adding files to ZIP archive in EasyLogic is added
- Support devices Galileosky V7X.1.1 is added
- NB IoT network support is added for terminals Galileosky V7X.1.0

**Corrections:**

- Prohibited mobile operator codes algorithm is improved.
- Synchronisation of modified files from SDcard is fixed.
- Server reconnection period is fixed.

### 4.19.19 (23.04.20)

**New features:**

- New firmwares 24.1 for device Galileosky 7x is added.

#### Change log of firmware 24.1:

**Corrections:**

- Charging deeply discharged battery is fixed.

### 4.19.18 (10.04.20)

**New features:**

- "WiFi MAC" field is added to the Device tab (displaying the WiFi MAC address, if available).
- Routine to add file to ZIP archive is added (ZipFile).
- New firmwares 21.21, 23.1 for device Galileosky 7, Galileosky Base Block and Galileosky OBD-II are added.

#### Change log of firmware 21.21:

**Corrections:**

- Work with protocol J1979 was optimized.
- CAN-bus data cleaning in the J1979 protocol is fixed.
- Prohibited mobile operator codes algorithm is improved.

#### Change log of firmware 23.1:

**New features:**

- Added WIFIMAC command returning WiFi MAC address.

**Corrections:**

- Timer for protocol J1979 was fixed.
- Synchronisation of modified files from SDcard is fixed.

### 4.19.17 (26.03.20)

**Corrections:**

-Incorrect display of parameters in main packet is fixed.

### 4.19.16 (23.03.20)

**New features:**

- Possibility to change period of sending to the hub is added in to Settings.
- Routine to read directory entries in sequence is added (NextFile).
- Possibility to set an 8-digit PIN for USB access is added.
- New version of CardApp is added.
- New firmware 23.0 for device Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 24.0 for device Galileosky 7x.

#### Change log of firmware 23.0:

**New features:**

1) Possibility to change period of sending to the hub is added.
2) Possibility to set an 8-digit PIN for USB access is addeed.
3) For DataCold600 reading the "Refrigerator is OFF" status is added to Error codes in the 9th bit.
4) Archive storage on SD card is improved.

**Corrections:**

1) Work with protocol J1979 was optimized.
2) Prohibited mobile operator codes algorithm is improved.
3) IMEI is shown even if no SIM card or SIM chip is used.
4) CAN-bus data cleaning in the J1979 protocol is fixed.
5) Working with CAN from Easy Logic is fixed.

#### Change log of firmware 24.0:

**New features:**

1)Routine to read directory entries in sequence is added (nextFile)
2)Global variables of status, counter value, processing allowance for inputs 9-13 are added to Easy Logic
3)Possibility to set an 8-digit PIN for USB access is added.
4)Voice support for u-blox is added.
5)For DataCold600 reading the "Refrigerator is OFF" status is added to Error codes in the 9th bit.
6)Extended support J1979 protocol for CAN scanner.

**Corrections:**

1) File system errors were fixed
2) CAN-bus data cleaning in the J1979 protocol is fixed.
3) EFS command is fixed.
4) Bug with the processing of short CAN messages is fixed.
5) Working with CAN from Easy Logic is fixed.
6) Bug with pulse and frequency measurements is fixed.

### 4.19.15 (06.03.20)

**New features:**

- New firmware 22.10 for device Galileosky 7x.

#### Change log of firmware 22.10:

**Corrections:**

1) Firmware update via the Internet is fixed.

### 4.19.14 (03.03.20)

**Corrections:**

- Obtain of RSSI parameter value for WiFi group from device is fixed

### 4.19.13 (27.02.20)

**New features:**

- CardApp application is added
- Sending of CAN messages with zero ID is allowed.
- New firmware 21.19 for devices Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.

#### Change log of firmware 21.19:

**New features:**

1) For DataCold600 reading the "Refrigerator is OFF" status is added to Error codes in the 9th bit.

**Corrections:**

1) Incorrect processing of device status is fixed.

### 4.19.12 (25.02.20)

**New features:**

- Global variables of status, counter value, processing allowance for inputs 9-13 are added to Easy Logic.

**Corrections:**

- Visibilty of the "General Settings" group title in the "Signaling settings" tab for all BaseBlock devices is fixed.
- Incorrect Easy Logic algorithms opening is fixed.
- Tooltip for Galileosky 7x specification is fixed.

### 4.19.11 (11.02.20)

**New features:**

- Additional CANBUS data display is added for Galileosky 7.0, BaseBlock and 7x devices.
- Two CAN interfaces are supported in Easy Logic.
- Possibility to add comments to each identifier is added into CAN Scanner.
- Translation to Russian and Espaniol is added in 'Add filter' and 'Add message' dialog boxes.
- New firmware 21.18 for device Galileosky 7, Galileosky Base Block and Galileosky OBD-II is added.
- New firmware 22.9 for device Galileosky 7x.

**Corrections:**

- Visibility of CAN number drop-down list is fixed in 'Add filter' and 'Add message' dialog boxes.
- Duplicate of the "General settings" field in the "Alarm" tab has been deleted.

#### Change log of firmware 22.9:

**New features:**

1) Control of the amount of attempts to configure the wifi module is added
2) License module for exigner is added.

**Corrections:**

1) Incorrect work with some 1-wire devices is fixed
2) Playing of sound files is improved
3) Path for photos is corrected to format YYMMDD
4) Exceeding of HDOP threshold is fixed
5) Accuracy of saving point to SD card by period was increased

#### Change log of firmware 21.18:

**New features:**

1) Control of the amount of attempts to configure the wifi module is added

**Corrections:**

1) Incorrect wifi module configuration from EasyLogic scripts is fixed
2) Path for photos is corrected to format YYMMDD
3) Points recording during the vehicle`s stops was corrected.
4) SIM switch algorithm is improved.


### 4.19.10 (27.12.19)

**New features:**

- New firmware 22.7 for device Galileosky 7x.
- 232.1 firmware for Galileosky GLONASS/GPS is added.

#### Change log of firmware 22.7:

**New features:**

1) New parameter "Port" for CAN tags is added.
2) Terminal start indication was added (double blinking in white).
3) The number of supported polygonal geofences is increased to 3500.

**Corrections:**

1) The frequency of data transmission to the filters is limited to 200 Hz.
2) Downloading of archive through the configurator is fixed.
3) Improvements of the dynamic archive operation.
4) Accuracy of saving point period was increased.

#### Change log of firmware 232.1:

**Corrections:**

1) Error in zeroing of iButtons is fixed.

### 4.19.9 (21.12.19)

**New features:**

- Support for new devices is improved.

### 4.19.8 (20.12.19)

**Corrections:**

- Remote configuration is improved.

### 4.19.7 (13.12.19)

**New features:**

- New firmware 21.16 for device Galileosky 7 and Galileosky Base Block is added.

#### Change log of firmware 21.16:

**Corrections:**

1) Algorithm of SIM-card switching by operator code is improved.
2) Accuracy of saving point period is increased.


### 4.19.6 (06.12.19)

**New features:**

- New firmware 21.15 for device Galileosky 7 and Galileosky Base Block is added.
- 230.1 firmware for Galileosky GLONASS/GPS is added.

**Corrections:**

- Carrier DataCOLD600 is added onto list of periphery devices for devices Galileo 5.0.
- Application crash while creating custom filter in CAN Scanner is fixed.
- Downloading of archive through the configurator is fixed.

#### Change log of firmware 21.15:

**New features:**

1) Support for exigner.com is added.
2) Extended support for J1979 protocol.

**Corrections:**

1) The frequency of data transmission to the filters is limited to 200 Hz.
2) The number of supported polygonal geofences is increased to 3500.
3) Data transmission from DataCold 600 in "Idle" mode is fixed.
4) Downloading of archive through the configurator is fixed.
5) WAV files playing is fixed

#### Change log of firmware 230.1:

**Corrections:**

1) Error in zeroing of iButtons is fixed.


### 4.19.5 (28.11.19)

**New features:**

- Sorting of incoming messages by number of CAN module in CAN Scanner tab is added.
- Initial value parameter is added in function of CRC16 calculation in Easy Logic.

**Corrections:**

- Autoinformer outs count in Base Block is fixed.
- Agreement process of sending CAN messages is fixed for terminals with 2 CAN ports.
- Allignment of "Endian type" list for received messages is fixed.
- Auto stop CAN Scanner is fixed
- Restoring actual value of input's parameter is fixed

#### Change log of 21.14 firmware:

**New features:**

1) Set up the permanent code to confirm SD card formatting is available by command FORMATSDKEY.

**Corrections:**

1) Changing output state while playing autoinformer message is fixed.
2) Setting the last input of coordinates filtering by ignition is fixed.
3) Setting the secondary server for EGTS protocol is fixed.
4) Upper limit of outputs range for the autoinformer feature is fixed
5) Data retranslation in access point mode is restored.


### 4.19.4 (31.10.19)

**New features:**

- Multiple selection is added to remote device management window.
- 199 firmwares are changed to 201 for better update control purposes.
- Support of protocol EGTS GOST 33472-2015 is added.
- Support of transmitting data via Bluetooth is added.
- New firmware 21.12 for device Galileosky 7 and Galileosky Base Block is added.
- New firmware 22.6 for device Galileosky 7x is added.
- List of CAN modes is simplified
- Exit confirmation window is added.

**Corrections:**

- Clean scripts command is fixed
- Type of control for inputs Wiegand is fixed

#### Change log of 21.12 firmware:

**New features:**

1) The WiFi connection for live data uploading is added.
2) Output of the commit version through the "status" command is added.

**Corrections:**

1) Work with mobile network operator GoodLine is fixed.

#### Change log of 22.6 firmware:

**New features:**

1) Indication of Bluetooth module operation state is added
2) Noise filtering of inputs less than 40 mV is added
3) Bluetooth test is added
4) PullUp test for inputs is added

**Corrections:**

1) Upper limit of autoinformer outputs range is fixed
2) Wrong receiving of the messages we have sent is fixed
3) Starting an interrupted update process at startup
4) Mutual dependence of RS232 ports is fixed
5) UART reception was fixed
6) Bluetooth firmware is updated
7) Offset calculation to restore update process is modified
8) changing output state while playing autoinformer message is fixed
9) setting last input of filtrating coordinates by ignition is fixed

### 4.19.3 (23.08.19)

**New features:**

- 21.10 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 21.10 firmware:

**New features:**

1) Strike duration for register crashing fact is added. Fifth parameter in conventional units for command SHOCK is added.
2) Setting the threshold response value of the analog inputs by Wiegand26 to 2350 mV is added.

**Corrections:**

1) Rare point recording on SD card is fixed.

### 4.19.2 (21.08.19)

**New features:**

- Firmware update window is adapted for displays with low resolution

### 4.19.1 (17.08.19)

**New features:**

- 232.0, 230.0 firmwares for Galileosky GLONASS/GPS are added.

#### Change log of 232.0, 230.0 firmware:

**Corrections:**

1) Wrong date determination on terminasl with MGGS2217 navigation unit is fixed.

### 4.19.0 (14.08.19)

**New features:**

- Firmware 21.9 is added for the devices Galileosky 7 and Galileosky Base Block.
- Adder units and units of calculating of the difference with the last recivied value are added to the filters.
- Configurations of LED brightness are added for the devices Galileosky 7.
- Recording and reproduction of the log messages, recieved from CAN-bus, are added.

#### Change log of 21.9 firmware:

**New features:**

1) Command FIXTERM for binding 1-Wire thermometers to fields in data sending protocol is added.

**Corrections:**

1) EnH calculation error in DataCold600 was corrected.

### 4.18.17 (17.07.19)

**New features:**

- 231.41, 229.29, 199 firmwares for Galileosky GLONASS/GPS are added.

#### Change log of 231.41, 229.29, 199 firmware:

**Corrections:**

1) Wrong date determination on terminasl with MGGS2217 navigation unit is fixed.

### 4.18.16 (05.07.19)

**New features:**

- 231.40 firmware for Galileosky GLONASS/GPS is added.
- 21.7 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.40 firmware:

**Corrections:**

1) Error of the response sending to the commands from EasyLogic is fixed.

#### Change log of 21.7 firmware:

**New features:**

1) Domain name is added to log messages.

### 4.18.15 (14.06.19)

**Corrections:**

- 21.3 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 21.3 firmware:

**New features:**

1) Improved dynamic archive is implemented.

### 4.18.14 (06.06.19)

**Corrections:**

- 20.10 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.10 firmware:

**Corrections:**

1) Calculation of values is completed according to calibration tables in filters.
2) Incoming call rejection is correctly processed.

### 4.18.13 (23.05.19)
**Corrections:**

- Correct firmware 20.9 is added.

#### Change log of 20.10 firmware:

**Corrections:**

1) Calculation of values is completed according to calibration tables in filters.
2) Incoming call rejection is correctly processed.

### 4.18.12 (22.05.19)

**New features:**

- 20.9 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.9 firmware:

**Corrections:**

1) Stability of work with SD card is improved.
2) Buffer for WAV file reader is enlarged.

### 4.18.11 (18.04.19)

**New features:**

- 20.8 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.8 firmware:

**Corrections:**

1) Error in "Moving average" filter is fixed.
2) Battery charging algorithm is improved.

### 4.18.10 (10.04.19)

**New features:**

- 21.0 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 21.0 firmware:

**New features:**

1) Control of the minimum WiFi RSSI level for switching from GSM is added.
2) 1200 and 2400 baudrates are added for RS232 and RS485 to EasyLogic.
3) Simultaneous connection of two Wiegnad26 devices is added.

**Corrections:**

1) Wrong singaling state restoration after reset is fixed.

### 4.18.9 (09.04.19)

**New features:**

- 231.34 and 229.24 firmwares for Galileosky GLONASS/GPS are added.

#### Change log of 231.34 and 229.24 firmware:

**Corrections:**

1) Cold start procedure for MGGS2217 is improved.

### 4.18.8 (08.04.19)

**New features:**

- 231.33 and 229.23 firmwares for Galileosky GLONASS/GPS are added.

#### Change log of 231.33 and 229.23 firmware:

**Corrections:**

1) Error during attach to remote configuration server is fixed.
2) Error caused by GPS week rollup is fixed.

### 4.18.7 (14.03.19)

**New features:**

- 20.7 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.7 firmware:

**Corrections:**

1) Error during attach to remote configuration server is fixed.

### 4.18.6 (13.02.19)

**New features:**

- 20.6 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.6 firmware:

**Corrections:**

1) Geofences matching error is fixed.

### 4.18.5 (12.02.19)

**New features:**

- 231.30 firmware for Galileosky GLONASS/GPS is added.

#### Change log of 231.30 firmware:

**Сorrections:**

1) Error in Easy Logic commands handling is fixed.

### 4.18.4 (11.01.19)

**New features:**

- 231.29 firmware for Galileosky GLONASS/GPS is added.
- 20.5 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.29 firmware:

**Сorrections:**

1) Error during Easy Logic algorithms uploading using USB is fixed.

#### Change log of 20.5 firmware:

**New features:**

1) Geofences support is added.
2) CANBUS related functions are added to Easy Logic scritping language.

**Corrections:**

1) Error during writing on SD card is fixed.

### 4.18.3 (24.12.18)

**Corrections:**

- Error during number pasting in Easy Logic editor is fixed.
- Font color in terminals list is modified.

### 4.18.2 (12.12.18)

**New features:**

- Filtration by update frequency is added to CAN scanner.
- 20.4 firmware for Galileosky Base Block is added.
- 19.10 firmware for Galileosky Base Block is added.

#### Change log of 20.4 firmware:

**New features:**

1) Error during sending collected using Wi-Fi data is fixed.
2) CAN scanner error is fixed.

#### Change log of 19.10 firmware:

**Corrections:**

1) Error during sending collected using Wi-Fi data is fixed.

### 4.18.1 (04.12.18)

**New features:**

- 20.3 firmware for Galileosky 7 and Galileosky Base Block is added.
- 19.9 firmware for Galileosky 7 and Galileosky Base Block is added.
- Ability to remove received messages is added to CAN scanner.
- Ability to select arbitrary bits in received messages is added to CAN scanner.
- CAN scanner performance is increased.
- Columns "Messages count" and "Period" are added to CAN scanner.

#### Change log of 19.9 firmware:

**Corrections:**

1) Error during filters startup process is fixed.
2) Error in formation of Galileosky protocol packets with compression is fixed.

#### Change log of 20.3 firmware:

**New features:**

1) Ability to disable GSM location is added.

### 4.18.0 (28.11.18)

**New features:**

- Easy Logic is open for all customers.

### 4.17.4 (26.11.18)

**New features:**

- 231.28 firmware for Galileosky GLONASS/GPS is added.

**Corrections:**

- Error in data downloading from SD-card is fixed.

#### Change log of 231.28 firmware:
Сorrections:
1) Error in CAN messages handling is fixed.

### 4.17.3 (23.11.18)

**New features:**

- Ability to set a password for group of devices in remote configuration service is added.

### 4.17.2 (22.11.18)

**New features:**

- 19.8 firmware for Galileosky 7 and Galileosky Base Block is added.
- 20.2 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 19.8 firmware:

**Corrections:**

1) Error in extended device status is fixed.
2) SIM-cards switching error is fixed.


#### Change log of 20.2 firmware:

**New features:**

1) Settings saving error is fixed.
2) SIM-cards switching error is fixed.

### 4.17.1 (14.11.18)

**New features:**

- 19.7 firmware for Galileosky 7 and Galileosky Base Block is added.
- 20.1 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 19.7 firmware:

**New features:**

1) Protocol Galileosky with compression is added.

**Corrections:**

1) Error in diagnostics output in Easy Logic is fixed.
2) The error in positioning process according to mobile base stations is fixed.
3) Wrong delay timeout in Easy Logic is fixed.
4) The error in reconnection to server is fixed.

#### Change log of 20.1 firmware:

**New features:**

1) Errors in CAN scaner are fixed.

### 4.17.0 (25.10.18)

**New features:**

- CAN scaner.
- 20.0 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 20.0 firmware:

**New features:**

1) CAN scaner.

### 4.16.22 (03.10.18)

**New features:**

- 19.5 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 19.5 firmware:

**Corrections:**

1) Error in algorithm uploading is fixed.

### 4.16.21 (24.09.18)

**New features:**

- 19.4 firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 19.4 firmware:

**New features:**

1) GSM jamming detection is added.

### 4.16.20 (28.08.18)

**New features:**

- 231.27 and 229.22 stable firmwares for Galileosky GLONASS/GPS are added.
- 19.3 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.27 and 229.22 firmware:

**Сorrections:**

1) Error in CAN-LOG data parsing is fixed.

#### Change log of 19.3 firmware:

**Corrections:**

1) Error in CAN-LOG data parsing is fixed.
2) Error in data transmission is fixed.

### 4.16.19 (09.08.18)

**New features:**

- 231.26 stable firmware for Galileosky GLONASS/GPS is added.
- 19.2 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.26 firmware:

**Сorrections:**

1) Error in SMS handling is fixed.

#### Change log of 19.2 firmware:

**Corrections:**

1) Data transmission error is fixed.

### 4.16.18 (07.08.18)

**New features:**

- Push-to-talk button status variable is added to EasyLogic. 19.1 firmware is needed.
- 19.1 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 19.1 firmware:

**New features:**

1) GSM location is added (LBS) for Galileosky 7.
2) SIM cards switching time is decreased.

**Corrections:**

1) Filters performance is improved.

### 4.16.17 (16.07.18)

**New features:**

- 18.9 stable firmware for Galileosky 7 and Galileosky Base Block is added.
- 231.25 stable firmware for Galileosky GLONASS/GPS is added.

#### Change log of 231.25 firmware:

**Сorrections:**

1) Error in GNSS data parsing is fixed.
2) SIM cards switching error is fixed.

#### Change log of 18.9 firmware:

**Corrections:**

1) Error in saving parameters of FRIDGE commsnd is fixed.
2) Error in archive uploading is fixed.

### 4.16.16 (26.06.18)

**New features:**

- 18.8 stable firmware for Galileosky 7 and Galileosky Base Block is added.
- 231.23 stable firmware for Galileosky GLONASS/GPS is added.

#### Change log of 18.8 firmware:

**Corrections:**

1) Error in sychronization with WebDAV is fixed.
2) Error in Easy Logic commands parser is fixed.
3) SIM cards switching error is fixed.

#### Change log of 231.23 firmware:

**Сorrections:**

1) Error in GNSS data parsing is fixed.

### 4.16.13 (14.06.18)

**New features:**

- 18.7 stable firmware for Galileosky Base Block is added.

#### Change log of 18.7 firmware:

**Corrections:**

1) Data send error is fixed.

### 4.16.12 (13.06.18)

**New features:**

- 18.6 stable firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 18.6 firmware:

**New features:**

1) Ability to set up prohibited GSM networks is added.

**Corrections:**

1) Error during synchronization with WebDAV server is fixed.

### 4.16.11 (16.03.18)

**New features:**

- 231.22 stable firmware for Galileosky GLONASS/GPS is added.
- 18.4 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 18.4 firmware:

**New features:**

1) Collected archive data retransmission through GSM is added.
2) Better WebDAV support.

**Сorrections:**

1) Incoming SMS parsing error is fixed.
2) Encryption in Galileosky protocol is fixed.

#### Change log of 231.22 firmware:

**Сorrections:**

1) Error during SMS parsing is fixed.

### 4.16.10 (20.02.18)

**New features:**

- 18.3 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 18.3 firmware:

**Сorrections:**

1) Error of setting impulses to zero in the Easy Logic tab is fixed.

### 4.16.9 (07.02.18)

**New features:**

- 18.2 beta firmware for Galileosky 7 and Galileosky Base Block is added.

**Corrections:**

- Algorithm uploading error is fixed.

#### Change log of 18.2 firmware:

**Сorrections:**

1) Ability to switch Wi-Fi unit working mode using Easy Logic is added.

### 4.16.8 (02.02.18)

**New features:**

- 18.1 beta firmware for Galileosky 7 is added.

#### Change log of 18.1 firmware:

**Сorrections:**

1) FLS data transmission error is fixed.

### 4.16.7 (07.12.17)

**New features:**

- 231.21 stable firmware for Galileosky GLONASS/GPS is added.
- 17.5 beta firmware for Galileosky 7 and Galileosky Base Block is added.
- 18.0 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.21 firmware:
**Corrections:**

1) Autoinformer files parsing error is fixed.

#### Change log of 17.5 firmware:
**New features:**

1) GSMINFO command is added.

**Сorrections:**

1) FLS values are set to zero after disconnection.
2) Error during remote downloading of Easy Logic algorithms is fixed.

#### Change log of 18.0 firmware:
**Сorrections:**

1) Driver behaviour detection algorithm is changed. It uses now accelerometer measurements.
2) Archive collection from other devices using Wi-Fi is added. (For Galileosky Base Block only)

### 4.16.6 (21.11.17)

**New features:**

- 17.4 beta firmware for Galileosky 7 and Galileosky Base Block is added.
- 231.20 stable firmware for Galileosky GLONASS/GPS is added.

#### Change log of 17.4 firmware:
**Сorrections:**

1) Easy Logic algorithms startup error is fixed.

#### Change log of 231.20 firmware:
**Corrections:**

1) Defrost detection error with EuroScan is fixed.

### 4.16.5 (14.11.17)

**New features:**

- 17.3 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 17.3 firmware:
**Сorrections:**

1) CAN initialization error is fixed.

### 4.16.4 (03.11.17)

**New features:**

- 17.2 beta firmware for Galileosky 7 and Galileosky Base Block is added.

**Corrections:**

- A rare crash during application startup is fixed. Device orientation widget is temporary disabled.

#### Change log of 17.2 firmware:
**New features:**

1) Possibility to send commands to the tracking unit by means of Easy Logic is added. Only those commands are supported that do not modify the settings of the tracking unit.

**Сorrections:**

1) SD card initialization error is fixed.
2) Better WebDAV compatibility.
3) Shock and tilt detection error is fixed.

### 4.16.3 (30.10.17)

**New features:**

- 17.1 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 17.1 firmware:
**New features:**

1) SIM-card priority is added.
2) Inputs state is accessible in Easy Logic.
3) FLS data in EGTS protocol is added. Archive structure is changed, all unsent data will be lost.

**Сorrections:**

1) CAN initialisation error in Easy Logic is fixed.
2) Better WebDAV compatibility.

### 4.16.2 (30.10.17)

**New features:**

- 16.7 stable firmware for Galileosky 7 is added.
- Sending FLS data with addresses 3-15 from the file of internal memory archive to the server is added.
- Ability to edit simultaneously several calibration tables is added.

#### Change log of 16.7 firmware:
**Corrections:**

1) GSM power on is fixed.

### 4.16.1 (24.10.17)

**Corrections:**

- Wrong main packet setup is fixed.

### 4.16.0 (25.09.17)

**New features:**

- 16.6 stable firmware for Galileosky 7 and Galileosky Base Block is added.
- 17.0 beta firmware for Galileosky 7 and Galileosky Base Block is added.
- 231.18 stable firmware for Galileosky GLONASS/GPS is added.

#### Change log of 16.6 firmware:
**New features:**

1) GNSS module data absence indication is added.

**Corrections:**

1) Error during registartion in GSM network is fixed.
2) Error in Wiegand26 handler is fixed.
3) Arguments substitution in command responses from EasyLogic is added.

#### Change log of 17.0 firmware:
**New features:**

1) Ability to syncronize data stored on SD card with WebDAV server is added.
2) A filtering and transforning mechanism for measured data is added.
3) Mileage setup commnad is added.
4) Multiple EasyLogic algorithms could be run simultaneously.

#### Change log of 231.18 firmware:
**Corrections:**

1) Error in CAN-LOG handler is fixed.

### 4.15.3 (13.09.17)

**New features:**

- 16.4 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 16.4 firmware:

**Corrections:**

1) GSM module power off from EasyLogic is fixed.

### 4.15.2 (31.08.17)

**New features:**

- 231.17 stable firmware for Galileosky GLONASS/GPS is added.
- 16.3 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 231.17 firmware:

**Corrections:**

1) Error in responses to CAN filters setup commands is fixed.

#### Change log of 16.3 firmware:

**Corrections:**

1) First packet is sent after connection drop.
2) Ringer sound level is increased.

### 4.15.1 (26.08.17)

**New features:**

- 229.18 and 231.16 stable firmwares for Galileosky GLONASS/GPS are added.
- 16.2 beta firmware for Galileosky 7 and Galileosky Base Block is added.

#### Change log of 229.18 firmware:

**Corrections:**

1) After accumulator discharge internal time is set to 01/01/2000.

#### Change log of 231.16 firmware:

**Corrections:**

1) Error with saving RS485 FLS temperature using EasyLogic is fixed.

### 4.15.0 (25.08.17)

**New features:**

- Portuguese version of the Configurator is prepared.

### 4.14.8 (24.08.17)

**New features:**

- 16.1 beta firmware for Galileosky 7 is added.

#### Change log of 16.1 firmware:

**Corrections:**

1) Mistake concerning frequent breaks of server connection via Wi-Fi is fixed.

### 4.14.7 (18.08.17)

**New features:**

- Spanish version of the Configurator is prepared.
- 16.0 beta firmware for Galileosky 7 is added.

#### Change log of 16.0 firmware:

**Corrections:**

1) Wrong refrigerator data transmission is fixed.

### 4.14.6 (09.08.17)

**New features:**

- 15.7 beta firmware for Galileosky Base Block is added.

#### Change log of 15.7 firmware:

**Corrections:**

1) Better photo read errors handling.

### 4.14.4 (03.08.17)

**New features:**

- 231.15 stable firmware for Galileosky GLONASS/GPS are added.

#### Change log of 231.15 firmware:

**New features:**

1) Reply to incorrect SMS with russian symbols is disabled.

**Corrections:**

1) Error with geofences recording is fixed.

### 4.14.3 (31.07.17)

**New features:**

- 15.6 beta firmware for Galileosky Base Block is added.

#### Change log of 15.6 firmware:

**New features:**

1) Maximum speed filtration is added. Command gps.correct is not compatible with 1.x firmwares.

**Corrections:**

1) External power detection is fixed.
2) Removing old photos from SD card is fixed

### 4.14.2 (31.07.17)

**New features:**

- 2.0 beta firmware for Galileosky 7 is added.

#### Change log of 2.0 firmware for Galileosky 7**

**New features:**

1) Signaling mode is added.
2) Ability to store trusted keys on SD card is added.
3) Receiving CAN messages in EasyLogic is added.
4) Sending CAN messages from EasyLogic is added.
5) Remote config is enabled by default.
6) Maximum speed filtration is added. Command gps.correct is not compatible with 1.x firmwares.

**Corrections:**

1) Better frequency measurement accuracy.

### 4.14.1 (26.07.17)

**New features:**

- 15.5 beta firmware for Galileosky Base Block is added.
- 231.14 and 229.17 stable firmwares for Galileosky GLONASS/GPS are added.

#### Change log of 15.5 firmware:

**New features:**

1) DataCOLD600 and Carrier Gateway support.
2) Request RPM data from DataCOLD500. Archive structure has been changed, all saved data will be lost.

#### Change log of 231.14 and 229.17 firmware:

**Corrections:**

1) Error, connected with CAN data reset to zero while operating in OBDII mode, is fixed.

### 4.14.0 (24.07.17)

**New features:**

- 15.4 beta firmware for Galileosky Base Block is added.

#### Change log of 15.4 firmware for Galileosky Base Block:**

**Corrections:**

1) Wrong transmission of PressurePro data is fixed.
2) Wrong transmission of fridge data is fixed.
3) Wrong transmission of photos is fixed.
4) Mileage data is accessible from EasyLogic.

### 4.13.10 (17.07.17)

**New features:**

- 1.6 beta firmware for Galileosky 7 is added.

#### Change log of 1.6 firmware for Galileosky 7**

**Corrections:**

1) Power on of GSM is fixed.

### 4.13.9 (14.07.17)

**New features:**

- 1.5 beta firmware for Galileosky 7 is added.
- IN 4 and IN5 could be set as ignition sensors for Galileosky 7.

#### Change log of 1.5 firmware for Galileosky 7**

**Corrections:**

1) Wrong measurements on IN4 and IN5 are fixed.
2) Setup commands for SIM1 are added.

### 4.13.8 (29.06.17)

**New features:**

- 16 RS485 FLS are shown on "Device" tab.

### 4.13.6 (19.06.17)

**New features:**

- 15.1 beta firmware for Galileosky Base Block is added.


#### Change log of 15.1 firmware for Galileosky Base Block:**

**New features:**

1) Signaling mode is added.
2) Ability to store trusted keys on SD card is added.

**Corrections:**

1) Faster switching to SIM-chip if preferred GSM-networks are set.

### 4.13.5 (16.06.17)

**New features:**

- 231.13 stable firmware for GALILEOSKY GLONASS/GPS v5.1, v5.0, v4.0, v2.5, v2.5 lite is added.

#### Change log of 231.13 firmware:

**Corrections:**

1) Error in microphone gain setup on terminals with SIM900 is fixed.
2) Reset during setup is fixed.
3) Out of order message is sent using Iridium modem if connection with server is not available.

### 4.13.3 (23.05.17)

**New features:**

- 14.5 beta firmware for Galileosky Base Block is added.

#### Change log of 14.5 firmware for Galileosky Boxfinder:**

**Corrections:**

1) Error in archive with chronological send order is fixed.
2) Error in settings for SIM-chip is fixed.

### 4.13.2 (22.05.17)

**New features:**

- 10 stable firmware for Galileosky Boxfinder is added.

#### Change log of 10 firmware for Galileosky Boxfinder:**

**Corrections:**

1) Archive handling error is fixed.

### 4.12.33 (07.04.17)

**New features:**

- 12.10 stable firmware and 14.1 beta firmware for GALILEOSKY Base Block are added.

#### Change log of 12.10 firmware:

**Corrections:**

1) Error of detection of GLONASS aerial connection is fixed.

#### Change log of 14.1 firmware:

**New features:**

1) Time syncronization using GSM.
2) Inputs values set blocks and impulse count shutdown blocks in EasyLogic are implemented.

**Corrections:**

1) Sending photo error is fixed.
2) iButton handling error is fixed.
3) Wrong coordinates fitering by external power is fixed.

### 4.12.32 (03.04.17)

**New features:**

- 231.8 beta firmware for GALILEOSKY GLONASS/GPS v5.1, v5.0, v4.0, v2.5, v2.5 lite is added.

#### Change log of firmware:

**New features:**

1) DataCOLD600 support.

**Corrections:**

1) Internal time is set to 01.01.2000 after accumulator discharge.

### 4.12.31 (10.03.17)

**New features:**

- 231.7 beta firmware for GALILEOSKY GLONASS/GPS v5.1, v5.0, v4.0, v2.5, v2.5 lite is added.

#### Change log of firmware:

**Corrections:**

1) Error in roaming handling with SIM800 is fixed.
2) Machine hours request from EruroScan is fixed.

### 4.12.30 (03.03.17)

**New features:**

- 229.15 stable firmware and 231.5 beta firmware for GALILEOSKY GLONASS/GPS v5.1, v5.0, v4.0, v2.5, v2.5 lite are added.

#### Change log of firmware:

**Corrections:**
1) Coordinates filtering error is fixed.

### 4.12.29 (02.03.17)

**New features:**

- Wi-Fi control functions are added to EasyLogic.

### 4.12.28 (16.02.17)

**New features:**

- 14 beta firmware for GALILEOSKY Base Block is added.
- 231.5 beta firmware for GALILEOSKY GLONASS/GPS v5.1, v5.0, v4.0, v2.5, v2.5 lite is added.

#### Change log of 231.5 firmware:

**Corrections:**

1) OBD error codes handling is fixed.
2) Error in algorihms handling is fixed.

#### Change log of 14 firmware:

**New features:**

1) Archive on SD card.
2) Archive uploading from SD card with every second detalization.
3) A capability to control WiFi module from EasyLogic.
4) Archive uploading from internal memory in chronological order.
5) Wiegand26 support.

**Corrections:**

1) Spontaneous resets of terminal with WiFi module are fixed.

### 4.12.26 (19.01.17)

**New features:**

- 229.14 stable firmware is added
- 230.14 beta firmware is added

#### Change log of 229.14 and 230.14 firmware:

**Corrections:**

1) OBD error codes handling is fixed.
2) Error in algorihms handling is fixed.

### 4.12.25 (17.01.17)

**Corrections:**

- Remote connection to GALILEOSKY devices is fixed


### 4.12.24 (29.12.16)

**New features:**

- 12.7 stable firmware for GALILEOSKY Base Block is added

#### Change log of 12.7 firmware for GALILEOSKY Base Block:**

**Corrections:**

1) Spontaneous terminal reset is fixed.


### 4.12.23 (27.12.16)

**Corrections:**

- Remote connection to GALILEOSKY v2.5 devices is fixed


### 4.12.22 (26.12.16)

**New features:**

- 12.6 stable firmware for GALILEOSKY Base Block is added

#### Change log of 12.6 firmware for GALILEOSKY Base Block:**

**Corrections:**

1) Fixed data transmission error in poor GSM coverage areas.


### 4.12.21 (20.12.16)

**New features:**

- The ability to activate user defined OBD2 CAN filter for firmware 13 of GALILEOSKY Base Block is added.
- Built-in accelerometer's values are added into algorithms.


### 4.12.20 (15.12.16) - Installer

**Corrections:**

- Internal memory download speed is optimized.
- Display of device state for GALILEOSKY Base Block is fixed.


### 4.12.19 (08.12.16)

**Corrections:**

- Display of analog ins values for GALILEOSKY Base Block is fixed.


### 4.12.18 (06.12.16)

**New features:**

- 229.13 stable firmware is added
- 13 beta-firmware of GALILEOSKY Base Block is added

#### Change log of 229.13 firmware of GALILEOSKY terminals:**

**New features:**

1)  New command DELALLKEYS for deletion of all trusted keys from SD card is added.

#### Change log of 13 beta-firmware of GALILEOSKY Base Block:**

**New features:**

1) GalileoSky photocamera support is added.


### 4.12.17 (28.11.16)

**New features:**

- First firmware for GALILEOSKY BOXFINDER GSM with Iridium module is added


### 4.12.15 (21.11.16)

**Corrections:**

- Display protocol settings page for GALILEOSKY v 4.0 and Base Block is fixed.


### 4.12.14 (17.11.16)

**Corrections:**

- Display of parameters obtained via RS485 for GALILEOSKY v 4.0 is fixed.
- Display settings error for firmware with revision greater than 9 is fixed.
- Missing settings of RS485 operating mode for GALILEOSKY v4.0 and Base Block are added.


### 4.12.13 (08.11.16)

**New features:**

- 229.12 stable firmware is added
- 230.13 beta-firmware is added

#### Change log of 229.12 firmware of GALILEOSKY terminals:**

**Corrections:**

1)  External temperature sensors handling on DataCOLD500 is fixed

#### Change log of 230.13 firmware of GALILEOSKY terminals:**

**Corrections:**

1) Connection behaviour in roaming for terminals with SIM800 is fixed.
2) External temperature sensors handling on DataCOLD500 is fixed


### 4.12.12 (28.10.16)

**Corrections:**

- Problem with protocol settings for GALILEOSKY Base Block lite is fixed


### 4.12.11 (25.10.16)

**New features:**

- Support for GALILEOSKY Base Block 1.0.50 is added
- 12 beta-firmware of GALILEOSKY Base Block is added

#### Changes:**

- Easy Logic: GALILEOSKY Button's event and action are removed

**Corrections:**

- iButton's tags(via RS485) were added into protocol for GALILEOSKY Base Block lite

#### Change log of 12 beta-firmware of GALILEOSKY Base Block:**

**New features:**

1) BaseBlock v1.0.5 support.
2) Long file names support in autoinformer.

**Corrections:**

1) Fixed wrong filtering of coordinates using ignition input.
2) Fixed data transmission using EGTS protocol.


### 4.12.10 (19.09.16)

**New features:**

- Support for GALILEOSKY BOXFINDER GSM is extended
- Easy Logic: Remove and rewrite algorithms from server are added
- 229.11 stable firmware is added
- 230.11 beta-firmware is added

#### Change log of 229.11 and 230.11 firmwares of GALILEOSKY terminals:**

**Corrections:**

1) Fixed error in CAN-LOG data handling.
2) Fixed return air handling from DataCOLD500.


### 4.12.8 (08.09.16)

**Corrections:**

- 7 beta-firmware was removed, because it led to terminal's malfunction in some cases


### 4.12.7 (18.08.16)

**New features:**

- 10 beta-firmware of GALILEOSKY Base Block is added

#### Change log of 10 beta-firmware of GALILEOSKY Base Block:**

**New features:**

1) BaseBlock Optimium, Hard and Wi-Fi support.
2) Custom PID requests using J1979.
3) CAN-LOG support using RS485.

**Corrections:**

1) The error of incoming SMS handler in algorithms is fixed

**Corrections:**

- Data downloading from internal flash memory for specified period is fixed
- The trouble of inability to accept SMS received from any telephone number for algorithms' block "Incoming SMS" is fixed


### 4.12.6 (29.07.16)

**Corrections:**

- Operation via proxy server is corrected


### 4.12.5 (11.07.16)

**New features:**

- Data downloading from internal flash memory for specified period is added


### 4.12.4 (07.07.16)

**Corrections:**

- Fixed support for GALILEOSKY BOXFINDER SAT devices


### 4.12.3 (06.07.16)

**New features:**

- 230.9 beta-firmware is added
- 7 beta-firmware of GALILEOSKY Base Block is added

#### Change log of 230.9 beta-firmware of GALILEOSKY terminals:**

**Corrections:**

1) Fixed Trimble EzGuide compatibility.
2) Fixed wrong sending order of photos.

#### Change log of 7 beta-firmware of GALILEOSKY Base Block:**

**Corrections:**

1) Fixed wrong coordinates filtering.


### 4.12.2 (24.06.16)

**New features:**

- 6 beta-firmware of GALILEOSKY Base Block is added

#### Change log of 6 beta-firmware of GALILEOSKY Base Block:**

**Corrections:**

1) Fixed wrong coordinates filtering.


### 4.12.1 (16.06.16)

**New features:**

- Support for GALILEOSKY BOXFINDER SAT devices is added

**Corrections:**

- Settings files of GALILEOSKY Base Block HARD WI-FI, HARD 3G and OPTIMUM is corrected


### 4.12.0 (10.06.16)

**New features:**

- 5 beta-firmware of GALILEOSKY Base Block is added

#### Change log of 5 beta-firmware of GALILEOSKY Base Block:**

**Corrections:**

1) Fixed wrong voltage measurement (first appeared in firmware 4).
2) Fixed encoding of SMS with Russian language symbols.


### 4.11.1 (09.06.16)

**New features**

- Small GUI changes for Windows 10 Touch Screen


### 4.11.0 (08.06.16)

**New features:**

- Support for GALILEOSKY GPS v2.5 device is added
- 229.9 stable firmware is added
- 230.7 beta-firmware is added
- 4 beta-firmware of GALILEOSKY Base Block is added
- Representation of Iridium packet size of GALILEOSKY GPS/GLONASS Satellite v4.0 is added

**Improvements:**

- Reset settings to default is made by page. To reset all the settings, press and hold _Reset page_ button
- Speed up application startup

**Corrections:**

- Connection to remote server is corrected
- Online status of remote device is corrected

#### Change log of 229.9 stable firmware of GALILEOSKY terminals:**

**New features:**

1) GALILEOSKY GLONASS/GPS v2.5 support.

#### Change log of 230.7 beta-firmware of GALILEOSKY terminals:**

**New features:**

1) GALILEOSKY GLONASS/GPS v2.5 support.
2) CAN-LOG support using RS485.

#### Change log of 4 beta-firmware of GALILEOSKY Base Block:**

**Corrections:**

1) Fixed nulling of counted impulses after reset.


### 4.10.0 (25.05.16)

**New features:**

- 3 beta-firmware for GALILEOSKY Base Block is added

**Corrections:**

- Fix downloading internal archive instead of external after reconnection

### 4.9.4 (06.05.16)

**New features:**

- Tooltips for parameters on Settings page is added

**Corrections:**

- Flags representation on Protocol tab of Base Block LITE is corrected

### 4.9.3 (27.04.16)

**Corrections:**

- GPS.CORRECT command representation - coordinates filtering

### 4.9.2 (19.04.16)

**Corrections:**

- Show firmware selection dialog, if requested firmware file is not found

### 4.9.1 (08.04.16)

**Corrections:**

- Minor enhancements

### 4.9.0 (01.04.16)

**New features:**

- Support for GALILEOSKY GPS v2.4 lite device is added
- 229.8 stable firmware is added
- 230.6 beta-firmware is added

**New features of 229.8 and 230.6 firmware versions:**

- Support for GALILEOSKY GPS v2.4 lite devices is added

### 4.8.1 (01.03.16)

**Corrections:**

- Added the ability to run more than one instance of Configurator on the same PC

### 4.8.0 (17.02.16)

**New features:**

- 230.5 beta firmware is added

### 4.7.0 (25.01.16)

**New features:**

- Support for GALILEOSKY BOXFINDER devices is added
- 4 beta-firmware for GALILEOSKY BOXFINDER devices is added

**Corrections:**

- Firmware change log is updated to 230.4 version

**GALILEOSKY BOXFINDER firmware change log:**

[4_T_0000][22.01.2016]
**Corrections:**

1) Battery voltage determination error of GALILEOSKY BOXFINDER GSM v1.0 devices without socket is fixed.
2) Unsealing sensor status setting is corrected.

[3_T_0000][26.10.2015]
**New features:**

1) Support GALILEOSKY BOXFINDER GSM devices without socket.

[1_T_0000][24.06.2015]
**New features:**

1) First release.

### 4.6.1 (21.01.16)

**Corrections:**

- 229.7 stable firmware is updated

### 4.6.0 (19.01.16)

**New features:**

- 229.7 stable firmware is added

### 4.5.0 (25.12.15)

**Corrections:**

- Tag setting on CAN tab of Settings page is corrected

**New features:**

- Firmware change log is added to About dialog

### 4.4.4 (19.12.15)

- Minimum default value of DFILTER command is corrected

### 4.4.3 (15.12.15)

- 230.4 beta-firmware is corrected

### 4.4.2 (14.12.15)

**Corrections:**

- Default maximum speed value in GPS.CORRECT command is corrected
- News and user manuals loading from official site is corrected
- Displaying of the device 3D-model when it is turned over is corrected
- Items titles on page Settings is corrected

**New features:**

- Language option icon is added

### 4.4.1 (03.12.15)

**Corrections:**

- Displaying of device settings is corrected

### 4.4.0 (26.11.15)

**New features:**

- Support for GALILEOSKY GPS/GLONASS v2.4 devices is added

#### Changes:**

- Configurator contains following firmware versions:
- 230.4 - beta-version;
- 229.6 - stable;
- 199 - stable;
- 30 - stable (for old devices).

**Corrections:**

- Upgrade old devices to 30 firmware is corrected

**New features of 229.6 firmware:

- GALILEOSKY GLONASS/GPS v2.4 support

**Corrections of 229.6 firmware:

- Fixed CLEANPHOTOQUEUE command
- Fixed incorrect data recording in archive on SD card at 00:00 am
- Fixed GPRS session dropping after disconnection with server on terminals v5.1

### 4.3.0 (20.11.15)

**New features:**

- 230 firmware support is added

**Corrections:**

- STATUS command processing is corrected
- DFILTER command processing for GALILEOSKY GPS/GLONASS v5.1 (3G) is corrected

**New features of 230 firmware:

- Sending of additional data using EGTS protocol:
- external power supply;
- internal battery power;
- status of inputs;
- status of outputs;
- analog inputs data;
- digital fuel level sensors(FLS) data.
- Command for requesting CCID of active SIM-card
- Support of Trimble guidance systems on all devices with RS232 interface
- Maximum call time setting
- Command for setting mileage
- Filtering of RS485 FLS data
- Geofence count increased to 300
- Command for requesting active SIM-card's index and MNC/MCC of active GSM-network
- Setting to reset device if there are no sent data during specified interval

### 4.2.5 (15.10.15) - Installer

- Upgrading of GALILEOSKY GPS/GLONASS v2.2.x devices to 199 firmware is fixed (was broken in version 4.2.1)

### 4.2.4 (28.09.15)

- 229.4 firmware file is updated

### 4.2.3 (09.09.15)

- Default ranges of powincfg command is corrected for GALILEOSKY GPS/GLONASS v5.0 devices

### 4.2.2 (02.09.15)

- Default ranges of powincfg command is corrected

### 4.2.1 (31.08.15)

- Firmware 229 is updated

### 4.2.0 (21.08.15)

- Setting of the parameters on Protocol tab for 192-204 firmwares is corrected
- Choosing file for archive saving is corrected

### 4.1.1 (31.07.15)

- GALILEOSKY GPS/ГЛОНАСС Satellite v4.0 settings is corrected

### 4.1.0 (16.07.15)

- Operating with remote control server is improved
- Device upgrading procedure is unified

### 4.0.5 (03.07.15)

Operation with device settings is changed:

- Device settings colorization is added:

Color list according to priority order:
1) _red_ - unknown parameter. Parameter value stored in device is unknown;
2) _yellow_ - modified parameter. Value has been modified by user;
3) _green_ - actual parameter. Parameter value has been loaded from device;

> Tab color is set to most priority color

- settings is loaded tab by tab:

- loading setting of tab is initiated by switching on one;
- to load all settings press and hold `Load tab` to open popup menu, than
press `Load everything`;

- only modified parameters is going to be applied:

- only _yellow_ parameters will be uploaded to device when `Apply` button
is pressed

### 4.0.4 (23.06.15)

- e-mail address for user registration is changed (support@7gis.ru)

### 4.0.3 (01.06.15)

- 229-beta firmware file is updated

### 4.0.2 (29.05.15)

- 229-beta firmware file is added
- Firmware upgrading is corrected

### 4.0.1 (25.05.15) - Installer

- Firmware upgrading is corrected

### 4.0.0 (12.05.15) - Installer

**New features:**

- Opportunity of the program operation without OpenGL drivers

**Changes:**

- The driver is set by a standalone installer as root
- Launch of the driver setting is carried out by a standard installer;
- The Configurator of version 4 is set in parallel with the Configurator of version 3

----------------------------------------------------------------------

### 3.5.5 (27.04.15)

- Opportunity to choose "GALILEOSKY with compression" data transmission protocol is added starting from the firmware 229
- Table displaying is corrected on Protocol tab of Settings for the GPS/GLONASS Satellite v4.0 terminal.
- Sending of many network requests is corrected by the failed authorization on the proxy server

### 3.5.3 (01.04.15)

- Absence the "use only SIM 1" option of the "SIMSwitch" command for GALILEOSKY GPS/GLONASS v5.0 devices is corrected
- Displaying of the outputs states on Ins/Outs tab is corrected
- "Max. speed" is removed, starting from firmware 228

### 3.5.2 (18.03.15)

- Request for the OBD-II test confirmation is added
- Downloading of the internal archive (omission of a point and duplication of the next one) is corrected
- Maximum possible value of SPUTNIK command parameter is increased up to 2147483647
- Value of the first parameter of GPS.CORRECT2 command is increased up to 3600

### 3.5.1 (13.02.15)

- Support of firmware 228 is added

### 3.5.0 (29.12.14) - Installer

- Driver for GALILEOSKY devices is updated

### 3.4.12 (11.12.14)

- Support of firmware 227 is added
- Files of firmware settings are corrected
- Installation of the Configurator is corrected if User Account Control (UAC) is enabled in Windows

### 3.4.11 (01.12.14)

- Connection to device is corrected
- Displaying of the longitude on Routes tab is corrected

### 3.4.10 (14.11.14)

- Support of firmware 226 corrections is added
- Opportunity of choosing all registers on CAN tab of Settings page is corrected.
- CAN scanning for the remote devices is corrected.
- Geofences saving to the local device is corrected.
- Device registration on the remote server by having zeroes at the beginning of IMEI is corrected.

### 3.4.9 (03.10.14)

- Support of the GALILEOSKY GPS/GLONASS v5.1 device (3G, SIM-chip) is fixed

### 3.4.8 (09.09.14)

- Support of the GALILEOSKY GPS/GLONASS v5.1 device (3G, SIM-chip) is added
- Support of firmware 226 is added

### 3.4.7 (01.09.14)

- Geofences setting by the configuring of remote device is corrected
- Setting of digital inputs for the GALILEOSKY v2.3 lite device is corrected
- CAN data display on Device tab for the GALILEOSKY v2.3 lite device is corrected

### 3.4.6 (01.08.14) - Installer

- Geofences download from the device and from settings file is corrected
- Description of Galileo protocol parameters is corrected
- Troubleshooting points are renamed

### 3.4.5 (21.07.14)

- Accelerometer troubleshooting is added to GALILEOSKY v1.8.5 lite and GALILEOSKY v2.3 lite devices
- Connection to devices via USB is corrected

### 3.4.4 (02.07.14)

- Support of firmware 224 is added
- Data transmission from a CSV-file to the server is corrected
- Commands forming of the list of cellular operators codes and FLS calibration tables is corrected

### 3.4.3 (25.06.14)

- Archive download for the GALILEOSKY v1.8.5 lite devices is fixed
- Firmware upgrade for the obsolete devices is fixed

### 3.4.2 (18.06.14) - Installer

- Opportunity to upgrade firmware of the GALILEOSKY GPS/GLONASS Satellite v4.0 device is added
- Storing of the folder, from which the file of the device settings is opened, is corrected
- Storing of log files and program settings by the Configurator updating is corrected

### 3.4.1 (06.06.14)

- The Tenzo-M weight indicator function of the RS-232 port is added
- The AWT640 weight indicator function of the RS-232 port is added
- The Test RS232 function of the RS-232 port is added
- The height field is added on the Device tab
- Firmware 223 for the GALILEOSKY GPS v2.3 lite device is added
- Download of the internal archive for firmwares 205 and further is corrected

### 3.4.0 (19.05.14) - Installer

- Support of firmware 223 (EGTS protocol) is added
- Options of archive structure control for the GALILEOSKY GPS vX. X lite devices are added
- Boot loader is corrected. The updating of the Configurator is carried out even if the current version is installed
- Data sending to the server is corrected
- The structure size of the refrigerator by calculating the size of the point, sent to the server, is corrected
- The structure size of the refrigerator by the uploading from the internal archive is corrected

### 3.3.2 (13.05.14)

- Firmware upgrade for the GPS/GLONASS v5.1 (3G) and GPS/GLONASS Satellite v4.0 devices is supported

### 3.3.1 (19.02.14) - Installer

- Updating for some parameters is added on the Protocol tab, so they can be stored only in dynamic archive
- The Refrigerator parameter is added on the Protocol tab
- The Upgrade firmware button is not displayed for the GPS/GLONASS Satellite v4.0 device

### 3.3.0 (05.02.14) - Installer

- Automatic update of the Configurator is implemented
- Support of the device 21 (v5.1) is added, starting from firmware 207
- Displaying of the point size, sent to the server, is added by choosing the archive location on microSD
- Support of the REMOTECONFIG command is added for the lite devices
- The Driving field in the Navigation data group is added on the Device tab. The Acceleration by... field is deleted from the Analog inputs group
- The Satellite modem option is added on the Troubleshooting tab
- Processing of the negative temperature in the reply of the RS485 command is corrected
- Calculation of points number in static archive is corrected
- Calculation of points size is corrected. Point size is calculated for data transmission via a satellite
- Operation with a proxy server is corrected

### 3.2.10

- Displaying of a track from CSV-file is corrected
- Data storage from the device internal memory is corrected

### 3.2.9

- Editing of the codes list for cellular operators is improved
- Support of firmware 221 is added

### 3.2.8

- Support of the 1.9-lite devices is corrected

### 3.2.7

- Displaying of the device type is added on the Device tab
- Work with the CAN troubleshooting section is improved
- Support of firmware 206: DBG-S11D dosimeter, the "Not clear data after the CAN-bus disconnection" option
- Support of firmware 199: the "Not clear data after the CAN-bus disconnection" option

### 3.2.6

- Maximum length of the authorized phone number - 14 symbols
- Displaying of news from web-site is corrected
- Support of firmware 220 is added
- Support of the technological firmware by the 1.9, 1.9-lite, 2.3 devices is corrected

### 3.2.5

- Download speed of the devices list by remote configuring is increased dramatically

### 3.2.4

- Support of firmware 204 is added

### 3.2.3

- Timeout determination from the CANREGIME command is corrected
- Calculation of the size of the records, stored in the archive and sent to the server, is corrected
- Corrected: there is no RS232, only RS485 in device 16

### 3.2.2

- Displaying of the record size of one point, sent to the server, is added
- Loss of some troubleshooting messages is corrected
- Support of firmware 199 is corrected

### 3.2.1

- Support of firmware 210 is added

### 3.2.0

- Support of the 2.3, 1.9, 1.9 lite devices is added
- Support of firmwares 201 and 202 is added

### 3.1.9

- Upload of the archive from SD-card is corrected
- By default the Routes  tab centers on the coordinates of the connected device

### 3.1.8

- Correction of firmware 200
- Connection via a proxy server is corrected

### 3.1.7

- Support of firmware 200 is added
- Error of the firmware upgrade from zip-file from a disc is corrected
- Correction of the connection to a proxy server
- Loading of the Internet channel is decreased by connection to the remote server

### 3.1.5

- Opportunity to specify a proxy server via the parameter of the command line is added:

-proxy <host>: <port>: <user>: <password>

- Support of old devices is corrected

### 3.1.4

- Opportunity to register the list of devices is added
- Indicator of commands processing by the remote server is added to the dialog of device choice
- Processing of the commands, sent to the remote server, is corrected
- Loading of the Internet channel is decreased at the moment of connection to the remote server

### 3.1.3

- Support of old devices is corrected

### 3.1.2

- Disconnection of the Configurator from the server is corrected by a big number of the user's devices
- Deleting of devices group is carried out after the action confirmation
- Download speed  of the commands list is increased
- Descriptions of i-Button actions are specified: trusted key or any other key

### 3.1.1

- Read error of archive configuration settings is corrected

### 3.1.0

- ...
- Support of RS485[0..2] parameters sending to the server from CSV-file is added
- Dialog of the user registration is improved

### 3.0.7

- Support of firmware 193 is added
- Support of the headpack2, mainpack2 commands is added to firmware 186
- Downloading of the English documentation from website is added

### 3.0.6

- The User's Manual for GalileoSky GPS\GLONASS v5.0 terminals (firmware 0192) is updated
- Opportunity to download the missing documentation from web-site (GalileoSky GPS\GLONASS, GalileoSky GPS lite)
- Support of firmwares 191 and 192 is added
- Opportunity to send commands in the command mode for the remote device in line is added
- Support of the headpack2, mainpack2 commands (starting from firmware 190) is added
- Support of the remoteconfig command (starting from firmware 186) is added
- CAN scanning for the remote device is corrected
- The use of system proxy is corrected

### 3.0.5

- Opportunity to store the results of the CAN reading to the file and reading them from this file
- Commands for the control of the internal archive structure are added
- Displaying of points number by the dynamic structure of the internal archive is added

### 3.0.4

- Archive upload from the device with beta-firmwares is corrected
- Troubleshooting for all firmwares of all devices is corrected

### 3.0.3

- Support of firmware 184

#### 3.0.2

- Error of the displaying of the device 3D-model is corrected

### 3.0.1

- Debugging messages of the operation with the remote device are added to the log file
- Displaying of the process of the remote device state scanning is added
- Displaying of the remote devices as inactive in the list by choosing the remote device commutator is corrected
- Width of the setting field, not containing the text, displayed by default, is corrected
- Search for the device driver in the system catalog is corrected
- Error, arising by the program close down, is corrected
- Error, not allowing to reconnect to the device, is corrected
- Reactivation of the remote device troubleshooting after its miss is corrected

### 3.0.0

- Program interface is changed
- 3D-model of the device is changed
- Request for changing the password by the remote device registration
- Reading of the authorized phones from file for all devices is corrected
