import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_SaveParameter"

    // unique for every action
    actionId: 0x05
    actionName: QT_TRANSLATE_NOOP("SaveParameter", "SaveParameter")
    actionTitle: qsTr("SaveParameter:\n???")
    actionToolTip: qsTr("Choose where to save result value")
    actionOutputCount: 1

    parameterDialogSource: 'SaveParameterDialog.qml'

    actionType: "action"
    view_type: view_types.save_param // влияет на цвет рамки. Обрабатывается в degign_loader

    // Отключаем возможность прицепляться для этого блока:
    drag_point_source: null

    parametersModel: ListModel {
        id: core_model

        onDataChanged: {
            setTitle();
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SaveParameter", "Parameter")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SaveParameter", "Result")
            paramType: "int"
            varCategory: "localConst"
            varAllowance: "filter"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var _result  = parametersModel.get(1).varName

        if (_result.length === 0)
            _result = qsTr("???")

        actionTitle = qsTr("Saved to:\n  %2").arg(_result)
    }
}
