import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1

Rectangle {
    id: leftPanel
    objectName: "leftPanel"
    color: colorWhitespace

    property bool eventsAreEnabled : false;
    property bool actionsAreEnabled : false;
    property bool globalVarsAreEnabled : false;
    property bool filtersAreEnabled : false;
    property bool parametersAreEnabled : false;

    ScrollView {
        id: view
        objectName: "view"

        anchors.fill: parent
        flickableItem.interactive: leftPanelInteractive
        flickableItem.flickableDirection: Flickable.VerticalFlick
        style: MyScrollViewStyle {}

        Column{

            ActionsToolBar {
                id: eventToolBar
                objectName: "eventToolBar"
                visible: eventsAreEnabled
                width: view.width
                actionTitle: qsTr("Events")
                actionModel: EventsModel {}
            }

            ActionsGroupToolBar {
                id: actionsGroupToolBar
                objectName: "actionsGroupToolBar"
                visible: actionsAreEnabled
                width: view.width
            }

            VarsPanel {
                id: globalVarsRect
                objectName: "globalVarsRect"
                visible: globalVarsAreEnabled
                width: view.width
                panelTitle: qsTr("Global vars")
                varCategory: categoryGlobal
            }

            ActionsToolBar {
                id: filterToolBar
                objectName: "filterToolBar"
                visible: filtersAreEnabled
                width: view.width
                actionTitle: qsTr("Filters")
                actionModel: FiltersModel {}
            }

            ActionsToolBar {
                id: parameterToolBar
                objectName: "parameterToolBar"
                visible: parametersAreEnabled
                width: view.width
                actionTitle: qsTr("Parameters")
                actionModel: ParametersModel {}
            }
        }
    }
}
