import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_MathFilter"

    // unique for every action
    actionId: 0x06
    actionName: QT_TRANSLATE_NOOP("MathFilter", "MathFilter")
    actionTitle: qsTr("Mathematics")
    actionToolTip: qsTr("Mathematical operation Filter")

    parameterDialogSource: 'MathFilterDialog.qml'

    actionType: "action"
    view_type: view_types.two_inputs_filter
    need_check_tar_table: false

    inputs_lables: [qsTr("left operand"), qsTr("right operand")];

    parametersModel: ListModel {

        onDataChanged: {
            setTitle();
            sendResultToNext();
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("MathFilter", "LeftVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("MathFilter", "RightVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        // <- insert position
        ListElement {
            paramName: QT_TRANSLATE_NOOP("MathFilter", "ResultVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
    }

    Component.onCompleted: {
        parametersModel.insert(2,
                    {
                        "paramName": qsTranslate("MathFilter", "Operation"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : qsTranslate("MathFilter", "*"),
                                "desc"    : qsTranslate("MathFilter", "Multiplication"),
                                "value"   : 0
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "/"),
                                "desc"    : qsTranslate("MathFilter", "Devision"),
                                "value"   : 1
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "%"),
                                "desc"    : qsTranslate("MathFilter", "Devision remainder"),
                                "value"   : 2
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "+"),
                                "desc"    : qsTranslate("MathFilter", "Addition"),
                                "value"   : 3
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "-"),
                                "desc"    : qsTranslate("MathFilter", "Subtraction"),
                                "value"   : 4
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "<<"),
                                "desc"    : qsTranslate("MathFilter", "Left shift"),
                                "value"   : 5
                            },
                            {
                                "varName" : qsTranslate("MathFilter", ">>"),
                                "desc"    : qsTranslate("MathFilter", "Right shift"),
                                "value"   : 6
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "&"),
                                "desc"    : qsTranslate("MathFilter", "Bit AND"),
                                "value"   : 7
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "^"),
                                "desc"    : qsTranslate("MathFilter", "Exclusive OR"),
                                "value"   : 8
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "|"),
                                "desc"    : qsTranslate("MathFilter", "Bit OR"),
                                "value"   : 9
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "&&"),
                                "desc"    : qsTranslate("MathFilter", "Logical AND"),
                                "value"   : 10
                            },
                            {
                                "varName" : qsTranslate("MathFilter", "||"),
                                "desc"    : qsTranslate("MathFilter", "Logical OR"),
                                "value"   : 11
                            }]
                    });
    }

    function setTitle() {
        var opStr    = parametersModel.get(2).varName

        if (opStr.length === 0)
            opStr = qsTr("Mathematics");

        actionTitle = qsTr("%1").arg(opStr);
    }
}
