import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramEvent
    objectName: "diagramEvent_IncomingEvent"

    // unique for every event
    actionId: 0x09
    actionName: QT_TRANSLATE_NOOP("IncomingEvent", "IncomingEvent")
    actionTitle: qsTr("Incoming event:\n???")
    actionToolTip: qsTr("Incoming event from data channel")

    actionType: "systemEvent"
    actionColor: colorEvent
    actionTextColor: colorTextEvent

    permanentParametersCount: 3
    nonPermanentParameterName: QT_TRANSLATE_NOOP("IncomingEvent", "Argument")
    nonPermanentParamType: "int|float"
    nonPermanentVarCategory: "global"

    parametersModel: ListModel {

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement { // 0
            paramName: qsTr("Group")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 1
            paramName: qsTr("Project")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 2
            paramName: QT_TRANSLATE_NOOP("IncomingEvent", "Event filter")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
   }

    function setTitle() {
        var str = qsTr("Incoming event:\n\"%1\"")
                .arg(parametersModel.get(2).varName);
        var strArgs = "";
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            strArgs += "\n" + parametersModel.get(i).varName;
        }

        if (strArgs.length)
            actionTitle = str + qsTr("\nArguments:") + strArgs;
        else
            actionTitle = str + qsTr("\nWithout arguments");
    }
}
