import { lighten } from 'polished';
import styled from 'styled-components';
import { COLORS } from '../../constants/colors';

export const ButtonStyled = styled.button`
  position: relative;
  min-width: 80px;
  color: ${COLORS.background};
  background: ${COLORS.color4};
  border: none;
  outline: none;
  padding: 8px;
  cursor: pointer;
  text-transform: uppercase;
  text-align: center;
  transition: background-color 0.1s ease-in-out;

  &:hover,
  &:focus {
    background-color: ${lighten(0.1, COLORS.color4)};
  }

  &:disabled {
    color: ${COLORS.foreground};
    background: ${COLORS.color8};
    cursor: default;
  }
`;
