import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_RunEvent"

    // unique for every action
    actionId: 0x2A
    actionName: QT_TRANSLATE_NOOP("RunEvent", "RunEvent")
    actionTitle: qsTr("Run event:\n\???");
    actionOutputCount: 2
    actionFormType: Action.ActionForm.Parallelogram

    permanentParametersCount: 6
    nonPermanentParameterName: qsTr("Argument")
    nonPermanentParamType: "int|float"
    nonPermanentVarCategory: "global|localConst"

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement { // 0
            paramName: qsTr("Group")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 1
            paramName: qsTr("Project")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 2
            paramName: qsTr("Event name")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 5
            paramName: qsTr("Left time [ms]")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        Component.onCompleted: {
            parametersModel.insert(3, // 3
                        {
                            "paramName": qsTr("Event scope"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": qsTr("External"),
                            "varBaseCategory": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTr("External"),
                                    "value"   : 0
                                }]
                        });

            parametersModel.insert(4, // 4
                        {
                            "paramName": qsTr("Delivery method"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": qsTr("Publish/Subscribe"),
                            "varBaseCategory": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTr("Publish/Subscribe"),
                                    "value"   : 0
                                },
                                {
                                    "varName" : qsTr("Request/Response"),
                                    "value"   : 1
                                }]
                        });
        }


        function setTitle() {
           var messageStr = parametersModel.get(2).varName

            if (messageStr.length === 0)
                messageStr = qsTr("???")

            var str = qsTr("Run event:\n\"%1\"").arg(messageStr);
            for (var i = permanentParametersCount; i < parametersModel.count; ++i) {
                str += "\n" + qsTranslate("RunEvent", nonPermanentParameterName)
                    + ": " + parametersModel.get(i).varName;
            }
            actionTitle = str;

        }
    }
}
