import styled, { createGlobalStyle } from 'styled-components';

export const GlobalStyle = createGlobalStyle`
  body {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
    font-size: 14px;
    line-height: 18px;
    padding: 0;
    margin: 0;
    width: 100%;
    height: 100%;
    max-width: 100vw;
    min-height: 100vh;
    background: #f7f7f7;
    color: #090300;
  }

  #root {
    display: flex;
    height: inherit;
    min-height: inherit;
  }
`;

export const AppWrapper = styled.div`
  display: flex;
  flex-flow: column nowrap;
  width: 100%;
  height: auto;
`;

export const Container = styled.div`
  display: flex;
  flex-flow: column nowrap;
  justify-content: center;
  width: 100%;
  height: 100%;
  max-width: 1000px;
  margin: 0 auto;
`;
