﻿import QtQuick 2.0;

Rectangle {
    id: linePrimitive

    property alias lineArea: mouseArea
    property int actualX
    property int actualY
    property int actualLength
    property int actualThickness
    property int orientation: Qt.Horizontal // Qt.Horizontal or Qt.Vertical

    x: actualX - ((orientation === Qt.Horizontal) ? 0 : width/2)
    y: actualY - ((orientation === Qt.Vertical)   ? 0 : height/2)
    width:  orientation === Qt.Horizontal ? actualLength    : actualThickness
    height: orientation === Qt.Horizontal ? actualThickness : actualLength
    antialiasing: true

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        anchors.margins: -2
        hoverEnabled: true
        acceptedButtons: Qt.NoButton
    }
}
