import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramEvent
    objectName: "diagramEvent_IncomingCommand"

    // unique for every event
    actionId: 0x04
    actionName: QT_TRANSLATE_NOOP("IncomingCommand", "IncomingCommand")
    actionTitle: qsTr("Incoming command:\n???")
    actionToolTip: qsTr("Incoming command from data channel")

    actionType: "systemEvent"
    actionColor: colorEvent
    actionTextColor: colorTextEvent

    permanentParametersCount: 1
    nonPermanentParameterName: QT_TRANSLATE_NOOP("IncomingCommand", "Argument")
    nonPermanentParamType: "int|float"
    nonPermanentVarCategory: "global"

    parametersModel: ListModel {

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("IncomingCommand", "Command filter")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
   }

    function setTitle() {
        var str = qsTr("Incoming command:\n\"%1\"")
                .arg(parametersModel.get(0).varName);
        var strArgs = "";
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            strArgs += "\n" + parametersModel.get(i).varName;
        }

        if (strArgs.length)
            actionTitle = str + qsTr("\nArguments:") + strArgs;
        else
            actionTitle = str + qsTr("\nWithout arguments");
    }
}
