import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: mathParametersDialog
    objectName: "mathParametersDialog"

    property int operationParamWidth: Math.round(200 * kDPI)

    width:  operationParamWidth
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        var l_height = titleHeight
                + parameterItemHeight
                + parameterItemSpacing
        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView
        RowLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            height: parameterItemHeight
            spacing: parameterItemSpacing

            VarNameItem {
                width: operationParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 2
            }
        }
    }
}
