import QtQuick 2.0
import "itemCreation.js" as Code

/// Это длегат который обрабатывает элементы моделей ActionsModel, EventsModel
/// внутри этого делегата доступны свойства элементов обрабатываемой модели
/// А именно:
/// name - название элемента
/// image - картинка элемента
/// source - путь к qml файлу который создает элементы которые выводятся в виджет
Item {
    id: actionItem
    height: Math.round(24 * kDPI)
    implicitWidth: parent.width
    anchors.horizontalCenter: parent.horizontalCenter

    property var view: ListView.view
    property var model: ListView.view.model

    Rectangle {
        id: offsetRectangle
        anchors.left: parent.left
        width:  Math.round(16 * kDPI)
        height: parent.height
        color: colorGroup
    }

    Rectangle {
        id: actionHoverRect

        anchors.fill: parent
        border.color: colorScrollBorder
    }
    Image {
        id: idImage

        anchors.left: (view.objectName === "listViewSubgroup") ? offsetRectangle.right : parent.left
        anchors.leftMargin: diagramContainer.diagramField.linesGridSize
        anchors.verticalCenter: parent.verticalCenter
        source: image
        sourceSize.width: Math.round(15 * kDPI)
        sourceSize.height: Math.round(6 * kDPI)
    }
    Text {
        id: actionItemText

        anchors.left: idImage.right
        anchors.leftMargin: diagramContainer.diagramField.linesGridSize
        anchors.right: parent.right
        anchors.rightMargin: diagramContainer.diagramField.linesGridSize
        anchors.verticalCenter: parent.verticalCenter
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        font.family: "Verdana"
        font.pointSize: 8
        font.letterSpacing: 0.5
        color: colorTextPanel
        text: qsTranslate(model.objectName, name)
    }
    MouseArea {
        id: mouseArea

        anchors.fill: parent
        hoverEnabled: true

        onPressed: {
            actionItem.forceActiveFocus();
            leftPanelInteractive = false
            console.debug('actionItem['+index+']: ' + actionItem.x + ' ' + actionItem.y)
            Code.startDrag(actionItem, source, mouse);
        }
        onPositionChanged: {
            Code.continueDrag(mouse);
        }
        onReleased: {
            Code.endDrag(mouse);
            leftPanelInteractive = true
        }
        onCanceled: {
            Code.cancelDrag();
            leftPanelInteractive = true
        }
    }
}
